<?php require('includes/finance/finance_functions.php');
//////////////////////////
/// PAYMENT STATUS     ///
/// 1 - Unpaid         ///
/// 2 - Reminder       ///
/// 3 - Paid           ///
/// 4 - Refund         ///
//////////////////////////

$stmt = $GLOBALS['con']->prepare("SELECT `invNo` FROM `invoices` WHERE invNo=(SELECT MAX(invNo) FROM `invoices`)")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$i=$stmt->get_result();$stmt->close();
$latest=mysqli_fetch_array($i);
$latestId=$latest['invNo'];

$stmt = $GLOBALS['con']->prepare("SELECT * FROM `invoices` WHERE `status`='1' or `status`='2' ORDER BY abs(invno) ASC")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$i=$stmt->get_result();$stmt->close();
while($id=mysqli_fetch_array($i)){$data[]=$id;}
?>

<script>
$('#navBox').html('<li class="breadrumb-item"><a href="index.php?t=includes/finance&p=finance_invoices.php">Finance - Invoices</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadrumb-item active">Outstanding</li>')
</script>
<div id="invoiceData" class="mt-0 mt-md-n5">
<p class="blockquote reportHeader"><span class="float-right remove"><a class="btn btn-secondary" href="index.php?t=includes/finance&p=invoiceUnPaid_reports.php"><i class="fad fa-file-invoice"></i> View Reports </a></span>You can print or action responses for all outstanding invoices.<br><small class="remove">To manually mark as paid, select the payment method used before applying the confirmation.</small>

</p>

<table id="expenseTable" class="table table-striped table-sm responsive" width="100%">
<thead>
<tr><th>Invoice Number</th><th>Client</th><th>Agent/Broker</th><th>Contract Number</th><th>Amount</th><th>Date of Invoice</th><th>Status</th><th class="noExport noprint">Payment Type</th><th class="noExport noprint">Payee</th><th>Date Paid</th><th style="width:80px" class="noExport noprint"></th></tr>
</thead>
<tbody>
<?php foreach($data as $id){
$emailString='';
if(file_exists('invoices/'.$id['invNo'].'_broker.zip')){$broker="yes";}else{$broker="no";}
$address = unserialize($id['address']);
$items = unserialize($id['items']);
$totals=explode('|',$id['totals']);

$sub=str_replace(',','',$totals[0]);
$vat=str_replace(',','',$totals[1]);
$gtotal=$sub;
$invno="";
$invno=sprintf("%06d", $id['invNo']);
if($id['date_due']>$now){$status='<span class="badge badge-secondary m-0 mt-2" style="font-size:12px; display:block">OUTSTANDING</span>';}
if($id['date_due']<$now){$status='<span class="badge badge-danger m-0 mt-2" style="font-size:12px; display:block">OVERDUE</span>';}
//////////////////////////////
//	MAILER OPTIONS d[]		//
//							//
//		[0] client			//
//		[1] type			//
//		[2] recipient		//
//		[3] subject			//
//		[4] message			//
//		[5] attachment		//
//		[6] source		    //
//		[7] recipient 2		//
//		[8] invoice ID		//
//							//

$stmt = $GLOBALS['con']->prepare("SELECT * FROM `clientdetails` WHERE `clientnumber`=?")or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i',$id['client']);$stmt->execute();$iv=$stmt->get_result();$stmt->close();
$cd=mysqli_fetch_array($iv);

if($id['target']=='client'){
    $clientName=str_replace('&','',$cd['clientname']);
    $billingName=str_replace('&','',$cd['billing_name']);
    $emailString=$id['client'].'|'.$billingName.'|'.$cd['billing_email'].'|'.$clientName.' Invoice |Your invoice number '.$invno.'|invoices|'.$id['invNo'].'_invoice.pdf||'.$id['invNo'];
    $nameRow='<a href="index.php?t=includes/master&p=client.php&clientnumber='.$address['client_name'].'&view=edit">'.getClientName($address['client_name']).'</a>';
    $abRow='<a href="index.php?t=includes/master&p=agent.php&agent_number='.getAgentId($address['agent_name']).'&view=edit">'.$address['agent_name'].'</a>';
    $payValues= $id['invNo'].'|£'.number_format($gtotal,2).'|'.$address['client_name'];
}

if($id['target']=='agent'){
    $clientName=str_replace('&','',$cd['clientname']);
    $billingName=str_replace('&','',$ad['billing_name']);
    $stmt2 = $GLOBALS['con']->prepare("SELECT * FROM `agents` WHERE `agent_number`=?")or die(mysqli_error($GLOBALS['con']));
    $stmt2->bind_param('i',$cd['agent_number']);$stmt2->execute();$avs=$stmt2->get_result();$stmt2->close();
    $ad=mysqli_fetch_array($avs);
    $agent='1';
    $emailString=$id['client'].'|'.$billingName.'|'.$ad['billing_email'].'|'.$clientName.' Invoice |Your invoice number '.$invno.'|invoices|'.$id['invNo'].'_agent.pdf|'.$ad['email'].'|'.$id['invNo'];
    $nameRow='<a href="index.php?t=includes/master&p=client.php&clientnumber='.$address['client_name'].'&view=edit">'.getClientName($address['client_name']).'</a>';
    $abRow='<a href="index.php?t=includes/master&p=agent.php&agent_number='.$ad['agent_number'].'&view=edit">'.$ad['agent_name'].'</a>';
    $payValues= $id['invNo'].'|£'.number_format($gtotal,2).'|'.$address['client_name'];
    $agent='1';
}

if($id['target']=='broker'){
    $clientName=str_replace('&','',$cd['clientname']);
    $billingName=str_replace('&','',$ad['billing_name']);
    $stmt2 = $GLOBALS['con']->prepare("SELECT * FROM `brokers` WHERE `broker_number`=?")or die(mysqli_error($GLOBALS['con']));
    $stmt2->bind_param('i',$cd['broker_number']);$stmt2->execute();$avy=$stmt2->get_result();$stmt2->close();
    $ad=mysqli_fetch_array($avy);
    $emailString=$id['client'].'|'.$billingName.'|'.$ad['billing_email'].'|'.$clientName.' Invoice |Your invoice number '.$invno.'|invoices|'.$id['invNo'].'_broker.zip|'.$ad['email'].'|'.$id['invNo'];
    $nameRow='<a href="index.php?t=includes/master&p=client.php&clientnumber='.$address['client_name'].'&view=edit">'.getClientName($address['client_name']).'</a>';
    $abRow='<a href="index.php?t=includes/master&p=broker.php&broker_number='.$cd['broker_number'].'&view=edit">'.$ad['broker_name'].'</a>';
    $payValues= $id['invNo'].'|£'.number_format($gtotal,2).'|'.$address['client_name'];
    $broker='1';
}

if($id['target']=='blank'){
    $clientName=str_replace('&','',$address['billing_name']);
    $billingName=str_replace('&','',$address['billing_name']);
    $emailString=$id['client'].'|'.$billingName.'|'.$address['email'].'|'.$clientName.' Invoice |Your invoice number '.$invno.'|invoices|'.$id['invNo'].'_invoice.pdf||'.$id['invNo'];
    $payValues= $id['invNo'].'|£'.number_format($gtotal,2).'|'.$clientName.'|blank|'.$address['email'];
    $nameRow=$billingName;
    $abRow='';   
    $blank='1';
}


if($id['sent']==0){$delivered='
<a class="badge badge-warning emailButton m-0 px-2 mr-3 text-dark" style="font-size:12px;" data-values="'.$emailString.'" data-href="includes/master/financeMailer.php" data-toggle="tooltip" data-placement="top" data-original-title="Email Client Invoice">NOT SENT</a>
<a class="badge badge-dark m-0 px-1" style="font-size:12px;" data-toggle="tooltip" data-placement="top" data-original-title="Mark as Sent" onclick="markSent(\''.$id['invNo'].'\')">M</a>';}


if($id['sent']==1){$delivered='<span class="badge badge-success m-0" style="font-size:12px; display:block">SENT</span>';}

if($latestId==$id['invNo']){$latestTag='<a href="javascript:void(0)" type="button" id="deleteButton'.$id['invNo'].'" class="btn btn-sm btn-danger deleteButton m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="Remove Invoice" data-values="'.$id['invNo'].'"><i class="fad fa-trash"></i></a>';}
else{$latestTag='';}
?>
<tr id="R<?php echo $invno?>">
<td class="align-middle"><?php echo $invno?></td>
<td class="align-middle" style="max-width:250px"><?php echo $nameRow?></td>
<td class="align-middle" style="max-width:250px"><?php echo $abRow?></td>
<td class="align-middle"><?php echo $address['contract_number']?></td>
<td class="align-middle">£<?php echo number_format($gtotal,2)?></td>
<td class="align-middle"><?php echo date('d-m-Y',$id['date'])?></td>
<td class="align-middle text-center text-dark"><span id="em<?php echo $id['invNo']?>"><?php echo $delivered?></span><?php echo PHP_EOL.$status?></td>
<td class="noprint align-middle">
<select id="payment_type_<?php echo $id['invNo']?>" class="form-control ptype">
<option value="0">NONE</option>
<option value="BACS">BACS</option>
<option value="CHEQUE">CHEQUE</option>
<option value="CASH">CASH</option>
<option value="PAYPAL">PAYPAL</option>
<option value="CREDIT">CREDIT</option>
</select>
<div style="display: none" id="P<?php echo $invno?>" class="cno"><input id="chequeNo_<?php echo $id['invNo']?>" type="text" class="form-control chequeNo" name="chequeNo_<?php echo $id['invNo']?>" placeholder="Cheque Number"></div>
</td>

<td class="noExport noprint align-middle">
<select id="payee_<?php echo $id['invNo']?>" class="form-control ptype" name="payee">
<option value="C_<?php echo $id['client']?>" <?php if($id['target']=="client"){?>SELECTED<?php }?>>Client</option>
<option value="A_<?php echo $id['agent']?>" <?php if($id['target']=="agent"){?>SELECTED<?php }?>>Agent</option>
<option value="B_<?php echo $id['broker']?>" <?php if($id['target']=="broker"){?>SELECTED<?php }?>>Broker</option>
<option value="BL_<?php echo $id['invNo']?>" <?php if($id['target']=="blank"){?>SELECTED<?php }?>>Other</option>
</select>
</td>
<td class="align-middle">
<div class="md-form md-outline bg-white input-with-post-icon">
  <input id="payment_date_<?php echo $id['invNo']?>" placeholder="Select date" type="text"  class="form-control renewDatepicker">
   <i class="fas fa-calendar input-prefix" tabindex=0></i>
</div>
</div>
   
</td>

<td class="noExport noprint">
    <div class="d-flex flex-wrap flex-row justify-content-around">
<?php if($id['date_due']<$now){ ?><button type="button" class="emailButton btn btn-sm btn-secondary noprint m-0 px-2 py-2 mb-2 waves-effect waves-light" data-values="<?php echo $address['client_name']?>|<?php echo $address['billing_name']?>|<?php echo $address['email']?>|<?php echo getCompanyDetails('name_short')?> Invoice |Your invoice reminder for invoice <?php echo $invno?>|invoices|<?php echo $id['invNo']?>_remind.pdf" data-href="includes/master/financeMailer.php" data-toggle="tooltip" data-placement="top" data-original-title="Email Client Reminder"><i class="fad fa-envelope"></i></button><?php }?>

<a id="phone" href="tel:<?php echo getClientContact($address['client_name'],'phone')?>" class="btn btn-sm btn-secondary noprint m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="Phone Client"><i class="fad fa-phone"></i></a> 

<a href="index.php?t=includes/finance&p=finance_preview.php&invNo=<?php echo $id['invNo']?>&type=outstanding" class="btn btn-sm btn-secondary noprint m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="View Invoice"><i class="fad fa-eye"></i></a>

<a href="index.php?t=includes/finance&p=finance_invoices-edit.php&invNo=<?php echo $id['invNo']?>" class="btn btn-sm btn-secondary m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="Edit Invoice"><i class="fad fa-edit"></i></a>

<a href="javascript:void(0)" id="paidButton<?php echo $id['invNo']?>" class="btn btn-sm btn-outline-success success-color-dark paidButton m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-target="<?php echo $id['target']?>" data-placement="top" data-original-title="Mark as paid" data-values="<?php echo $payValues?>"><i class="fab fa-paypal"></i></a>

<a href="javascript:void(0)" type="button" id="removeButton<?php echo $id['invNo']?>" class="btn btn-sm btn-outline-danger removeButton m-0 px-2 py-2 mb-2 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="Void Invoice" data-values="<?php echo $id['invNo']?>|£<?php echo number_format($gtotal,2)?>"><i class="fad fa-ban"></i></a>
<?php echo $latestTag?>
</div>
</td>

</tr>

<?php 
$mTotal=$mTotal+$gtotal;
}?>
</tbody>

</table>
</div>

<div id="exportDiv" style="display: none">
    <div id="exportTitle">Invoices Unpaid - <small>Generated <?php echo date('d-m-Y')?></small></div>
    <table id="exportTable" class="table table-striped table-sm responsive" width="100%">
    <thead>
        <tr><th>Invoice Number</th><th>Client</th><th>Agent</th><th>Contract Number</th><th>Amount</th><th>Date of Invoice</th></tr>
    </thead>
    <tbody>
        <?php foreach($data as $id){
        if(file_exists('invoices/'.$id['invNo'].'_broker.zip')){$broker="yes";}else{$broker="no";}
        $address = unserialize($id['address']);
        $items = unserialize($id['items']);
        $totals=explode('|',$id['totals']);
        $sub=str_replace(',','',$totals[0]);
        $vat=str_replace(',','',$totals[1]);
        $gtotal=$sub+$vat;
        $invno="";
        $invno=sprintf("%06d", $id['invNo']);
        ?>
        <tr id="R<?php echo $invno?>">
            <td><?php echo $invno?></td>
            <td><?php echo getClientName($address['client_name'])?></td>
            <td><?php echo $address['agent_name']?></td>
            <td><?php echo $address['contract_number']?></td>
            <td>£<?php echo $totals[0]?></td>
            <td><?php echo date('d-m-Y',$id['date'])?></td>
        </tr>
        <?php }?>
    </tbody>

    </table>
</div>

<div id="genRow" class="col-md-12 text-center remove">
<button id="expenseReport" type="button" class="btn btn-secondary"><i class="fad fa-file-chart-line"></i> GENERATE REPORT</button>
</div>

<?php
$rowAlignments="
doc.content[1].table.body[i][3].alignment = 'right';
";
$table="expenseTable";
require('includes/single_table.engine');
?>
<div class="spacer"></div>
<div class="alert alert-info float-right">Total Outstanding:<span class="float-right">£<?php echo number_format($mTotal,2)?></span></div>



<script>
function loadInvoice(type,inv){
    window.open('invoices/'+inv+'_'+type+'.pdf');
}

function markSent(invoice){
    confirmBox('Send Invoice','Mark this invoice as sent?','confirmSent(\''+invoice+'\')')
}

function confirmSent(invoice){    
    $.post('includes/finance/finance_functions.php',{FUNCTION:'setDelivered',inv:invoice},function(data){
        $('#confirmBox').modal('hide');
        response('success','Set as delivered successfully');
    $('#em'+invoice).html('<span class="badge badge-success m-0" style="font-size:12px; display:block">SENT</span>')
    })
}

$('#expenseTable').on('click', '.emailButton', function(){
$('#popupBox .modal-body').html(''); 
var eTarget = $(this).data('target');
var target = $(this).data('href');
var string = $(this).data('values');
var dest=encodeURI(target+"?mode=popup&data="+string)
$('#popupBox').modal('show');
$('#popupBox .modal-body').load(dest);
})


<?php if(isContract()=="yes"){$payContractOption=",'Mark Paid and Renew','setPaidAndRenew(\''+d[0]+'\',\''+d[2]+'\')'";}
else{$payContractOption=",'NULL','NULL'";}
?>
$('#expenseTable').on('click', '.paidButton', function(){
    var eTarget = $(this).data('target');
    var str = $(this).data('values');
    var d = str.split("|");
    var paid=$('#payment_type_'+d[0]).val();
    var date=$('#payment_date_'+d[0]).val();
    if(paid==0 || date==""){
        response('warning','PLEASE SELECT A PAYMENT METHOD AND DATE')
        $('#payment_type_'+d[0]).focus()
    }
    else{
        multiConfirmBox('Confirm Payment','Are you sure this invoice for <b>'+d[1]+'</b> has been paid?','Mark Paid','setPaid(\''+d[0]+'\',\''+d[2]+'\',\''+eTarget+'\')'<?php echo $payContractOption?>)
    }
})


$('#expenseTable').on('click', '.deleteButton', function(){
var str = $(this).data('values');
confirmBox('Void Invoice','Are you sure this invoice is to be deleted and numbering reset?<br><span class="text-danger"><small>THIS CANNOT BE UNDONE</small></span>','setDelete(\''+str+'\')')
})

function setDelete(i){
$.post('includes/finance/finance_functions.php',{FUNCTION:'setDelete',inv:i},function(data){
if($.trim(data)=="success"){
var inv=pad(i, 6);
$('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
response('success','The invoice has been deleted and numbering reset to '+i)
$('#confirmBox').modal('hide')
setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
}
})
}


$('#expenseTable').on('click', '.removeButton', function(){
var str = $(this).data('values');
var d = str.split("|");
confirmBox('Void Invoice','Are you sure this invoice is to be voided?','setArchive(\''+d[0]+'\')')
})

function setPaid(i,c,f){
var invoice=i;
var paid=$('#payment_type_'+i).val();
var date=$('#payment_date_'+i).val()
var cno=$('#chequeNo_'+i).val();
var pe=$('#payee_'+i).val();
// SEND EMAIL


if(f=="blank"){
    $.post('includes/finance/finance_functions.php',{FUNCTION:'setPaid',inv:i,payment_type:paid,chequeNo:cno,payee:pe,date:date},function(data){
        if($.trim(data)=="success"){
    var inv=pad(i, 6);
        $('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
        response('success','The invoice has been set to Paid')
        $('#confirmBox').modal('hide')
        setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
        }
    })

}
else{
    $.post('includes/finance/finance_functions.php',{FUNCTION:'setPaid',inv:i,payment_type:paid,chequeNo:cno,payee:pe,date:date},function(data){//debug(data)
        if($.trim(data)=="success"){
        // SEND EMAIL
        
        $.post('includes/finance/finance_functions.php',{FUNCTION:'getEmailDetails',client:c,target:f},function(ret){
        data=$.trim(ret)
        data=data.split('|')
        $('#popupBox .modal-body').html(''); 
        var target = 'includes/master/financeMailer.php';
        var string = data[0]+'|'+data[1]+'|'+data[2]+'| Invoice Payment Confirmation |Thankyou for your payment for invoice:'+invoice;
        var dest=encodeURI(target+"?mode=popup&data="+string)
        $('#popupBox').modal('show');
        $('#popupBox .modal-body').load(dest);

        })

        ///
        var inv=pad(i, 6);
        $('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
        response('success','The invoice has been set to Paid')
        $('#confirmBox').modal('hide')
        setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
        }
    })
}
}


function setPaidAndRenew(i,c){
var invoice=i;
var paid=$('#payment_type_'+i).val();
var cno=$('#chequeNo_'+i).val();
var pe=$('#payee_'+i).val();
$.post('includes/finance/finance_functions.php',{FUNCTION:'setPaidAndRenew',inv:i,payment_type:paid,chequeNo:cno,payee:pe},function(data){
if($.trim(data)=="success"){
// SEND EMAIL
$.post('includes/finance/finance_functions.php',{FUNCTION:'getEmailDetails',client:c},function(ret){
data=$.trim(ret)
data=data.split('|')
$('#popupBox .modal-body').html(''); 
var target = 'includes/master/financeMailer.php';
var string = data[0]+'|'+data[1]+'|'+data[2]+'| Invoice Payment Confirmation |Thankyou for your payment for invoice:'+invoice+'\nYour contract has been renewed successfully.';
var dest=encodeURI(target+"?mode=popup&data="+string)
$('#popupBox').modal('show');
$('#popupBox .modal-body').load(dest);

})

///
var inv=pad(i, 6);
$('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
response('success','The invoice has been set to Paid')
$('#confirmBox').modal('hide')
setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
}
})
}

function setArchive(i){
$.post('includes/finance/finance_functions.php',{FUNCTION:'setArchive',inv:i},function(data){
if($.trim(data)=="success"){
var inv=pad(i, 6);
$('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
response('success','The invoice has been voided')
$('#confirmBox').modal('hide')
setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
}
})
}

$('.ptype').change(function(){
var sel=$(this).val();
if(sel=="CHEQUE"){
$(this).closest('td').find('.cno').css('display','block')

}
if(sel!="CHEQUE"){
$(this).closest('td').find('.chequeNo').val('')
$(this).closest('td').find('.cno').css('display','none')
}

})

$('#expenseReport').click(function(){
var start=$('#sdate').val()
var end=$('#edate').val()
data=$('#exportDiv').html()
//debug(data)
$.post('includes/engines/report.php',{'clientnumber':'000',type:'invoicesUnPaid_generated_<?php echo date('d-m-Y')?>',content:data, format:'L'},function(ret){//debug(ret)
$('#genRow').html('<a href="output/reps/000_invoicesUnPaid_generated_<?php echo date('d-m-Y')?>.pdf" target="blank" class="btn btn-info"><i class="fad fa-file-pdf"></i> VIEW REPORT</a>')
})

})
</script>



