<?php require('includes/finance/finance_functions.php');?>

<div class="row mt-n5">

  <div class="col-md-4 border-right grey lighten-3 p-2">
    <h3>New Receipt Registration</h3>
    <form id="receiptsForm">
      <div class="row">

        <div class="col-12 col-md-4">
          <div class="col-12 "><label for="date">Date</label></div>
          <div class="col-12"><input class="form-control datepicker" type="text" name="date" id="date" value="<?php echo date('d-m-Y')?>" /></div>
        </div>

        <div class="form-group col-12 col-md-8">
          <div class="col-12"><label for="payee">Payee</label></div>
            <div class="row">
              <div class="col-7">
                <select class="form-control form-control-sm autocomplete w-100" id="payee" name="payee" data-placeholder="Select Payee"><?php echo listPayee('in')?></select>
              </div>
              <div class="col-3">
                <button type="button" id="newPayee" class="btn btn-secondary btn-sm   m-0 px-3 py-2 z-depth-0 border" data-href="includes/finance/finance_newPayee.php?type=in" data-values="in" data-toggle="tooltip" data-placement="top" data-original-title="Register New Payee"><span class="fa-layers fa-fw"><i class="fal fa-plus" data-fa-transform="left-4" style="color:green"></i><i class="fad fa-user-cog" data-fa-transform="right-4"></i></span></button>
              </div>
            </div>  
          </div>        
        </div>

        <div class="form-group">
          <div class="col-12 "><label for="payee">Details</label></div>
          <div class="col-12">
            <textarea class="form-control" id="details" name="details" rows="3"></textarea>
          </div>
        </div>

      <div class="row">

        <div class="col-12 col-md-6">
          <div class="form-group">
            <label class="col-12 control-label" for="payment_method">Payment Method</label>
            <div class="col-12">
              <select class="form-control autocomplete payMethod" name="payment_method">
                <option value="Cash">Cash</option>
                <option value="Card">Card</option>
                <option value="Cheque">Cheque</option>
                <option value="Direct Debit">Direct Debit</option>
                <option value="Counter Credit">Counter Credit</option>
                <option value="Credit Transfer">Credit Transfer</option>
                <option value="BACS">BACS</option>
              </select>
            </div>
          </div>
        </div>
        
          <div class="col-12 col-md-6">
            <div class="form-group">
              <label class="col-12 control-label ml-n3" for="use_vat">VAT Applicable</label>
              <div class="row">
                <div class="col-12 col-md-6">
                  <label>Inc VAT <input type="radio" class="flat" name="use_vat" value="applyvat" checked >
                </div>
                <div class="col-12 col-md-6">
                  <label>No VAT <input type="radio" class="flat" name="use_vat" value="novat">
                </div>
            </div>
          </div>
          </div>
      </div>



      <div class="form-group row">
      <div class="col-12"><label for="amount">Amount</label></div>
      <div class="col-1 col-md-1"><span class="fal fa-pound-sign lead"></span></div>
      <div class="col-6 col-md-6"><input class="form-control form-control-sm" type="text" name="amount"></div>
      </div>


      <div class="form-group row">
        <div class="col-12"><label for="inv">Invoice Cross Ref</label></div>
        <div class="col-6 col-md-10"><input type="text" id="invoices" class="form-control form-control-sm" name="invoices" value=""></div>
      </div>

    
      <button type="submit" id="btn_save" style="display: none"></button>

      <input type="hidden" id="vatrate" name="vatrate" value="<?php echo getCompanyDetails('vatrate')?>">
      <input type="hidden" id="vRate" name="vRate" value="">
      <input type="hidden" id="vatComponent" name="vat" value="">
      <input type="hidden" id="netComponent" name="net" value="">
      <input type="hidden" name="payment_type" value="<?php echo $_REQUEST['payment_type']?>">
      <input type="hidden" name="FUNCTION" value="register_receipts">
      <button id="reset" type="reset" style="display: none">reset</button>
    </form>
   
  </div>

  <div class="col-md-8 p-2 border">
  <div class="row ml-2">
  <h3>Registered Receipts</h3>
  <div id="expenseList" class="col-12"></div>
  </div>


</div>
<div class="col-12 mb-5">

<p class="lead text-center ">Generated Reports <a href="javascript:void(0)" class="btn btn-secondary m-0 px-3 py-2 z-depth-0 border mt-2" onClick="toggleVisibility('reports');genFiles()"><i class="fal fa-arrow-square-right"></i></a></p>

<div id="reports" class="mb-5 bg-info z-depth-2" style="display: none"></div>
</div>

<script src="packages/fileupload/sortable.min.js" type="text/javascript"></script>
<script src="packages/fileupload/fileinput.min.js" type="text/javascript"></script>
<script src="packages/fileupload/fa_theme.js" type="text/javascript"></script>
<link href="packages/fileupload/fileinput.min.css" media="all" rel="stylesheet" type="text/css"/>
<link href="packages/fileupload/theme.min.css" media="all" rel="stylesheet" type="text/css"/>
<script>
$('.payMethod').click(function(){
var val=$(this).val()
console.log(val)
if(val=="Cheque"){$('#chequeNo').css('display','block')}
else{
$('#chequeInput').val('')
$('#chequeNo').css('display','none')
}

})


$('#receiptsForm').on('click', '#newPayee', function(){
$('#popupBox .modal-body').html(''); 
var target = $(this).data('href');
var string = $(this).data('values');
var dest=encodeURI(target)
$('#popupBox').modal('show');
$('#popupBox .modal-body').load(dest);
})

$("#receiptsForm button[type='submit']").click(function(event){
event.preventDefault();
var t=$("#code")
var p=$("#payee")
var d=$("#receiptsForm textarea[name='details']")
var a=$("#receiptsForm input[name='amount']")

if(p.val()==""){response('danger','<strong>YOU MUST SELECT A PAYEE</strong>')}
if(d.val()==""){response('danger','<strong>YOU MUST ADD A DESCRIPTION</strong>')}
if(a.val()==""){response('danger','<strong>YOU MUST ADD A MONETARY VALUE</strong>')}
if(p.val()!="" && t.val()!="" && d.val()!="" && a.val()!=""){
$.ajax({
url:'includes/finance/finance_functions.php',
type:'POST',
data:$('#receiptsForm').serialize(),
success:function(result){
response('success','Your receipt has been registered successfully')
//debug(result)
var start=$('#date1').val()
var end=$('#date2').val()
$('#expenseList').load('includes/finance/finance_rcp_data.php?start='+start+'&end='+end)
//$('#payee').val('').trigger('change')
$('#reset').click();
}
});
}
});

$('#payee').change(function(){
var n=$(this).val();

$.post('includes/finance/finance_functions.php',{FUNCTION:'checkPayee',name:n},function(data){
var ret=data.split('|')
if(ret[0]==1){
$('#popupBox .modal-body').html(''); 
var target = $(this).data('href');
var string = $(this).data('values');
var dest=encodeURI(target)
$('#popupBox').modal('show');
$('#popupBox .modal-body').load('includes/finance/finance_listInvoices.php',{data:ret[1]});

}
})
})


function genFiles(){
  $('#reports').load('includes/finance/finance_expense_reports.php?payment_type=receipts');

}

$( document ).ready(function() {
  $('#footerControls').html('<button class="btn btn-secondary" onclick="triggerAction(\'btn_save\')">SAVE</button>');
  $('#expenseList').load('includes/finance/finance_rcp_data.php');
  $('#navBox').html('<li class="breadrumb-item"><a href="?t=includes/finance&p=finance_invoices.php">Finance</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadrumb-item active">Receipts</li>');
  genFiles()
})

function regenData(){
  
  $('#expenseList').load('includes/finance/finance_rcp_data.php');

}
</script>