<?php

require_once __DIR__.'/../vendor/autoload.php';
require_once __DIR__.'/../helpers.php';

session_start();

if (
    !isset($_REQUEST['vrn']) ||
    !isset($_REQUEST['period_key']) ||
    !isset($_REQUEST['vat_due_sale']) ||
    !isset($_REQUEST['vat_due_acquisitions']) ||
    !isset($_REQUEST['total_vat_due']) ||
    !isset($_REQUEST['vat_reclaimed_curr_period']) ||
    !isset($_REQUEST['net_vat_due']) ||
    !isset($_REQUEST['total_value_sales_ex_vat']) ||
    !isset($_REQUEST['total_value_purchases_ex_vat']) ||
    !isset($_REQUEST['total_value_goods_supplied_ex_vat']) ||
    !isset($_REQUEST['total_acquisitions_ex_vat'])
) {
    die('ERROR: Please fill vrn, period_key, vat_due_sale, vat_due_acquisitions, total_vat_due, vat_reclaimed_curr_period, net_vat_due, total_value_sales_ex_vat, total_value_purchases_ex_vat, total_value_goods_supplied_ex_vat, total_acquisitions_ex_vat and submit the form again');
}

$finalised = $_REQUEST['finalised'] == '1' ? true : false;

$postBody = new \HMRC\VAT\SubmitVATReturnPostBody();
$postBody->setPeriodKey($_REQUEST['period_key']);
$postBody->setVatDueSales($_REQUEST['vat_due_sale']);
$postBody->setVatDueAcquisitions($_REQUEST['vat_due_acquisitions']);
$postBody->setTotalVatDue($_REQUEST['total_vat_due']);
$postBody->setVatReclaimedCurrPeriod($_REQUEST['vat_reclaimed_curr_period']);
$postBody->setNetVatDue($_REQUEST['net_vat_due']);
$postBody->setTotalValueSalesExVAT($_REQUEST['total_value_sales_ex_vat']);
$postBody->setTotalValuePurchasesExVAT($_REQUEST['total_value_purchases_ex_vat']);
$postBody->setTotalValueGoodsSuppliedExVAT($_REQUEST['total_value_goods_supplied_ex_vat']);
$postBody->setTotalAcquisitionsExVAT($_REQUEST['total_acquisitions_ex_vat']);
$postBody->setFinalised($finalised);

$request = new \HMRC\VAT\SubmitVATReturnRequest($_REQUEST['vrn'], $postBody);
//if (isset($_GET['gov_test_scenario'])) {
//    $request->setGovTestScenario($_GET['gov_test_scenario']);
//}
$response = $request->fire();
$response->echoSubmitHeader();
