<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
ob_start();


if (file_exists('../../../../' . $_REQUEST['tenant'] . '/config.php')) {
    require_once('../../../../' . $_REQUEST['tenant'] . '/config.php');
}
if (file_exists('/config.php')) {
    require_once('/config.php');
}


/* DB */
try {
  $con = $GLOBALS['con'] ?? null;
  if (!$con) throw new Exception('DB not connected');
  $con->set_charset('utf8mb4');

  /* Inputs */
  $invNo     = (int)($_POST['invNo'] ?? 0);
  $client    = (int)($_POST['clientnumber'] ?? 0);
  $broker    = (int)($_POST['broker_number'] ?? 0);
  $agent     = (int)($_POST['agent_number']  ?? 0);
  $vatrate   = (float)($_POST['vatrate'] ?? 0);
  $date      = (int)($_POST['date'] ?? 0);
  $date_due  = (int)($_POST['date_due'] ?? 0);
  $commission_amt = (string)($_POST['commission'] ?? '0');
  $filter    = (string)($_POST['filter'] ?? '');
  $target    = (string)($_POST['target'] ?? 'client');
  $po        = (string)($_POST['purchaseOrder'] ?? '');
  $notes     = (string)($_POST['invoiceNotes'] ?? '');
  $totals    = (string)($_POST['totals'] ?? '0|0');

  if ($invNo <= 0) throw new Exception('Invalid invNo');

  /* Address → PHP-serialized array (legacy format) */
  $address_json = $_POST['address'] ?? '{}';
  $address_arr  = json_decode($address_json, true);
  if (!is_array($address_arr)) $address_arr = [];
  $address_ser  = serialize($address_arr);

  /* Items → serialized JSON string (legacy format like existing records) */
  $items_json = $_POST['items'] ?? '[]';
  $items_ser  = serialize($items_json);

  /* Totals format "net|vat" */
  if (strpos($totals, '|') === false) $totals = '0|0';

  /* Update */
  $sql = "UPDATE invoices SET
            client=?,
            agent=?,
            broker=?,
            address=?,
            items=?,
            totals=?,
            notes=?,
            vatrate=?,
            date=?,
            date_due=?,
            commission=?,
            filter=?,
            target=?,
            purchase_order=?
          WHERE invNo=? LIMIT 1";
  $stmt = $con->prepare($sql);
  if (!$stmt) throw new Exception('Prepare failed: '.$con->error);

  $stmt->bind_param(
    'iiissssiidssssi',
    $client,
    $agent,
    $broker,
    $address_ser,
    $items_ser,
    $totals,
    $notes,
    $vatrate,
    $date,
    $date_due,
    $commission_amt,
    $filter,
    $target,
    $po,
    $invNo
  );
  if (!$stmt->execute()) throw new Exception('Execute failed: '.$stmt->error);
  $stmt->close();

  /* Success */
  ob_end_clean();
  echo json_encode(['status' => 'success', 'invNo' => $invNo]);
  exit;

} catch (Throwable $e) {
  http_response_code(500);
  $leak = ob_get_clean();
  echo json_encode(['status' => 'error', 'message' => $e->getMessage(), 'output' => $leak]);
  exit;
}
