<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// finance_unpaid.php

$T = $_GET['t'] ?? 'includes/finance';
$P = $_GET['p'] ?? 'finance_unpaid.php';
$SELF = 'index.php?t=' . rawurlencode($T) . '&p=' . rawurlencode($P);

$selYear  = isset($_GET['y']) ? (int)$_GET['y'] : 0;
$selMonth = isset($_GET['m']) ? (int)$_GET['m'] : 0;
$fromStr  = trim($_GET['from'] ?? '');
$toStr    = trim($_GET['to'] ?? '');

$loadAll   = isset($_GET['all']) && (int)$_GET['all'] === 1;
$searchQ   = trim($_GET['q'] ?? '');
$hasSearch = ($searchQ !== '');

// Helper: parse dd-mm-yyyy or dd/mm/yyyy → timestamp @ 00:00
$parseDMY = function (string $dmy): ?int {
    $dmy = trim($dmy);
    if ($dmy === '') return null;

    $dmy = str_replace('/', '-', $dmy);
    if (!preg_match('/^\s*(\d{1,2})-(\d{1,2})-(\d{4})\s*$/', $dmy, $m)) return null;
    [$all, $d, $mth, $y] = $m;

    return @mktime(0, 0, 0, (int)$mth, (int)$d, (int)$y) ?: null;
};

$timeMin = null;
$timeMax = null;

// If "Load all" OR Search is active, do NOT apply date window filters
if (!$loadAll && !$hasSearch) {
    if ($fromStr !== '' || $toStr !== '') {
        $fromTs = $fromStr !== '' ? $parseDMY($fromStr) : null;
        $toTs   = $toStr   !== '' ? $parseDMY($toStr)   : null;

        if ($fromTs && $toTs) {
            $timeMin = $fromTs;
            $timeMax = strtotime('+1 day', $toTs); // exclusive
        } elseif ($fromTs && !$toTs) {
            $timeMin = $fromTs;
            $today0  = mktime(0, 0, 0, (int)date('n'), (int)date('j'), (int)date('Y'));
            $timeMax = strtotime('+1 day', $today0);
        } elseif (!$fromTs && $toTs) {
            $timeMax = strtotime('+1 day', $toTs);
        }
    } elseif ($selYear > 0 && $selMonth > 0) {
        $timeMin = mktime(0, 0, 0, $selMonth, 1, $selYear);
        $timeMax = strtotime('+1 month', $timeMin);
    } elseif ($selYear > 0) {
        $timeMin = mktime(0, 0, 0, 1, 1, $selYear);
        $timeMax = strtotime('+1 year', $timeMin);
    } else {
        $timeMin = mktime(0, 0, 0, (int)date('n'), 1, (int)date('Y'));
        $timeMax = strtotime('+1 month', $timeMin);
    }
}

// latest invoice id (for delete button)
$stmt = $GLOBALS['con']->prepare("SELECT `invNo` FROM `invoices` WHERE invNo=(SELECT MAX(invNo) FROM `invoices`)");
$stmt->execute();
$i = $stmt->get_result();
$stmt->close();
$latest = mysqli_fetch_array($i);
$latestId = $latest['invNo'] ?? 0;

// year/month index build from unpaid
$idxSql = "SELECT `date` FROM `invoices` WHERE `status`=1";
$idxStmt = $GLOBALS['con']->prepare($idxSql);
$idxStmt->execute();
$idxRs = $idxStmt->get_result();
$idxStmt->close();

$yrMo = []; // [year => ['total'=>int, 'months'=>[m=>count]]]
while ($r = mysqli_fetch_assoc($idxRs)) {
    $ts = (int)($r['date'] ?? 0);
    if ($ts <= 0) continue;
    $y = (int)date('Y', $ts);
    $m = (int)date('n', $ts);
    if (!isset($yrMo[$y])) $yrMo[$y] = ['total' => 0, 'months' => []];
    $yrMo[$y]['total']++;
    if (!isset($yrMo[$y]['months'][$m])) $yrMo[$y]['months'][$m] = 0;
    $yrMo[$y]['months'][$m]++;
}
krsort($yrMo);
foreach ($yrMo as &$info) { ksort($info['months']); }
unset($info);

// MAIN QUERY (unpaid) + joins for searching
$sql = "
    SELECT i.*
    FROM `invoices` i
    LEFT JOIN `clientdetails` cd ON cd.clientnumber = i.client
    LEFT JOIN `agents` ag ON ag.agent_number = i.agent
    LEFT JOIN `brokers` br ON br.broker_number = i.broker
    WHERE i.`status` = 1
";

$params = [];
$types  = '';

if ($timeMin !== null) {
    $sql .= " AND i.`date` >= ?";
    $params[] = $timeMin;
    $types    .= 'i';
}
if ($timeMax !== null) {
    $sql .= " AND i.`date` < ?";
    $params[] = $timeMax;
    $types    .= 'i';
}

if ($hasSearch) {
    // partial match (case-insensitive)
    $q = strtolower($searchQ);
    $like = '%' . $q . '%';

    if (ctype_digit($searchQ)) {
        $sql .= " AND (
            i.invNo = ?
            OR LOWER(LPAD(i.invNo,6,'0')) LIKE ?
            OR LOWER(cd.clientname) LIKE ?
            OR LOWER(ag.agent_name) LIKE ?
            OR LOWER(br.broker_name) LIKE ?
            OR LOWER(i.address) LIKE ?
        )";
        $params[] = (int)$searchQ; $types .= 'i';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
    } else {
        $sql .= " AND (
            LOWER(LPAD(i.invNo,6,'0')) LIKE ?
            OR LOWER(cd.clientname) LIKE ?
            OR LOWER(ag.agent_name) LIKE ?
            OR LOWER(br.broker_name) LIKE ?
            OR LOWER(i.address) LIKE ?
        )";
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
        $params[] = $like;        $types .= 's';
    }
}

$sql .= " ORDER BY ABS(i.invNo) ASC";

$stmt = $GLOBALS['con']->prepare($sql) or die(mysqli_error($GLOBALS['con']));
if ($types !== '') {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$rs = $stmt->get_result();
$stmt->close();

$data = [];
while ($row = mysqli_fetch_array($rs)) $data[] = $row;
$hasRows = !empty($data);

function monthName(int $m): string {
    static $names = [1=>'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    return $names[$m] ?? (string)$m;
}
?>
<style>
@media (min-width: 992px) {
    .sidebar-hidden #invoiceSidebar {
        display: none !important;
    }

    .sidebar-hidden #invoiceMain {
        flex: 0 0 100% !important;
        max-width: 100% !important;
    }
}

@media (min-width: 992px) {
    #invoiceSidebar {
        height: 75vh;
        border: 1px solid #ccc;
        border-radius: 5px;
        border-right: 5px solid #999;
        box-shadow: 4px 0 8px rgba(0, 0, 0, 0.1);
        background-color: var(--mdb-light-bg-subtle);
        position: sticky;
        top: 0;
    }
}
</style>

<script>
document.getElementById('navBox').innerHTML =
    '<li class="breadcrumb-item"><a href="index.php?t=includes/finance&p=finance_invoices.php">Finance - Invoices</a> ' +
    '<i class="fad fa-angle-double-right mx-2 mt-1"></i></li>' +
    '<li class="breadcrumb-item active">Outstanding Invoices</li>';
</script>

<div id="invoiceData" class="container-fluid px-0">
    <?php
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `invoices` WHERE `status`='1' or `status`='2'");
$stmt->execute();
$i = $stmt->get_result();
$stmt->close();
$unpaidCount = mysqli_num_rows($i);

$stmt = $GLOBALS['con']->prepare("SELECT * FROM `invoices_temp`");
$stmt->execute();
$i = $stmt->get_result();
$stmt->close();
$renewalCount = mysqli_num_rows($i);
?>

    <div class="row">
        <div class="col-12">
            <div class="btn-group me-2 mb-4 active" role="group" aria-label="New Invoice">
                <a href="index.php?t=includes/finance&p=finance_invoices-new.php" class="btn btn-success">New Invoice</a>
            </div>
            <div class="btn-group me-2 mb-4" role="group" aria-label="Blank Invoice">
                <a href="index.php?t=includes/finance&p=finance_invoice_blank.php" class="btn btn-dark">Blank Invoice</a>
            </div>
            <div class="btn-group me-2 mb-4" role="group" aria-label="Unpaid Invoices">
                <a href="index.php?t=includes/finance&p=finance_unpaid.php" class="btn btn-outline-secondary active">
                    Unpaid Invoices <span class="badge rounded-pill bg-dark ms-2"><?= $unpaidCount ?></span>
                </a>
            </div>
            <div class="btn-group me-2 mb-4" role="group" aria-label="Paid Invoices">
                <a href="index.php?t=includes/finance&p=finance_paid.php" class="btn btn-outline-secondary">Paid Invoices</a>
            </div>
            <div class="btn-group me-2 mb-4" role="group" aria-label="Renewal Invoice">
                <a href="index.php?t=includes/finance&p=finance_renewal_invoice.php" class="btn btn-outline-secondary">
                    Renewal Invoice <span class="badge rounded-pill bg-dark ms-2"><?= $renewalCount ?></span>
                </a>
            </div>
            <div class="btn-group me-2 mb-4" role="group" aria-label="Voided Invoices">
                <a href="index.php?t=includes/finance&p=finance_archive.php" class="btn btn-outline-secondary"><span class="text-danger">Voided Invoices</span></a>
            </div>

            <a href="index.php?t=includes/finance&p=invoicePaid_reports.php" class="btn btn-secondary float-end" data-mdb-toggle="tooltip" title="View Reports">
                <i class="fad fa-file-invoice me-1"></i> Create Report
            </a>
        </div>
    </div>

    <div class="mb-2 mb-md-0">
        <div class="note note-light mb-3">
            <strong>You can print or action responses for all outstanding invoices:</strong>
            <small class="mt-1">To manually mark as paid, select the payment method used before applying the confirmation.</small>
        </div>
    </div>

    <div class="row g-3">
        <aside id="invoiceSidebar" class="col-12 col-lg-3 px-3">

            <div class="d-flex d-lg-none justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Filter</h6>
                <button class="btn btn-outline-secondary btn-sm" type="button" data-mdb-collapse-init
                        data-mdb-target="#invIndexCollapse" aria-expanded="false" aria-controls="invIndexCollapse">
                    Toggle
                </button>
            </div>

            <div class="collapse d-lg-block" id="invIndexCollapse">
                <label class="mt-2 mb-2 alert-info d-block px-2">Data Explorer</label>

                <!-- Text Search (action MUST include t/p, so use $SELF directly) -->
                <form class="mb-3" method="get" action="index.php">
                    <input type="hidden" name="t" value="<?= htmlspecialchars($T, ENT_QUOTES) ?>">
                    <input type="hidden" name="p" value="<?= htmlspecialchars($P, ENT_QUOTES) ?>">

                    <div class="mb-3">
                        <a class="btn btn-secondary btn-sm w-100"
                           href="<?= $SELF ?>&y=<?= date('Y') ?>&m=<?= date('n') ?>">
                            This Month (<?= date('M Y') ?>)
                        </a>
                    </div>
                    <div class="input-group">
                        <input
                               type="text"
                               class="form-control"
                               name="q"
                               id="invSearch"
                               value="<?= htmlspecialchars($searchQ, ENT_QUOTES) ?>"
                               placeholder="Search invoice / client / agent / broker"
                               autocomplete="off">

                        <button
                                class="btn btn-secondary"
                                type="submit"
                                data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover"
                                title="Search outstanding invoices">
                            <i class="fad fa-search"></i>
                        </button>

                        <a
                           class="btn btn-danger"
                           href="<?= $SELF ?>"
                           data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover"
                           title="Clear search">
                            <i class="fad fa-times"></i>
                        </a>
                    </div>

                </form>

                <!-- Load all -->
                <div class="mb-3">
                    <a class="btn btn-secondary btn-sm w-100"
                       data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover"
                       title="Load all outstanding invoices"
                       href="<?= $SELF ?>&all=1">
                        <i class="fad fa-list me-1"></i> Load all
                    </a>
                </div>



                <?php $openYear = $selYear ?: (int)date('Y'); ?>

                <!-- Year / Month index -->
                <div class="list-group">
                    <?php if (!empty($yrMo)): foreach ($yrMo as $y => $info):
                        $isOpen = ($y === $openYear);
                        $collapseId = "yearMonths-$y";
                    ?>
                    <div class="mb-2 border rounded">
                        <div class="d-flex align-items-center justify-content-between">
                            <button type="button"
                                    class="list-group-item list-group-item-action py-2 flex-grow-1 text-start border-0 bg-transparent"
                                    data-year-toggle="<?= $y ?>"
                                    aria-controls="<?= $collapseId ?>"
                                    aria-expanded="<?= $isOpen ? 'true':'false' ?>">
                                <span class="me-2">
                                    <i class="fad fa-chevron-<?= $isOpen ? 'down' : 'right' ?>"></i>
                                </span>
                                <?= $y ?>
                                <span class="badge bg-dark ms-2"><?= (int)$info['total'] ?></span>
                            </button>

                            <a class="btn btn-outline-secondary btn-sm me-2"
                               href="<?= $SELF ?>&y=<?= $y ?>"
                               title="View <?= $y ?>">View</a>
                        </div>

                        <div id="<?= $collapseId ?>" class="ps-2 pt-1 collapse <?= $isOpen ? 'show' : '' ?>">
                            <?php foreach ($info['months'] as $m => $cnt): ?>
                            <a class="list-group-item list-group-item-action py-1 <?= ($y === $selYear && $m === $selMonth) ? 'active' : '' ?>"
                               href="<?= $SELF ?>&y=<?= $y ?>&m=<?= $m ?>">
                                <?= monthName($m) ?>
                                <span class="badge bg-light text-dark ms-2"><?= (int)$cnt ?></span>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endforeach; else: ?>
                    <div class="text-muted small">No invoices found.</div>
                    <?php endif; ?>
                </div>

                <!-- Date Range (single form, no nested forms) -->
                <hr class="my-3">
                <form id="rangeForm" class="vstack gap-2" onsubmit="return applyRange(event)">
                    <div class="row">
                        <div class="col-12 col-md-6 date-picker" data-date-type="open" data-format="dd-mm-yyyy" data-mdb-toggle-button="false">
                            <label class="form-label small mb-1">From</label>
                            <input class="form-control form-control-sm" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker"
                                   id="range_from" name="from" placeholder="dd-mm-yyyy" autocomplete="off"
                                   value="<?= htmlspecialchars($fromStr) ?>">
                        </div>
                        <?php $todayDMY = date('d-m-Y'); ?>
                        <div class="col-12 col-md-6 date-picker" data-date-type="open" data-format="dd-mm-yyyy" data-mdb-toggle-button="false">
                            <label class="form-label small mb-1">To</label>
                            <input class="form-control form-control-sm" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker"
                                   id="range_to" name="to" placeholder="dd-mm-yyyy" autocomplete="off"
                                   value="<?= htmlspecialchars($toStr !== '' ? $toStr : $todayDMY) ?>">
                        </div>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-info btn-sm w-100">Search</button>
                        <a href="<?= $SELF ?>" class="btn btn-secondary btn-sm w-100">Reset</a>
                    </div>
                </form>

            </div>
        </aside>

        <!-- Main -->
        <section id="invoiceMain" class="col-12 col-lg-9">
            <div class="col-12 col-lg-3 mx-n2 mb-3">
                <button id="toggleSidebar"
                        type="button"
                        class="btn btn-outline-secondary btn-sm ms-2"
                        data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover"
                        title="Toggle sidebar">
                    <i class="fad fa-columns me-1"></i> <span class="filters-label">Open filters</span>
                </button>
            </div>

            <?php if (!$hasRows): ?>
            <h3 class="text-center text-warning">There are no items to display</h3>
            <p class="text-center text-muted">Use the filter panel to view historic data</p>
            <?php else: ?>

            <div class="row mb-2 px-3">
                <div class="col-12">
                    <?php if ($hasSearch): ?>
                    <div class="alert alert-info py-2 mb-2">
                        Showing results for: <strong><?= htmlspecialchars($searchQ) ?></strong>
                        <a class="ms-2" href="<?= $SELF ?>">Clear</a>
                    </div>
                    <?php elseif ($loadAll): ?>
                    <div class="alert alert-info py-2 mb-2">
                        Showing <strong>all</strong> outstanding invoices.
                        <a class="ms-2" href="<?= $SELF ?>">Return to current month</a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row mb-4 px-3">
                <div class="col-12 mt-3 text-center text-md-start">
                    <button type="button" data-mdb-tooltip-init data-mdb-trigger="hover" data-mdb-placement="bottom"
                            class="btn danger-color-dark text-light filterButtons btn-sm"
                            onclick="addSearch('OVERDUE','expenseTable')"
                            data-mdb-original-title="Filter Overdue invoices">OVERDUE</button>
                    <button type="button" data-mdb-tooltip-init data-mdb-trigger="hover" data-mdb-placement="bottom"
                            class="btn warning-color-dark text-light filterButtons btn-sm"
                            onclick="addSearch('NOT SENT','expenseTable')" data-mdb-original-title="Filter unsent invoices">NOT SENT</button>
                    <button type="button" data-mdb-tooltip-init data-mdb-trigger="hover" data-mdb-placement="bottom"
                            class="btn success-color-dark text-light filterButtons btn-sm"
                            onclick="addSearch('SENT','expenseTable')" data-mdb-original-title="Filter invoices sent">SENT</button>
                    <button type="button" data-mdb-tooltip-init data-mdb-trigger="hover" data-mdb-placement="bottom"
                            class="btn color bg-white filterButtons btn-sm" onclick="clearSearch('expenseTable')"
                            data-mdb-original-title="Reset filters"><i class="fad fa-refresh" aria-hidden="true"></i> Reset Filters</button>
                </div>
            </div>

            <table id="expenseTable" class="table table-striped table-hover align-middle w-100 table-sm">
                <thead class="table-dark">
                    <tr>
                        <th>Invoice #</th>
                        <th>Client</th>
                        <th>Agent/Broker</th>
                        <th>Contract #</th>
                        <th>Amount</th>
                        <th>Date of Invoice</th>
                        <th>Status</th>
                        <th class="noExport">Payment Type</th>
                        <th class="noExport">Payee</th>
                        <th class="noExport">Date Paid</th>
                        <th class="text-end noExport">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                $mTotal = 0;
                foreach ($data as $row):
                    $invNoFormatted = sprintf("%06d", (int)$row['invNo']);
                    $address = @unserialize($row['address']); if (!is_array($address)) $address = [];
                    $totals = explode('|', $row['totals']);
                    $sub = (float)str_replace(',', '', $totals[0] ?? '0');
                    $vat = (float)str_replace(',', '', $totals[1] ?? '0');
                    $grandTotal = $sub + $vat;
                    $invoiceDate = !empty($row['date']) ? date('d-m-Y', (int)$row['date']) : '';
                    $isOverdue = ((int)$row['date_due'] < time());

                    $mTotal += $grandTotal;
                    $grandFmt = number_format($grandTotal, 2);

                    $statusBadge = '';
                    if (!empty($row['sent']) && $row['sent'] != 0) {
                        $statusBadge = $isOverdue ? '<span class="badge bg-danger">OVERDUE</span>' : '';
                    }

                    $nameLink = '';
                    $clientLink = '';

                    // Ensure these exist (avoid warnings on blank invoices)
                    $cd = [];
                    $ad = [];
                    $bd = [];

                    if (($row['target'] ?? '') === 'blank') {
                        $address['contract_number'] = $address['contract_number'] ?? '';
                        $clientLink = '<span>' . htmlspecialchars($address['billing_name'] ?? '') . '</span>';
                    } else {
                        $stmt = $GLOBALS['con']->prepare("SELECT billing_name, billing_email, clientname, clientnumber, email FROM clientdetails WHERE clientnumber=?");
                        $stmt->bind_param('i', $row['client']);
                        $stmt->execute();
                        $cd = $stmt->get_result()->fetch_assoc() ?: [];
                        $stmt->close();

                        $clientLink = '<a href="javascript:void(0)" data-mdb-toggle="tooltip" title="View Statement" ' .
                            'onclick="showStatement(\'client\',' . (int)$row['client'] . ',\'outstanding\')">' .
                            htmlspecialchars($cd['clientname'] ?? '') . '</a>';
                    }

                    $email = $cd['email'] ?? '';
                    $billingEmail = $cd['billing_email'] ?? '';

                    if (($row['target'] ?? '') === 'agent') {
                        $stmt = $GLOBALS['con']->prepare("SELECT agent_name, email, billing_email, agent_number FROM agents WHERE agent_number=?");
                        $stmt->bind_param('i', $row['agent']);
                        $stmt->execute();
                        $ad = $stmt->get_result()->fetch_assoc() ?: [];
                        $stmt->close();
                        $nameLink = '<a href="javascript:void(0)" data-mdb-toggle="tooltip" title="View Statement" ' .
                            'onclick="showStatement(\'agent\',' . (int)$row['agent'] . ',\'outstanding\')">' .
                            htmlspecialchars($ad['agent_name'] ?? '') . '</a>';
                        $email = $ad['email'] ?? $email;
                        $billingEmail = $ad['billing_email'] ?? $billingEmail;
                    } elseif (($row['target'] ?? '') === 'broker') {
                        $stmt = $GLOBALS['con']->prepare("SELECT broker_name, email, billing_email, broker_number FROM brokers WHERE broker_number=?");
                        $stmt->bind_param('i', $row['broker']);
                        $stmt->execute();
                        $bd = $stmt->get_result()->fetch_assoc() ?: [];
                        $stmt->close();
                        $nameLink = '<a href="javascript:void(0)" data-mdb-toggle="tooltip" title="View Statement" ' .
                            'onclick="showStatement(\'broker\',' . (int)$row['broker'] . ',\'outstanding\')">' .
                            htmlspecialchars($bd['broker_name'] ?? '') . '</a>';
                        $email = $bd['email'] ?? $email;
                        $billingEmail = $bd['billing_email'] ?? $billingEmail;
                    }

                    $type = $row['target']; // client, agent, broker, blank
                    $invNo = sprintf("%06d", (int)$row['invNo']);
                    $name = $cd['clientname'] ?? ($ad['agent_name'] ?? ($bd['broker_name'] ?? ''));
                    $subject = "Invoice {$invNo}";
                    $message = "Your invoice is attached.";
                    $filePath = 'invoices';
                    $fileName = match ($type) {
                        'client' => "{$row['invNo']}_invoice.pdf",
                        'broker' => "{$row['invNo']}_broker.zip",
                        default  => "{$row['invNo']}_invoice.pdf",
                    };

                    if (!empty($row['sent'])) {
                        
                         $emailBtn = '<a href="javascript:void(0)" class="emailButton badge bg-success text-light" ' .
                            'data-client-number="' . (int)$row['client'] . '" ' .
                            'data-client-name="' . htmlspecialchars($name ?? '') . '" ' .
                            'data-primary-email="' . htmlspecialchars($email ?? '') . '" ' .
                            'data-secondary-email="' . htmlspecialchars($billingEmail ?? '') . '" ' .
                            'data-subject="' . htmlspecialchars($subject) . '" ' .
                            'data-message="' . htmlspecialchars($message) . '" ' .
                            'data-file-path="' . $filePath . '" ' .
                            'data-file-name="' . $fileName . '" ' .
                            'data-invoice-number="' . $invNo . '" ' .
                            'data-mode="popup" ' .
                            'data-mdb-toggle="tooltip" title="Email Invoice">SENT</a>';
                    } else {
                        $emailBtn = '<a href="javascript:void(0)" class="emailButton badge bg-warning text-light" ' .
                            'data-client-number="' . (int)$row['client'] . '" ' .
                            'data-client-name="' . htmlspecialchars($name ?? '') . '" ' .
                            'data-primary-email="' . htmlspecialchars($email ?? '') . '" ' .
                            'data-secondary-email="' . htmlspecialchars($billingEmail ?? '') . '" ' .
                            'data-subject="' . htmlspecialchars($subject) . '" ' .
                            'data-message="' . htmlspecialchars($message) . '" ' .
                            'data-file-path="' . $filePath . '" ' .
                            'data-file-name="' . $fileName . '" ' .
                            'data-invoice-number="' . $invNo . '" ' .
                            'data-mode="popup" ' .
                            'data-mdb-toggle="tooltip" title="Email Invoice">NOT SENT</a>';
                    }

                    $latestBtn = ($latestId == (int)$row['invNo'])
                        ? '<button class="btn btn-danger btn-sm me-2 removeButton" data-invoiceid="'.$latestId.'" data-mdb-toggle="tooltip" title="Remove Invoice"><i class="fad fa-trash-alt"></i></button>'
                        : '';
                    ?>
                    <tr id="R<?= $invNoFormatted ?>">
                        <td><?= $invNoFormatted ?></td>
                        <td><?= $clientLink ?></td>
                        <td><?= $nameLink ?></td>
                        <td><?= htmlspecialchars($address['contract_number'] ?? '') ?></td>
                        <td>£<?= $grandFmt ?></td>
                        <td><?= $invoiceDate ?></td>
                        <td id="em<?= $invNoFormatted ?>"><?= $emailBtn ?? '' ?> <?= $statusBadge ?></td>

                        <td class="noprint align-middle">
                            <select id="payment_type_<?= (int)$row['invNo'] ?>" class="form-select form-select-sm ptype">
                                <option value="0">NONE</option>
                                <option value="BACS" selected="">BACS</option>
                                <option value="CHEQUE">CHEQUE</option>
                                <option value="CASH">CASH</option>
                                <option value="PAYPAL">PAYPAL</option>
                                <option value="CREDIT">CREDIT</option>
                            </select>
                            <div style="display:none" id="P00<?= (int)$row['invNo'] ?>" class="cno">
                                <input id="chequeNo_<?= (int)$row['invNo'] ?>" type="text" class="form-control-sm chequeNo"
                                       name="chequeNo_<?= (int)$row['invNo'] ?>" placeholder="Cheque Number">
                            </div>
                        </td>

                        <td class="d-print-table-cell">
                            <select id="payee_<?= (int)$row['invNo'] ?>" class="form-select form-select-sm">
                                <option value="C_<?= (int)$row['client'] ?>" <?= ($row['target'] ?? '') == 'client' ? 'selected' : '' ?>>Client</option>
                                <option value="A_<?= (int)$row['client'] ?>" <?= ($row['target'] ?? '') == 'agent' ? 'selected' : '' ?>>Agent</option>
                                <option value="B_<?= (int)$row['client'] ?>" <?= ($row['target'] ?? '') == 'broker' ? 'selected' : '' ?>>Broker</option>
                                <option value="BL_<?= (int)$row['invNo'] ?>" <?= ($row['target'] ?? '') == 'blank'  ? 'selected' : '' ?>>Other</option>
                            </select>
                        </td>

                        <td>
                            <div class="date-picker" data-date-type="open" data-mdb-toggle-button="false" data-format="dd-mm-yyyy">
                                <input class="form-control-sm border-0" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker"
                                       type="text" name="payment_date_<?= (int)$row['invNo'] ?>"
                                       id="payment_date_<?= (int)$row['invNo'] ?>" value="" placeholder="Select date" />
                            </div>
                        </td>

                        <td class="text-end">
                            <div role="group" aria-label="Actions">
                                <?php if ($isOverdue): ?>
                                <button type="button" class="btn btn-secondary btn-sm me-2" data-mdb-toggle="tooltip" title="Email Reminder">
                                    <i class="fad fa-envelope"></i>
                                </button>
                                <?php endif; ?>
                                <a href="index.php?t=includes/finance&p=finance_preview.php&invNo=<?= (int)$row['invNo'] ?>&type=outstanding"
                                   class="btn btn-secondary btn-sm me-2" data-mdb-toggle="tooltip" title="View Invoice">
                                    <i class="fad fa-eye"></i>
                                </a>
                                <a href="index.php?t=includes/finance&p=finance_invoices-edit.php&invNo=<?= (int)$row['invNo'] ?>"
                                   class="btn btn-secondary btn-sm me-2" data-mdb-toggle="tooltip" title="Edit Invoice">
                                    <i class="fad fa-edit"></i>
                                </a>
                                <button id="paidButton<?= (int)$row['invNo'] ?>" data-invid="<?= (int)$row['invNo'] ?>"
                                        data-client-name="<?= (int)$row['client'] ?>" data-target="<?= htmlspecialchars($row['target'] ?? '') ?>"
                                        class="btn btn-secondary btn-sm me-2 paidButton" data-mdb-toggle="tooltip" title="Mark as Paid">
                                    <i class="fad fa-check-circle text-success"></i>
                                </button>
                                <button id="voidButton<?= (int)$row['invNo'] ?>" data-clientName="<?= (int)$row['client'] ?>" data-invoiceid="<?= (int)$row['invNo'] ?>"
                                        class="btn btn-secondary btn-sm me-2 voidButton" data-mdb-toggle="tooltip" title="Void Invoice">
                                    <i class="fad fa-ban text-danger"></i>
                                </button>
                                <?= $latestBtn ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <div class="d-flex justify-content-end px-3 mt-3">
                <span class="fw-bold">Total Outstanding: £<?= number_format($mTotal, 2) ?></span>
            </div>
            <?php endif; ?>
        </section>
    </div>
</div>

<div id="exportDiv" style="display:none">
    <div id="exportTitle">Invoices Outstanding - <small>Generated <?= date('d-m-Y') ?></small></div>
    <table id="exportTable" class="table table-striped table-sm responsive" width="100%">
        <thead>
            <tr>
                <th>Invoice Number</th>
                <th>Client</th>
                <th>Agent/Broker</th>
                <th>Contract Number</th>
                <th>Status</th>
                <th>Amount</th>
                <th>Date of Invoice</th>
            </tr>
        </thead>
        <tbody>
            <?php
        $mTotal = 0;
        foreach ($data as $row):
            $invNoFormatted = sprintf("%06d", (int)$row['invNo']);
            $address = @unserialize($row['address']); if (!is_array($address)) $address = [];
            $totals = explode('|', $row['totals']);
            $sub = (float)str_replace(',', '', $totals[0] ?? '0');
            $vat = (float)str_replace(',', '', $totals[1] ?? '0');
            $grandTotal = $sub + $vat;
            $invoiceDate = !empty($row['date']) ? date('d-m-Y', (int)$row['date']) : '';
            $isOverdue = ((int)$row['date_due'] < time());
            $mTotal += $grandTotal;

            $statusBadge = '';
            if (!empty($row['sent']) && $row['sent'] != 0) {
                $statusBadge = $isOverdue ? '<span class="badge bg-danger">OVERDUE</span>' : '';
            }

            $stmt = $GLOBALS['con']->prepare("SELECT clientname FROM clientdetails WHERE clientnumber=?");
            $stmt->bind_param('i', $row['client']);
            $stmt->execute();
            $cd = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            $clientName = htmlspecialchars($cd['clientname'] ?? '');

            $agentName = '';
            if (($row['target'] ?? '') === 'agent') {
                $stmt = $GLOBALS['con']->prepare("SELECT agent_name FROM agents WHERE agent_number=?");
                $stmt->bind_param('i', $row['agent']);
                $stmt->execute();
                $ad = $stmt->get_result()->fetch_assoc();
                $stmt->close();
                $agentName = htmlspecialchars($ad['agent_name'] ?? '');
            } elseif (($row['target'] ?? '') === 'broker') {
                $stmt = $GLOBALS['con']->prepare("SELECT broker_name FROM brokers WHERE broker_number=?");
                $stmt->bind_param('i', $row['broker']);
                $stmt->execute();
                $bd = $stmt->get_result()->fetch_assoc();
                $stmt->close();
                $agentName = htmlspecialchars($bd['broker_name'] ?? '');
            }

            $emailBtn = !empty($row['sent'])
                ? '<span class="badge bg-success">SENT</span>'
                : '<span class="badge bg-warning text-dark">NOT SENT</span>';
            ?>
            <tr id="R<?= $invNoFormatted ?>">
                <td><?= $invNoFormatted ?></td>
                <td><?= $clientName ?></td>
                <td><?= $agentName ?></td>
                <td><?= htmlspecialchars($address['contract_number'] ?? '') ?></td>
                <td><?= $emailBtn ?> <?= $statusBadge ?></td>
                <td>£<?= number_format($grandTotal, 2) ?></td>
                <td><?= $invoiceDate ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="d-flex justify-content-end px-3 mt-3">
        <span class="fw-bold">Total Outstanding: £<?= number_format($mTotal, 2) ?></span>
    </div>
</div>

<?php
// DataTable config
$table = "expenseTable";
$dateTarget = "5";
$length = "25";
$sortTarget = "1";
$sortCell = "";
$logo = "yes";
$scroller = "";
$printTarget = 'exportDiv';
$printHeader = 'Outstanding Invoices';
$popup = "false";
require(ROOT_URL . '/includes/tables/finance_table.php');
?>

<script>
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('[data-mdb-toggle="tooltip"]').forEach(el => new mdb.Tooltip(el));
});

function showStatement(type, id, mode) {
    var dest = encodeURI(`${ROOT_URL}/includes/finance/${type}.php?mode=popup&${type}_number=${id}&tenant=${TENANT_URL}`);
    loadModalContent(dest, "statementBox", "modal-xxl", 1060, "true", `${type[0].toUpperCase() + type.slice(1).toLowerCase()} Statement`, "close");
}

// Date range submit → redirect preserving t & p
function applyRange(ev) {
    ev.preventDefault();
    const from = (document.getElementById('range_from')?.value || '').trim();
    const to = (document.getElementById('range_to')?.value || '').trim();
    const base = "<?= $SELF ?>";
    const qs = new URLSearchParams();
    if (from) qs.set('from', from);
    if (to) qs.set('to', to);
    const url = qs.toString() ? (base + '&' + qs.toString()) : base;
    window.location.href = url;
    return false;
}

// Collapse logic: only one year open at a time + chevron update
document.addEventListener('DOMContentLoaded', () => {
    document.body.addEventListener('click', (ev) => {
        const btn = ev.target.closest('[data-year-toggle]');
        if (!btn) return;

        const targetId = btn.getAttribute('aria-controls');
        const target = document.getElementById(targetId);
        if (!target) return;

        document.querySelectorAll('[id^="yearMonths-"]').forEach(el => {
            if (el.id !== targetId) {
                el.classList.remove('show');
                const otherBtn = document.querySelector(`[data-year-toggle][aria-controls="${el.id}"]`);
                if (otherBtn) {
                    otherBtn.setAttribute('aria-expanded', 'false');
                    const icon = otherBtn.querySelector('.fa-chevron-down, .fa-chevron-right');
                    if (icon) {
                        icon.classList.remove('fa-chevron-down');
                        icon.classList.add('fa-chevron-right');
                    }
                }
            }
        });

        const willOpen = !target.classList.contains('show');
        target.classList.toggle('show', willOpen);
        btn.setAttribute('aria-expanded', willOpen ? 'true' : 'false');

        const icon = btn.querySelector('.fa-chevron-down, .fa-chevron-right');
        if (icon) {
            icon.classList.toggle('fa-chevron-down', willOpen);
            icon.classList.toggle('fa-chevron-right', !willOpen);
        }
    });

    document.body.addEventListener('click', (event) => {
        const el = event.target.closest('.emailButton');
        if (!el) return;

        const payload = {
            clientNumber: el.dataset.clientNumber,
            clientName: el.dataset.clientName,
            primaryEmail: el.dataset.primaryEmail,
            secondaryEmail: el.dataset.secondaryEmail,
            subject: el.dataset.subject,
            message: el.dataset.message,
            filePath: el.dataset.filePath,
            fileName: el.dataset.fileName,
            invoiceNumber: el.dataset.invoiceNumber,
            mode: el.dataset.mode,
            addressMode: 'billing'
        };

        const encoded = encodeURIComponent(JSON.stringify(payload));
        const dest = `${ROOT_URL}/includes/master/financeMailer.php?mode=popup&data=${encoded}&tenant=${TENANT_URL}`;

        loadModalContent(dest, "mailerBox", "modal-xl", 1060, "true", "Email Invoice", "", '');
    });


    // Paid Button Click Handler
    document.body.addEventListener('click', (event) => {
        const targetElement = event.target.closest('.paidButton');
        if (targetElement) {
            const str = targetElement.dataset.invid;
            const clientNames = targetElement.dataset.clientName;
            const paid = document.getElementById('payment_type_' + str).value;
            const date = document.getElementById('payment_date_' + str).value;
            const target = targetElement.dataset.target;

            if (paid == 0 || date == "") {
                showResponse('warning', 'PLEASE SELECT A PAYMENT METHOD AND DATE');
                const paymentTypeElement = document.getElementById(`payment_type_${str}`);
                if (paymentTypeElement) {
                    paymentTypeElement.focus();
                }
            } else {


                const dest = `<p>Are you sure this invoice for <b>${str}</b> has been paid?</p>`;
                loadModalContent(dest, "confirmBox", "modal-md", 1060, "true", "Mark Paid", "cancelConfirm", () => setPaid(str, clientNames, target));

            }
        }
    });

    async function setPaid(invNo, clientNo, deliveryTarget) {
        const paymentTypeEl = document.getElementById(`payment_type_${invNo}`);
        const paymentDateEl = document.getElementById(`payment_date_${invNo}`);
        const chequeEl = document.getElementById(`chequeNo_${invNo}`);
        const payeeEl = document.getElementById(`payee_${invNo}`);

        const paid = paymentTypeEl ? String(paymentTypeEl.value || '') : '';
        const date = paymentDateEl ? String(paymentDateEl.value || '').trim() : '';
        const cno = chequeEl ? String(chequeEl.value || '').trim() : '';
        const pe = payeeEl ? String(payeeEl.value || '').trim() : '';

        if (!paid || paid === '0' || !date) {
            showResponse('warning', 'PLEASE SELECT A PAYMENT METHOD AND DATE');
            if (paymentTypeEl) paymentTypeEl.focus();
            return;
        }

try {
  const body = new URLSearchParams();
  body.append('FUNCTION', 'setPaid');
  body.append('inv', String(invNo));
  body.append('payment_type', paid);
  body.append('chequeNo', cno);
  body.append('payee', pe);
  body.append('date', date);
  body.append('tenant', TENANT_URL);

  const res = await fetch(ROOT_URL + '/includes/finance/finance_functions.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body
  });

  const raw = (await res.text()).trim();

  // Expecting: "success" OR "error|message" OR anything else (treated as error)
  if (raw === 'success') {
    // close confirm modal first so UI never gets stuck
    killModal('confirmBox')

    // row highlight/remove (invoice rows are usually R + 6-digit)
    const rowId = `R${String(invNo).padStart(6, '0')}`;
    const invRow = document.getElementById(rowId) || document.getElementById(`R${invNo}`);
    if (invRow) {
      invRow.style.backgroundColor = '#82e7d2';
      invRow.style.border = '1px solid #169f85';
    }

    showResponse('success', 'The invoice has been set to Paid');

    // if they want email confirmation modal
    if (deliveryTarget && deliveryTarget !== 'blank') {
      const emailParams = new URLSearchParams();
      emailParams.append('FUNCTION', 'getEmailDetails');
      emailParams.append('client', String(clientNo));
      emailParams.append('target', String(deliveryTarget));
      emailParams.append('tenant', TENANT_URL);

      const emailRes = await fetch(ROOT_URL + '/includes/finance/finance_functions.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: emailParams
      });

      const emailRaw = (await emailRes.text()).trim();
      const parts = emailRaw.split('|');

      // Build JSON payload for financeMailer.php
      const inv6 = String(invNo).padStart(6, '0');
      const payload = {
        clientNumber: String(clientNo),
        clientName: parts[0] ? String(parts[0]) : '',
        primaryEmail: parts[1] ? String(parts[1]) : '',
        secondaryEmail: parts[2] ? String(parts[2]) : '',
        subject: 'Invoice Payment Confirmation',
        message: `Thank you for your payment for invoice: ${inv6}`,
        filePath: '',
        fileName: '',
        invoiceNumber: inv6,
        addressMode: String(deliveryTarget || ''),
        mode: 'invoicePaid'
      };

      const mailerTarget = ROOT_URL + '/includes/master/financeMailer.php';

      // IMPORTANT: encodeURIComponent for query param values (NOT encodeURI for whole URL)
      const dest =
        `${mailerTarget}?mode=popup&tenant=${encodeURIComponent(TENANT_URL)}&data=${encodeURIComponent(JSON.stringify(payload))}`;

      loadModalContent(dest, 'mailerBox', 'modal-xl', 1060, 'true', 'Email Confirmation', '', '');
    }

    // fade out after a short delay
    if (invRow) {
      setTimeout(() => {
        invRow.style.transition = 'opacity 0.5s ease-out';
        invRow.style.opacity = '0';
        setTimeout(() => { invRow.style.display = 'none'; }, 500);
      }, 3000);
    }

    return;
  }

  // server-style error: "error|message"
  if (raw.startsWith('error|')) {
    showResponse('danger', raw.split('|').slice(1).join('|').trim() || 'Payment update failed.');
    return;
  }

  // unexpected response
  showResponse('danger', raw || 'Payment update failed.');
} catch (e) {
  console.error('Error in setPaid:', e);
  showResponse('danger', 'An error occurred during payment update.');
}

    }

    // Delete Button Click Handler
    document.body.addEventListener('click', (event) => {
        const targetElement = event.target.closest('.deleteButton');
        if (targetElement) {
            const str = targetElement.dataset.values;
            // Assuming confirmBox is a custom global function
            confirmBox('Void Invoice', 'Are you sure this invoice is to be deleted and numbering reset?<br><span class="text-danger"><small>THIS CANNOT BE UNDONE</small></span>', `setDelete('${str}')`);
        }
    });


    // Remove Button Click Handler (Void Invoice)
    document.body.addEventListener('click', (event) => {
        const targetElement = event.target.closest('.removeButton');
        if (targetElement) {
            const str = targetElement.dataset.values;
            const d = str.split("|");
            // Assuming confirmBox is a custom global function
            confirmBox('Void Invoice', 'Are you sure this invoice is to be voided?', `setArchive('${d[0]}')`);
        }
    });


    // Payment Type Change Handler
    document.body.addEventListener('change', (event) => {
        const targetElement = event.target.closest('.ptype');
        if (targetElement) {
            const sel = targetElement.value;
            const parentTd = targetElement.closest('td');
            if (sel === "CHEQUE") {
                const cnoElement = parentTd ? parentTd.querySelector('.cno') : null;
                if (cnoElement) {
                    cnoElement.style.display = 'block';
                }
            } else {
                const chequeNoElement = parentTd ? parentTd.querySelector('.chequeNo') : null;
                const cnoElement = parentTd ? parentTd.querySelector('.cno') : null;
                if (chequeNoElement) {
                    chequeNoElement.value = '';
                }
                if (cnoElement) {
                    cnoElement.style.display = 'none';
                }
            }
        }
    });

});

// Sidebar starts CLOSED on load and button text reflects state
document.addEventListener('DOMContentLoaded', () => {
    document.body.classList.add('sidebar-hidden');

    const btn = document.getElementById('toggleSidebar');
    const label = btn?.querySelector('.filters-label');

    function setFiltersLabel() {
        const open = !document.body.classList.contains('sidebar-hidden');
        if (label) label.textContent = open ? 'Close filters' : 'Open filters';
    }

    setFiltersLabel();

    if (btn) {
        btn.addEventListener('click', () => {
            document.body.classList.toggle('sidebar-hidden');
            setFiltersLabel();
        });
    }
});
</script>
<script>
(function () {
    function whenMDBReady(cb, attempts = 80) {
        if (window.mdb && typeof window.mdb.Datepicker === 'function') return cb();
        if (attempts <= 0) return;
        setTimeout(() => whenMDBReady(cb, attempts - 1), 50);
    }

    function ensureDatepicker(container) {
        if (!container) return null;

        // Prefer MDB's getInstance if present, otherwise our stored reference
        let inst = null;
        try {
            if (window.mdb && window.mdb.Datepicker && typeof window.mdb.Datepicker.getInstance === 'function') {
                inst = window.mdb.Datepicker.getInstance(container);
            }
        } catch (e) {}

        if (inst) return inst;
        if (container._mdbDatepicker) return container._mdbDatepicker;

        const options = {
            confirmDateOnSelect: true,
            format: (container.dataset.format || 'dd-mm-yyyy')
        };

        container._mdbDatepicker = new window.mdb.Datepicker(container, options);
        return container._mdbDatepicker;
    }

    // Event delegation: works after table redraw without re-binding
    document.addEventListener('focusin', (ev) => {
        const input = ev.target.closest('input[data-mdb-toggle="datepicker"]');
        if (!input) return;

        const container = input.closest('.date-picker');
        if (!container) return;

        whenMDBReady(() => {
            // Create only once per container
            ensureDatepicker(container);
            // Do NOT call open/close manually; MDB handles it from the input
        });
    });
})();
</script>
