<?php //get_report_stats.php
require_once('../../../' . $_REQUEST['tenant'] . '/config.php');

if (!isset($_GET['master_report_id']) || empty($_GET['master_report_id'])) {
echo json_encode(['success' => false, 'message' => 'Report ID missing.']);
exit;
}

$report_id = intval($_GET['master_report_id']);

$query = "SELECT installation_details, schedule_of_inspection, condition_schedule, circuit_results, stage_status
FROM elec_report WHERE master_report_id = ? LIMIT 1";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $report_id);
$stmt->execute();
$result = $stmt->get_result();
$reportData = $result->fetch_assoc();
$stmt->close();

// Debugging output for validation
error_log("DB Result: " . print_r($reportData, true));

// Decode stored JSON data safely
$reportStatus = [
'installation_details' => !empty($reportData['installation_details']) ? json_decode($reportData['installation_details'], true) : [],
'schedule_of_inspection' => !empty($reportData['schedule_of_inspection']) ? json_decode($reportData['schedule_of_inspection'], true) : [],
'condition_schedule' => !empty($reportData['condition_schedule']) ? json_decode($reportData['condition_schedule'], true) : [],
'circuit_results' => !empty($reportData['circuit_results']) ? json_decode($reportData['circuit_results'], true) : [],
'stage_status' => !empty($reportData['stage_status']) ? json_decode($reportData['stage_status'], true) : []
];

// Debugging output for validation
error_log("Decoded JSON: " . print_r($reportStatus, true));

echo json_encode(['success' => true, 'data' => $reportStatus]);
exit;
?>