<?php
// complete_template.php

// Assume you already have an established mysqli connection in $con.
$report_id = 40;  // Example report id

// --- Fetch the report details from elec_report ---
$query = "SELECT * FROM elec_report WHERE report_id = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $report_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    die("Report not found.");
}
$report = $result->fetch_assoc();

// Decode the installation_details JSON column
$install = json_decode($report['installation_details'], true);

// --- Fetch client details using clientnumber from the report ---
$query = "SELECT * FROM clientdetails WHERE clientnumber = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $report['clientnumber']);
$stmt->execute();
$client = $stmt->get_result()->fetch_assoc();

// --- Fetch location details using locnumber from the report ---
$query = "SELECT * FROM locations WHERE locnumber = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $report['locnumber']);
$stmt->execute();
$location = $stmt->get_result()->fetch_assoc();

// Build full address from clientdetails (for cover sheet)
$clientAddressParts = array();
if (!empty($client['address1'])) { $clientAddressParts[] = $client['address1']; }
if (!empty($client['address2'])) { $clientAddressParts[] = $client['address2']; }
if (!empty($client['town'])) { $clientAddressParts[] = $client['town']; }
if (!empty($client['county'])) { $clientAddressParts[] = $client['county']; }
if (!empty($client['postcode'])) { $clientAddressParts[] = $client['postcode']; }
$full_address = implode("\n", $clientAddressParts);

// Build installation address from locations (fallback to client address if empty)
$locationAddressParts = array();
if (!empty($location['address1'])) { $locationAddressParts[] = $location['address1']; }
if (!empty($location['address2'])) { $locationAddressParts[] = $location['address2']; }
if (!empty($location['town'])) { $locationAddressParts[] = $location['town']; }
if (!empty($location['county'])) { $locationAddressParts[] = $location['county']; }
if (!empty($location['postcode'])) { $locationAddressParts[] = $location['postcode']; }
$location_address = implode("\n", $locationAddressParts);
if (empty($location_address)) {
    $location_address = $full_address;
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Electrical Installation Condition Report</title>
    <style>
    /* Basic resets for DOMPDF compatibility */
    body {
        margin: 0;
        padding: 0;
        font-family: "DejaVu Sans", sans-serif;
        color: #000;
        font-size: 12pt;
    }

    .page {
        width: 100%;
        position: relative;
        padding: 40px;
        box-sizing: border-box;
    }

    .page-break {
        page-break-after: always;
    }

    /* Header (logo on left, year on right) */
    .header {
        position: relative;
        height: 100px;
        margin: 0 20px;
    }

    .logo-placeholder {
        position: absolute;
        left: 0;
        top: 20px;
        width: 200px;
        height: 60px;
        border: 1px dashed #000;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12pt;
        color: #666;
    }

    .year-box {
        position: absolute;
        right: 0;
        top: 0;
        width: 80px;
        height: 80px;
        background-color: #008000;
        color: #fff;
        font-weight: bold;
        font-size: 18pt;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Full-width green title bar */
    .green-title-bar {
        background-color: #008000;
        color: #fff;
        padding: 10px 20px;
        text-align: center;
        font-size: 12pt;
        font-weight: bold;
        line-height: 1.4;
        text-transform: uppercase;
    }

    /* Address block (cover sheet) */
    .address-block {
        margin: 40px 20px 0 20px;
        text-align: center;
        font-size: 12pt;
        white-space: pre-line;
    }

    /* Central image placeholder (cover sheet) */
    .image-placeholder {
        margin: 30px auto;
        width: 300px;
        height: 200px;
        border: 1px dashed #000;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12pt;
        color: #666;
    }

    /* Footer logos (cover sheet) */
    .footer-logos {
        margin: 40px 20px;
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 10px;
    }

    .logo-box {
        width: 80px;
        height: 50px;
        border: 1px dashed #000;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10pt;
        color: #666;
    }

    /* Section headings for page 2 */
    .section-title {
        font-size: 12pt;
        font-weight: bold;
        margin-top: 25px;
        margin-bottom: 10px;
        text-transform: uppercase;
    }

    /* Table for label-value pairs */
    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 10px;
    }

    .info-table td {
        vertical-align: top;
        padding: 4px;
    }

    .info-table .label {
        width: 30%;
        font-weight: bold;
    }

    .info-table .value {
        width: 70%;
    }

    /* Divider */
    .divider {
        width: 100%;
        border-bottom: 1px solid #000;
        margin: 15px 0;
    }

    /* Signature Area */
    .signature-block {
        margin-top: 20px;
    }

    .signature-block td {
        padding: 6px 0;
    }

    .signature-label {
        font-weight: bold;
        width: 150px;
    }

    .signature-line {
        width: 300px;
        border-bottom: 1px solid #000;
    }

    /* Header for page 2 (report ref only) */
    .header2 {
        margin-bottom: 20px;
        text-align: left;
        font-weight: bold;
    }
    </style>
</head>

<body>
    <!-- Page 1: Cover Sheet -->
    <div class="page">
        <!-- Header: Logo on left, Year on right -->
        <div class="header">
            <div class="logo-placeholder">Logo Placeholder</div>
            <div class="year-box">2023</div>
        </div>
        <!-- Full-width green title bar -->
        <div class="green-title-bar">
            ELECTRICAL INSTALLATION CONDITION REPORT REQUIREMENTS FOR ELECTRICAL INSTALLATIONS -
            IET WIRING REGULATIONS 18TH EDITION BS7671:2018 + AMENDMENT 2:2022
        </div>
        <!-- Address block (from client details) -->
        <div class="address-block">
            <?php echo nl2br(htmlspecialchars($full_address)); ?>
        </div>
        <!-- Central building image placeholder -->
        <div class="image-placeholder">
            Building Image Placeholder
        </div>
        <!-- Footer logos (8 placeholders) -->
        <div class="footer-logos">
            <div class="logo-box">Logo 1</div>
            <div class="logo-box">Logo 2</div>
            <div class="logo-box">Logo 3</div>
            <div class="logo-box">Logo 4</div>
            <div class="logo-box">Logo 5</div>
            <div class="logo-box">Logo 6</div>
            <div class="logo-box">Logo 7</div>
            <div class="logo-box">Logo 8</div>
        </div>
    </div>

    <!-- Page break for DOMPDF -->
    <div class="page-break"></div>

    <!-- Page 2: Report Details -->
    <div class="page">
        <!-- Header for page 2: Report Reference only -->
        <div class="header2">
            Report Ref: <?php echo htmlspecialchars($report['report_ref'] ?? '080723-50'); ?>
        </div>

        <!-- SECTION A: DETAILS OF THE CLIENT -->
        <div class="section-title">SECTION A. DETAILS OF THE CLIENT</div>
        <table class="info-table">
            <tr>
                <td class="label">Client:</td>
                <td class="value"><?php echo htmlspecialchars($client['clientname'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Address:</td>
                <td class="value"><?php echo nl2br(htmlspecialchars($full_address)); ?></td>
            </tr>
        </table>

        <!-- SECTION B: REASON FOR PRODUCING THIS REPORT -->
        <div class="section-title">SECTION B. REASON FOR PRODUCING THIS REPORT</div>
        <table class="info-table">
            <tr>
                <td class="label">Reason:</td>
                <td class="value"><?php echo htmlspecialchars($install['reason'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Inspection &amp; Testing Dates:</td>
                <td class="value"><?php echo htmlspecialchars($install['insdate'] ?? ''); ?></td>
            </tr>
        </table>

        <!-- SECTION C: DETAILS OF THE INSTALLATION -->
        <div class="section-title">SECTION C. DETAILS OF THE INSTALLATION</div>
        <table class="info-table">
            <tr>
                <td class="label">Occupier:</td>
                <td class="value"><?php echo htmlspecialchars($install['occupier'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Installation Address:</td>
                <td class="value"><?php echo nl2br(htmlspecialchars($location_address)); ?></td>
            </tr>
            <tr>
                <td class="label">Evidence of Alterations or Additions:</td>
                <td class="value"><?php echo htmlspecialchars($install['alterations'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">If ‘Yes’, Estimate Age (years):</td>
                <td class="value"><?php echo htmlspecialchars($install['alterations_age'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Installation Records Available:</td>
                <td class="value"><?php echo htmlspecialchars($install['records'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Estimated Age of the Wiring System:</td>
                <td class="value"><?php echo htmlspecialchars($install['age'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">District Network Operator (DNO):</td>
                <td class="value"><?php echo htmlspecialchars($install['network'] ?? ''); ?></td>
            </tr>
            <tr>
                <td class="label">Sub-Station Number:</td>
                <td class="value"><?php echo htmlspecialchars($install['subStation'] ?? ''); ?></td>
            </tr>
        </table>

        <!-- SECTION D: EXTENT AND LIMITATIONS OF THE INSPECTION -->
        <div class="section-title">SECTION D. EXTENT OF THE INSTALLATION AND LIMITATIONS</div>
        <p>Extent of electrical installation covered by this report: <strong><?php echo htmlspecialchars($install['extent'] ?? ''); ?></strong></p>
        <p>Limitations: Inspection and testing were carried out on accessible areas only; concealed cables, trunking, and other inbuilt components were not visually inspected.</p>

        <!-- SECTION E: SUMMARY OF THE CONDITION -->
        <div class="section-title">SECTION E. SUMMARY OF THE CONDITION OF THE INSTALLATION</div>
        <p>The general condition of the inspected parts of the installation is <strong>UNSATISFACTORY</strong>. Urgent remedial action is recommended where safety concerns are identified.</p>

        <!-- SECTION F: RECOMMENDATIONS -->
        <div class="section-title">SECTION F. RECOMMENDATIONS</div>
        <p>Recommendations: Items classified as 'Danger present' (C1) or 'Potentially dangerous' (C2) should be remedied immediately. Further investigation is advised for items marked FI.</p>

        <!-- SECTION G: DECLARATION -->
        <div class="section-title">SECTION G. DECLARATION</div>
        <p>I/we, the person(s) responsible for the inspection and testing of the electrical installation, hereby declare that the information contained in this report is an accurate reflection of the installation's condition.</p>
        <div class="signature-block">
            <table>
                <tr>
                    <td class="signature-label">Inspected &amp; Tested by:</td>
                    <td class="signature-line">&nbsp;</td>
                </tr>
                <tr>
                    <td class="signature-label">Name:</td>
                    <td class="value"><?php echo htmlspecialchars($report['inspector_name'] ?? 'Danny Brock'); ?></td>
                </tr>
                <tr>
                    <td class="signature-label">Signature:</td>
                    <td class="signature-line">&nbsp;</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>