<?php
if (!isset($_REQUEST['board_id'])) {
    die("Error: Board ID is missing.");
}
$board_id = intval($_REQUEST['board_id']);
?>
<div class="container-fluid mt-3">
    <h5>Completed Reports for Board ID: <?= $board_id ?></h5>
    <?php
    // Query the elec_report table for completed reports for this board.
    // (Assuming "status" column indicates 'complete'.)
    $stmt = $con->prepare("SELECT clientnumber, locnumber, report_id, report_reference, inspection_date FROM elec_report WHERE board_id = ? AND status = 'complete' ORDER BY inspection_date DESC");
    $stmt->bind_param('i', $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $rnum = mysqli_num_rows($result);
    
    if ($rnum < 1) {
        echo '<div class="alert alert-default text-center">
                <i class="fad fa-exclamation-triangle text-danger" aria-hidden="true"></i> No completed reports on file 
                <i class="fad fa-exclamation-triangle text-danger" aria-hidden="true"></i>
              </div>';
    } else {
        // Output reports as a grid of cards (using Bootstrap 5 grid)
        echo '<div class="row row-cols-1 row-cols-md-4 g-4">';
        while ($row = $result->fetch_assoc()) {
            // Format the inspection date. Adjust if inspection_date is a timestamp.
            $date = $row['inspection_date'];
            ?>
    <div class="col">
        <div class="card card-body text-center mb-4">
            <a href="index.php?t=includes/master&p=elec.php&view=elec_view_report&report_id=<?= $row['report_id'] ?>"
               data-bs-toggle="tooltip" data-bs-placement="bottom" title="View Report">
                <i class="fad fa-file-alt" style="font-size: 2em;"></i>
            </a>
            <p>
                <strong><?= $row['report_reference'] ?></strong><br>
                <?= $date ?><br>
            </p>
            <div class="d-flex justify-content-around">
                <button class="btn btn-sm btn-info" onclick="window.location.href='index.php?t=includes/master&p=elec.php&view=elec_view_report&report_id=<?= $row['report_id'] ?>'">
                    <i class="fad fa-eye"></i> View
                </button>
                <button class="btn btn-sm btn-secondary"
                        onclick="window.location.href='index.php?t=includes/master&p=elec.php&view=elec_edit_report&report_id=<?= $row['report_id'] ?>&data=<?=$board_id ?>|<?= $row['clientnumber'] ?>|<?= $row['locnumber'] ?>'">
                    <i class="fad fa-pencil"></i> Edit
                </button>
                <button class="btn btn-sm btn-danger" onclick="deleteReport(<?= $row['report_id'] ?>)">
                    <i class="fad fa-trash"></i> Delete
                </button>
            </div>
        </div>
    </div>
    <?php
        }
        echo '</div>';
    }
    $stmt->close();
    ?>
</div>

<script>
function deleteReport(reportId) {
    if (confirm("Are you sure you want to delete this report?")) {
        fetch(ROOT_URL + '/includes/elec/elec_delete_report.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: 'report_id=' + reportId + '&tenant=' + TENANT_URL
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showResponse('success', 'Report deleted successfully.');
                    // Reload the page (or update the UI as needed)
                    location.reload();
                } else {
                    showResponse('danger', data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showResponse('danger', 'An unexpected error occurred.');
            });
    }
}
</script>