<?php
// elec_new_report.php

// Extract board data from the pipe-delimited string in $_REQUEST['data']
$d = explode("|", $_REQUEST['data']);
if (!isset($d[0])) {
    die("Error: Board ID is missing.");
}
$report_id = intval($_REQUEST['report_id']);
$board_id     = intval($d[0]);
$clientnumber = intval($d[1]);
$locnumber    = intval($d[2]);


// Fetch Board Details
function get_board_details($board_id) {
    global $con;

    $query = "SELECT b.*, l.locname, l.postcode
              FROM elec_board b
              LEFT JOIN locations l ON b.locnumber = l.locnumber
              WHERE b.board_id = ?";
    $stmt = $con->prepare($query);
    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }
    $stmt->bind_param("i", $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();

    // If the row exists, set defaults for missing location fields.
    if ($row) {
        $row['clientname'] = !empty($row['clientnumber']) ? getClientName($row['clientnumber']) : 'Unknown';
        // Use locname from the joined table or default to 'Unknown'
        $row['locname'] = !empty($row['locname']) ? $row['locname'].' ('.$row['postcode'].')' : 'Unknown';
        unset($row['locnumber']);
        unset($row['clientnumber']);
        unset($row['postcode']);
        unset($row['board_id']);
        // Format installation_date to dd-mm-yyyy if it exists and is not empty.
        if (isset($row['installation_date']) && !empty($row['installation_date'])) {
            // First try to parse assuming the date is in Y-m-d format.
            $dt = DateTime::createFromFormat('Y-m-d', $row['installation_date']);
            if ($dt !== false) {
                $row['installation_date'] = $dt->format('d-m-Y');
            } else {
                // Fallback: try parsing with strtotime if the above fails.
                $timestamp = strtotime($row['installation_date']);
                if ($timestamp !== false) {
                    $row['installation_date'] = date('d-m-Y', $timestamp);
                }
            }
        }
        $exclude_keys = array("board_id");  // Add more keys here if needed.
        
        // Convert any field with a value exactly 1 or 0 to "Yes" or "No", respectively.
        foreach ($row as $key => $value) {
            if (!in_array($key, $exclude_keys)) {
                if ($value === "1" || $value === 1) {
                    $row[$key] = "Yes";
                } elseif ($value === "0" || $value === 0) {
                    $row[$key] = "No";
                }
            }
        }
        return $row;
    }

    return []; // Return an empty array if no record is found.
}

$query = "SELECT circuit_id, circuit_no, circuit_description FROM elec_circuit WHERE board_id = ? ORDER BY circuit_no ASC";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $board_id);
$stmt->execute();
$result = $stmt->get_result();

// Store the number of circuits.
$circuitsCount = $result->num_rows;

$circuitsInfo = [];
while ($row = $result->fetch_assoc()) {
    $circuitsInfo[$row['circuit_id']] = $row;
}
$stmt->close();

// Check for incomplete report
function check_incomplete_report($board_id) {
    global $con;
    $query = "SELECT report_id FROM elec_report WHERE board_id = ? AND status = 'active'";
    $stmt = $con->prepare($query);
    $stmt->bind_param("i", $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();
    $stmt->close();
    return $data;
}

$board_details    = get_board_details($board_id);

    $query = "SELECT installation_details FROM elec_report WHERE report_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("i", $report_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $reportData = $result->fetch_assoc();
    $stmt->close();

// Decode JSON stored data
$installation_data = !empty($reportData['installation_details']) ? json_decode($reportData['installation_details'], true) : [];


function getSurveyorNameForm($esname){
    $stmt = $GLOBALS['con']->prepare("SELECT `surname`,`forename` FROM `surveyor` WHERE `id`=?")or die(mysqli_error($GLOBALS['con']));
    $stmt->bind_param('i',$esname);$stmt->execute();$rc=$stmt->get_result();$stmt->close();	
    $cd=mysqli_fetch_array($rc);	
    return $cd['forename']." ".$cd['surname'];
    }

    function listSurveyor($c, $n, $t){   
if(!empty($_SESSION['contractorNumber'])){$filter="AND `contractor`='".$_SESSION['contractorNumber']."'";}
switch($t){
default:break;

case "select":
    $ca=array();
$stmt = $GLOBALS['con']->prepare("SELECT `id`,`esname`,`forename`,`surname` FROM `surveyor` WHERE `statuslive`='1' ORDER BY `forename` ASC")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$cc=$stmt->get_result();$stmt->close();	
while($pd=mysqli_fetch_array($cc)){$ca[]=$pd;}
$ret='<select class="form-control form-control-sm" data-mdb-select-init data-mdb-filter="true" id="'.$n.'" name="'.$n.'">'; 
$ret.='<option value="NULL">Select primary Surveyor</option>';//.PHP_EOL;	
foreach($ca as $px){
$name=$px['forename'].' '.$px['surname'];
if($c==$px['id']){$s="SELECTED";}else{$s="";}
$ret.='<option value="'.$px['id'].'" '.$s.'>'.$name.'</option>';//.PHP_EOL;
}
$ret.='</select>';
return($ret);
break;

case "name":
$stmt = $GLOBALS['con']->prepare("SELECT `id`,`esname`,`forename`,`surname` FROM `surveyor` WHERE `statuslive`='1'  ORDER BY `forename` ASC")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$cc=$stmt->get_result();$stmt->close();	
while($pd=mysqli_fetch_array($cc)){$ca[]=$pd;}
$ret='<select class="form-control form-control-sm" id="'.$n.'" name="'.$n.'">';
$ret.='<option value="NULL">Select Surveyor</option>';//.PHP_EOL;	
foreach($ca as $px){
$name=$px['forename'].' '.$px['surname'];
if($c==$name){$s="SELECTED";}else{$s="";}
$ret.='<option value="'.$name.'" '.$s.'>'.$name.'</option>';//.PHP_EOL;
}
$ret.='</select>';
return($ret);
break;

case "ajax":
$stmt = $GLOBALS['con']->prepare("SELECT `id`,`esname`,`forename`,`surname` FROM `surveyor` WHERE `statuslive`='1'  ORDER BY `forename` ASC")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$cc=$stmt->get_result();$stmt->close();	
$cnt=mysqli_num_rows($cc);
while($pd=mysqli_fetch_array($cc)){$ca[]=$pd;}

$co=0;
$ret='var clientList = ['; 
foreach($ca as $px){
$name=$px['forename'].' '.$px['surname'];
$name=str_replace('"','',$name);
$name=str_replace('\&','and',$name);
$co++;
if($co==$cnt){$s="";}else{$s=",";}
$ret.='{"value":"'.$name.'","name":"'.$px['id'].'"}'.$s.PHP_EOL;

}
$ret.='];';
return($ret);
break;
		
}	
}

?>


<script>
const BOARD_ID = <?= $board_id ?>;
const REPORT_ID = <?= $report_id; ?>;
</script>


<style>
/* Center the toggle button at the top center */
#toggleBoardDetails {
    position: fixed;
    top: 48px;
    left: 50%;
    transform: translateX(-50%);
    z-index: 1050;
}

/* Position the collapsible container just below the button */
#boardDetailsContainer {
    position: fixed;
    top: 48px;
    left: 50%;
    transform: translateX(-50%);
    width: 90%;
    max-width: 800px;
    z-index: 1040;
}

#clearStageBtn {
    display: none
}
</style>

<!-- Toggle Button using MDBootstrap's data attributes -->
<button id="toggleBoardDetails" class="btn btn-secondary" type="button" data-mdb-toggle="collapse" data-mdb-target="#boardDetailsContainer" aria-expanded="false" aria-controls="boardDetailsContainer">
    Board Details
</button>

<?php
// Retrieve board details using the updated function.
$board_details = get_board_details($board_id);

if (!empty($board_details)) {
    // The container uses "collapse" plus "bg-white" and padding.
    echo "<div class='collapse bg-info text-light p-3 border shadow-4-strong rounded-bottom' id='boardDetailsContainer'>";
    echo "<h2>Board Details</h2>";
    echo "<div class='row bg-dark text-light rounded'>";
    
    // Loop through each field and output in a 4-column grid (col-md-3)
    foreach ($board_details as $field => $value) {
        // Format the field name: replace underscores with spaces and capitalize words.
        $formattedField = ucwords(str_replace("_", " ", $field));
        echo "<div class='col-md-3 mb-3'>";
            echo "<div class='p-2'>";
                echo "<strong style='color:darkgrey'>" . htmlspecialchars($formattedField) . ":</strong><br>" . htmlspecialchars($value);
            echo "</div>";
        echo "</div>";
    }
    
    echo "</div>"; // end row
    echo "</div>"; // end container
} else {
    echo "<p>No board details found.</p>";
}
?>


<link rel="stylesheet" href="<?=ROOT_URL?>/src/uploader.css?v=5.0.3">
<!-- Add top padding to ensure the fixed toggle doesn't overlap your content -->
<div class="container-fluid" style="">
    <div class="row mb-4 pt-3">
        <div class="col-md-8">
            <h3 class="text-dark">
                <?= $report_id 
                    ? '<i class="fad fa-regular fa-arrow-right-to-bracket"></i> Edit Report' 
                    : '<i class="fad fa-regular fa-square-plus"></i> Create New Report' ?>
            </h3>
            <p>
                Board: <?= htmlspecialchars($board_details['board_name']) ?>
                Location: <?= htmlspecialchars($board_details['locname']) ?>

            </p>
        </div>
        <div class="col-md-4 text-md-end text-center">
            <button class="btn btn-secondary mt-3" onclick="window.history.back()">
                <i class="fas fa-arrow-left"></i> Cancel
            </button>
        </div>
    </div>

    <!-- Report Stages Checklist -->
    <div class="row">
        <div class="col-12 col-md-2">
            <h5>Report Stages</h5>
            <ul class="list-group" id="reportChecklist">
                <li class="list-group-item mb-2 p-2 border-top bg-info text-light" onclick="navigateStage(1)" style="cursor: pointer; font-size:12px">
                    1. Details of Installation
                    <span class="float-end" id="stage1-status">
                        <i class="fad fa-spinner-third text-info fa-spin"></i>
                    </span>
                </li>
                <li class="list-group-item mb-2 p-2 border-top bg-info text-light" onclick="navigateStage(2)" style="cursor: pointer; font-size:12px">
                    2. Schedule of Inspection
                    <span class="float-end" id="stage2-status">
                        <i class="fad fa-spinner-third text-info fa-spin"></i>
                    </span>
                </li>
                <li class="list-group-item mb-2 p-2 border-top bg-info text-light" onclick="navigateStage(3)" style="cursor: pointer; font-size:12px">
                    3. Condition Report
                    <span class="float-end" id="stage3-status">
                        <i class="fad fa-spinner-third text-info fa-spin"></i>
                    </span>
                </li>
                <li class="list-group-item p-2 border-top bg-info text-light" onclick="navigateStage(4)" style="cursor: pointer; font-size:12px">
                    4. Inspection and Test Results
                    <span class="float-end" id="stage4-status">
                        <i class="fad fa-spinner-third text-info fa-spin"></i>
                    </span>
                </li>
            </ul>
        </div>
        <div class="col-12 col-md-10">
            <!-- Dynamic Content -->
            <div id="stageContent">
                <div id="landingMessage" class="d-flex flex-column align-items-center justify-content-center my-5">
                    <span class="fa-stack fa-4x">
                        <i class="fad fa-square fa-stack-2x text-dark"></i>
                        <i class="fad fa-bolt fa-stack-1x text-light fa-inverse"></i>
                    </span>
                    <h2 class="mt-3 text-primary">Electrical Inspection Report</h2>
                    <p class="lead text-muted">Select a stage from the checklist to begin your inspection.</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Load MDBootstrap UMD (adjust the version/path as needed) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/6.2.0/mdb.min.js"></script>

<script src="<?=ROOT_URL?>/src/uploader.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if mdb is defined
    if (typeof mdb === 'undefined') {
        console.error("mdb is not defined. Please check that your MDBootstrap script is loaded correctly.");
    } else {
        const element = document.querySelector('.collapse');
        const instance = new mdb.Collapse(element);
    }
});

function alertMessage(title, message, target) {
    var dest = `<p>${message}</p>`;
    loadModalContent(dest, "confirmBox", "modal-md", 1060, "true", title, "cancelConfirm", target);
}

function toggleImageUploaders() {
    // Get the report id value from the hidden input.
    var reportId = document.getElementById("report_id").value.trim();
    // Find all elements with class "imageContainer"
    var uploaderContainers = document.querySelectorAll('.imageContainer');

    // Loop through each container.
    uploaderContainers.forEach(function(container) {
        // Look for an existing message element (if any) so we don’t add it twice.
        var existingMsg = container.parentNode.querySelector('.uploader-message');

        if (!reportId) {
            // No report id – hide the uploader container.
            container.style.display = "none";
            // If not already added, create and insert the message.
            if (!existingMsg) {
                var message = document.createElement("div");
                message.className = "uploader-message";
                // Style the message as desired (centered, padded, bold, etc.)
                message.style.textAlign = "center";
                message.style.padding = "10px";
                message.style.fontWeight = "bold";
                message.textContent = "Image uploaders available after initial save";
                // Insert the message before the container
                container.parentNode.insertBefore(message, container);
            }
        } else {
            // Report id exists – remove any message and show the container.
            container.style.display = "block";
            if (existingMsg) {
                existingMsg.remove();
            }
        }
    });
}


function navigateStage(stage) {

    // Build the URL for loading the stage content
    var url = `${ROOT_URL}/includes/elec/load_stage.php?stage=${stage}&report_id=${REPORT_ID}&board_id=<?= $board_id ?>&tenant=${TENANT_URL}`;

    // Build parameters if needed (here we're not sending extra parameters, so it's an empty string)
    var params = "";

    // Use the loadContentAndExecuteScripts function to load the content and execute contained scripts
    loadContentAndExecuteScripts(url, "stageContent", params, function() {
        // Once the content and any scripts inside it have been loaded, fetch report status.
        fetch(`${ROOT_URL}/includes/elec/get_report_status.php?report_id=${REPORT_ID}&tenant=${TENANT_URL}`)
            .then(response => response.json())
            .then(response => {
                if (response.success) {
                    const data = response.data;
                    if (stage === 3) {
                        toggleImageUploaders();
                    }
                    // If stage status is complete, hide the Mark Complete button; otherwise, show it.
                    var markCompleteBtn = document.getElementById('markCompleteBtn');
                    if (markCompleteBtn) {
                        if (data.stage_status[stage] === 'complete') {
                            markCompleteBtn.style.display = 'none';
                        } else {
                            markCompleteBtn.style.display = 'block';
                        }
                    }
                }
            })
            .catch(error => console.error('Error fetching report data:', error));
    });
}

// Global variable to keep track of the current page.
var currentPage = 1;

function showCircuitPage(page) {
    var container = document.getElementById('circuitContainer');
    var direction = null;
    if (page > currentPage) {
        direction = 'right';
    } else if (page < currentPage) {
        direction = 'left';
    }

    if (direction) {
        // Animate the container sliding out.
        container.style.transition = 'transform 0.4s ease';
        // If moving to a higher page, slide left (i.e. content moves left).
        // If moving to a lower page, slide right.
        container.style.transform = (direction === 'right') ? 'translateX(-100%)' : 'translateX(100%)';

        // After the slide-out, update the visible cards and slide the container back in.
        setTimeout(function() {
            // Hide all cards.
            document.querySelectorAll('.circuit-card').forEach(function(card) {
                card.style.display = 'none';
            });
            // Show only the cards that belong to the requested page.
            document.querySelectorAll('.circuit-card[data-page="' + page + '"]').forEach(function(card) {
                card.style.display = 'block';

            });

            // Immediately reset the container position offscreen (from the opposite side).
            container.style.transition = 'none';
            container.style.transform = (direction === 'right') ? 'translateX(100%)' : 'translateX(-100%)';

            // Force a reflow so the browser registers the change.
            container.offsetHeight;

            // Animate the container sliding in to its normal position.
            container.style.transition = 'transform 0.4s ease';
            container.style.transform = 'translateX(0)';

            // Update the current page value.
            currentPage = page;
            initSlimForVisibleCircuits;
            // Update the pagination active state.
            document.querySelectorAll('.pagination .page-item').forEach(function(li) {
                li.classList.remove('active');
            });
            var activeLink = document.querySelector('.pagination .page-item a[onclick*="showCircuitPage(' + page + ')"]');
            if (activeLink && activeLink.parentElement) {
                activeLink.parentElement.classList.add('active');
            }
        }, 400); // Matches the slide-out duration (400ms)
    } else {
        // If no direction (i.e. page is the same), simply update the active pagination link.
        document.querySelectorAll('.pagination .page-item').forEach(function(li) {
            li.classList.remove('active');

        });
        var activeLink = document.querySelector('.pagination .page-item a[onclick*="showCircuitPage(' + page + ')"]');
        if (activeLink && activeLink.parentElement) {
            activeLink.parentElement.classList.add('active');
        }
    }
}

// Save stage and set to pending
function saveReportStage(stage) {

    let formData = new FormData();
    formData.append("stage", `save_stage_${stage}`);
    formData.append("board_id", document.getElementById("board_id").value);
    formData.append("tenant", TENANT_URL);
    formData.append("clientnumber", <?=$clientnumber?>);

    let formElement;
    switch (stage) {
        case 1:
            formElement = document.getElementById("installationDetailsForm");
            break;
        case 2:
            formElement = document.getElementById("scheduleOfInspectionForm");
            break;
        case 3:
            formElement = document.getElementById("conditionReportForm");
            break;
        case 4:
            formElement = document.getElementById("circuitInspectionForm");
            break;
        default:
            console.error("Invalid stage: " + stage);
            return;
    }

    let inputs = formElement.querySelectorAll("input, select, textarea");
    inputs.forEach(input => {
        if (input.type === "radio") {
            if (input.checked) {
                formData.append(input.name, input.value);
            }
        } else if (input.type === "checkbox") {
            formData.append(input.name, input.checked ? 1 : 0);
        } else {
            formData.append(input.name, input.value);
        }
    });

    fetch(`${ROOT_URL}/includes/elec/load_stage.php?tenant=${TENANT_URL}`, {
            method: "POST",
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                if (data.report_id) {
                    REPORT_ID = data.report_id;
                }
                killModal('confirmBox')
                showResponse("success", data.message);
                updateStageStatus(stage, 'pending'); // Change icon to pending 
                updateStageState(stage, "pending");
                checkStageCompletion(); // Force re-check immediately after save
                document.getElementById("stageContent").innerHTML = `
                <div id="landingMessage" class="d-flex flex-column align-items-center justify-content-center my-5">
                    <span class="fa-stack fa-4x">
                    <i class="fad fa-square fa-stack-2x text-primary"></i>
                    <i class="fad fa-bolt fa-stack-1x fa-inverse"></i>
                    </span>
                    <h2 class="mt-3 text-primary">Electrical Inspection Report</h2>
                    <p class="lead text-muted">Select a stage from the checklist to begin your inspection.</p>
                </div>
                `;; // Clear stage

            } else {
                showResponse("danger", data.message);
            }
        })
        .catch(error => {
            console.error("Save error:", error);
            showResponse("danger", "Failed to save data.");
        });
}

// Mark a stage as complete
function markStageComplete(stage) {
    updateStageState(stage, 'complete');
    killModal('confirmBox')
    document.getElementById("stageContent").innerHTML = `
  <div id="landingMessage" class="d-flex flex-column align-items-center justify-content-center my-5">
    <span class="fa-stack fa-4x">
      <i class="fad fa-square fa-stack-2x text-primary"></i>
      <i class="fad fa-bolt fa-stack-1x fa-inverse"></i>
    </span>
    <h2 class="mt-3 text-primary">Electrical Inspection Report</h2>
    <p class="lead text-muted">Select a stage from the checklist to begin your inspection.</p>
  </div>
`;; // Clear stage

}

// Clear a stage
function clearStage(stage) {
    let formData = new URLSearchParams();
    formData.append("report_id", REPORT_ID);
    formData.append("stage", stage);
    formData.append("tenant", TENANT_URL);

    fetch(`${ROOT_URL}/includes/elec/clear_stage.php`, {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded"
            },
            body: formData.toString()
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                killModal('confirmBox')
                updateStageState(stage, "empty"); // Update UI to reflect the cleared stage
                document.getElementById("stageContent").innerHTML = "<h5>Select a stage from the checklist to begin.</h5>"; // Clear stage

            } else {
                console.error("Error clearing stage:", data.message);
            }
        })
        .catch(error => console.error("Error clearing stage:", error));
}


// Check a stage
function checkStageCompletion() {
    if (!REPORT_ID) {
        // New report -> Set all stages to "empty"
        updateStageStatus(1, "empty");
        updateStageStatus(2, "empty");
        updateStageStatus(3, "empty");
        updateStageStatus(4, "empty");
        return;
    }

    fetch(`${ROOT_URL}/includes/elec/get_report_status.php?report_id=${REPORT_ID}&tenant=${TENANT_URL}`)
        .then(response => response.json())
        .then(response => {
            if (response.success) {
                const data = response.data;
                updateStageStatus(1, data.stage_status[1] || (Object.keys(data.installation_details).length > 0 ? 'pending' : 'empty'));
                updateStageStatus(2, data.stage_status[2] || (Object.keys(data.schedule_of_inspection).length > 0 ? 'pending' : 'empty'));
                updateStageStatus(3, data.stage_status[3] || (Object.keys(data.condition_schedule).length > 0 ? 'pending' : 'empty'));
                updateStageStatus(4, data.stage_status[4] || (Object.keys(data.circuit_results).length > 0 ? 'pending' : 'empty'));
            } else {
                console.error('Error fetching report data:', response.message);
            }
        })
        .catch(error => console.error('Error fetching report data:', error));
}

// Update stage status in DB
function updateStageStatus(stage, status) {
    const statusIcon = document.getElementById(`stage${stage}-status`);
    if (statusIcon) {
        let iconHTML = '';
        switch (status) {
            case 'pending':
                iconHTML = '<i class="fad fa-spinner-third text-info fa-spin"></i> Ongoing'; //
                break;
            case 'complete':
                iconHTML = '<i class="fad fa-check-circle text-success"></i> Complete'; //
                break;
            case 'empty':
                iconHTML = '<i class="fad fa-minus-circle text-danger"></i> Not started'; //
                break;
        }
        statusIcon.innerHTML = iconHTML;
    }
    checkAllStagesComplete()
}

function updateStageState(stage, status) {
    let formData = new URLSearchParams();
    formData.append("report_id", REPORT_ID || ""); // Ensure it's set
    formData.append("stage", stage);
    formData.append("status", status);
    formData.append("tenant", TENANT_URL); // Always send tenant

    fetch(`${ROOT_URL}/includes/elec/update_stage_status.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: formData.toString() // Convert FormData to URL string
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateStageStatus(stage, 'pending'); // Change icon to "pending" immediately
                checkStageCompletion(); // Ensure real-time update
                checkAllStagesComplete()
            } else {
                console.error('Error updating stage:', data.message);
            }
        })
        .catch(error => console.error('Error updating stage:', error));
}

function toggleImageUploaders() {
    // Get the report id value from the hidden input.
    var reportId = document.getElementById("report_id").value.trim();
    // Find all elements with class "imageContainer"
    var uploaderContainers = document.querySelectorAll('.imageContainer');

    // Loop through each container.
    uploaderContainers.forEach(function(container) {
        // Look for an existing message element (if any) so we don’t add it twice.
        var existingMsg = container.parentNode.querySelector('.uploader-message');

        if (!reportId) {
            // No report id – hide the uploader container.
            container.style.display = "none";
            // If not already added, create and insert the message.
            if (!existingMsg) {
                var message = document.createElement("div");
                message.className = "uploader-message";
                // Style the message as desired (centered, padded, bold, etc.)
                message.style.textAlign = "center";
                message.style.padding = "10px";
                message.style.fontWeight = "bold";
                message.textContent = "Image uploaders available after initial save";
                // Insert the message before the container
                container.parentNode.insertBefore(message, container);
            }
        } else {
            // Report id exists – remove any message and show the container.
            container.style.display = "block";
            if (existingMsg) {
                existingMsg.remove();
            }
        }
    });
}



// Instrument Row Handling
document.addEventListener("DOMContentLoaded", () => {
    checkStageCompletion();
    updateInstrumentRowIcons();
});

// Dynamically add a new instrument row
function addInstrumentRow() {
    let table = document.getElementById("instrumentRows");
    let rowCount = table.rows.length;
    let row = table.insertRow();

    row.innerHTML = `
        <td><input type="text" name="instrument[]" class="form-control" placeholder="Instrument"></td>
        <td><input type="text" name="maker[]" class="form-control" placeholder="Maker"></td>
        <td><input type="text" name="serial_no[]" class="form-control" placeholder="Serial No"></td>
        <td><input type="date" name="last_calibration[]" class="form-control"></td>
        <td><input type="date" name="next_calibration[]" class="form-control"></td>
        <td class="text-center">
            <button type="button" class="btn btn-outline-danger btn-sm removeInstrumentRow">
                <i class="fad fa-trash-alt"></i>
            </button>
        </td>
    `;

    updateInstrumentRowIcons();
}

// Update instrument row icons (handle first row separately)
function updateInstrumentRowIcons() {
    let rows = document.querySelectorAll("#instrumentRows tr");
    rows.forEach((row, index) => {
        let actionCell = row.querySelector("td:last-child");
        if (!actionCell) {
            actionCell = document.createElement("td");
            actionCell.className = "text-center";
            row.appendChild(actionCell);
        }

        if (index === 0) {
            actionCell.innerHTML = `
                <button type="button" class="btn btn-outline-warning btn-sm clearInstrumentRow">
                    <i class="fad fa-broom"></i>
                </button>
            `;
        } else {
            actionCell.innerHTML = `
                <button type="button" class="btn btn-outline-danger btn-sm removeInstrumentRow">
                    <i class="fad fa-trash-alt"></i>
                </button>
            `;
        }
    });

    attachInstrumentRowEvents();
}

// Attach event listeners for dynamically added rows
function attachInstrumentRowEvents() {
    document.querySelectorAll(".removeInstrumentRow").forEach(button => {
        button.onclick = function() {
            this.closest("tr").remove();
            updateInstrumentRowIcons();
        };
    });

    document.querySelectorAll(".clearInstrumentRow").forEach(button => {
        button.onclick = function() {
            let row = this.closest("tr");
            row.querySelectorAll("input").forEach(input => input.value = "");
        };
    });
}

// Run on page load to ensure icons are set
document.addEventListener("DOMContentLoaded", updateInstrumentRowIcons);

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=client.php&view=list">Clients</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&clientnumber=<?= $d[1]?>&view=elec_client"><?= getClientName($d[1])?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&clientnumber=<?= $d[1]?>&view=elec_client"">Board: <?= htmlspecialchars($board_details['board_name']) ?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item active">Edit Report</li>'
});

function checkAllStagesComplete() {
    // Get the innerHTML for each stage status span and convert to lowercase.
    const stage1HTML = document.getElementById("stage1-status").innerHTML.toLowerCase();
    const stage2HTML = document.getElementById("stage2-status").innerHTML.toLowerCase();
    const stage3HTML = document.getElementById("stage3-status").innerHTML.toLowerCase();
    const stage4HTML = document.getElementById("stage4-status").innerHTML.toLowerCase();

    // Check if each contains the word "complete"
    const allComplete = stage1HTML.includes("complete") &&
        stage2HTML.includes("complete") &&
        stage3HTML.includes("complete") &&
        stage4HTML.includes("complete");

    // The container where the stage checklist is rendered
    const checklist = document.getElementById("reportChecklist");

    if (allComplete) {

        // If all stages are complete and the finalise button isn't already there, add it.
        if (!document.getElementById("finaliseReportBtn")) {
            const btn = document.createElement("button");
            btn.id = "finaliseReportBtn";
            btn.className = "btn btn-success mt-2";
            btn.innerHTML = '<i class="fad fa-check-double me-1"></i> Update Report';
            // Append the button to the checklist container (or adjust as needed)
            checklist.appendChild(btn);
            btn.addEventListener("click", finaliseReport);
        }


    } else {
        // If not all complete, remove the finalise button if it exists.
        const existingBtn = document.getElementById("finaliseReportBtn");

        if (existingBtn) {
            existingBtn.remove();
        }

    }
}

function finaliseReport() {
    // location.href = 'index.php?t=includes/master&p=elec.php&view=elec_test_report'
    var installationSummary = <?= json_encode($installation_data['installationSummary'] ?? '') ?>;
    var recommendations = <?= json_encode($installation_data['recommendations'] ?? '') ?>;
    var dest = `
    <form id="formComplete">
    <div class="row">
        <input id="board_id" type="hidden" name="board_id" value="<?=htmlspecialchars($board_id, ENT_QUOTES, 'UTF-8')?>">
        <input id="report_id" type="hidden" name="report_id" value="<?=htmlspecialchars($incomplete_report['report_id'] ?? '', ENT_QUOTES, 'UTF-8')?>">
        
        <div class="form-group mb-4 col-12 col-md-6">
            <label class="form-label lead" for="extent">Extent of electrical installation covered by this report</label>
            <input type="text" id="extent" name="installation_details[extent]" class="form-control" value="<?=htmlspecialchars($installation_data['extent'] ?? '', ENT_QUOTES, 'UTF-8')?>">        
        </div>

        <div class="form-group mb-4 col-12 col-md-3">
            <label class="form-label lead" for="generalCondition">General condition</label>
            <select id="generalCondition" class="form-control md-form" name="installation_details[generalCondition]" searchable="Search here..">
                <option value="" disabled selected>Choose your option</option>
                <option value="SATISFACTORY">SATISFACTORY</option>
                <option value="UNSATISFACTORY">UNSATISFACTORY</option>
            </select>        
        </div>

        <div class="form-group mb-4">
            <label class="form-label lead" for="installationSummary">Summary of condition</label>
            <div class="d-flex">
                <textarea id="installationSummary" name="installation_details[installationSummary]" class="md-textarea form-control" rows="3">${installationSummary}</textarea> 
                <div class="d-flex flex-column">
                    <button type="button" class="btn btn-secondary mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Clear Field" onClick="clearbox('installationSummary')">
                        <i class="fad fa-eraser"></i>
                    </button>
                    <?php if($_SESSION['usertype']=="admins"){ ?>
                    <button type="button" class="btn btn-info mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="View List" onClick="autofillElec('formComplete','installationSummary','elecphrases')">
                        <i class="fad fa-edit"></i>
                    </button>
                    <button type="button" class="btn btn-success mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Save field as new entry" onClick="savebox('installationSummary','elecphrases')">
                        <i class="fad fa-save"></i>
                    </button>
                    <?php } else { ?>
                    <button type="button" class="btn btn-success mb-1 ms-4" onClick="javascript:void(0)"></button>
                    <button type="button" class="btn btn-info mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="View List" onClick="autofillElec('formComplete','installationSummary','elecphrases')">
                        <i class="fad fa-edit"></i>
                    </button>
                    <?php } ?>
                    <button type="button" class="btn btn-danger btn-info-alt ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Reset FIeld" onClick="resetBox('installationSummary')">
                        <i class="fad fa-refresh"></i>
                    </button>
                </div>
            </div>   
        </div>

        <div class="form-group mb-4">
            <label class="form-label lead" for="recommendations">Recommendations</label>
            <div class="d-flex">
                <textarea id="recommendations" name="installation_details[recommendations]" class="md-textarea form-control" rows="3">${recommendations}</textarea>  
                <div class="d-flex flex-column">
                    <button type="button" class="btn btn-secondary mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Clear Field" onClick="clearbox('recommendations')">
                        <i class="fad fa-eraser"></i>
                    </button>
                    <?php if($_SESSION['usertype']=="admins"){ ?>
                    <button type="button" class="btn btn-info mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="View List" onClick="autofillElec('formComplete','recommendations','elecphrases')">
                        <i class="fad fa-edit"></i>
                    </button>
                    <button type="button" class="btn btn-success mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Save field as new entry" onClick="savebox('recommendations','elecphrases')">
                        <i class="fad fa-save"></i>
                    </button>
                    <?php } else { ?>
                    <button type="button" class="btn btn-success mb-1 ms-4" onClick="javascript:void(0)"></button>
                    <button type="button" class="btn btn-info mb-1 ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="View List" onClick="autofillElec('formComplete','recommendations','elecphrases')">
                        <i class="fad fa-edit"></i>
                    </button>
                    <?php } ?>
                    <button type="button" class="btn btn-danger btn-info-alt ms-4" data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover" title="Reset FIeld" onClick="resetBox('recommendations')">
                        <i class="fad fa-refresh"></i>
                    </button>
                </div>      
            </div>    
        </div>
    </div>
    <div class="row">    
        <div class="form-group mb-4 col-12 col-md-4">
            <label class="form-label lead" for="surveyor">Surveyor</label>
            <?php if ($_SESSION['usertype'] == "surveyor") { ?>
            <input type="hidden" class="form-control" name="installation_details[surveyor]" id="surveyor" value="<?= $_SESSION['userid'] ?>" readonly>
            <span class="text-dark"><?= getSurveyorNameForm($_SESSION['userid']) ?></span>
            <?php } else { ?>
            <?= listSurveyor(htmlspecialchars($installation_data['surveyor'] ?? '', ENT_QUOTES, 'UTF-8'), 'installation_details[surveyor]', 'select') ?>
            <?php } ?>
        </div>
    </div>
    <div class="row">
        <div class="form-group mb-4 col-12 col-md-6">
        <label class="form-label lead" for="inspectionDates">Date(s) on which inspection and testing was carried out:</label>
        <input type="text" id="inspectionDates" name="installation_details[inspectionDates]" class="form-control" value="<?=htmlspecialchars($installation_data['inspectionDates'] ?? '', ENT_QUOTES, 'UTF-8')?>">        
        </div>

        <div class="form-group mb-4 col-12 col-md-6">
        <label class="form-label lead" for="inspectioNextDate">Date on which next inspection and testing should be carried out:</label>
        <input type="date" id="inspectioNextDate" name="installation_details[inspectioNextDate]" class="form-control" value="<?=htmlspecialchars($installation_data['inspectioNextDate'] ?? '', ENT_QUOTES, 'UTF-8')?>">        
        </div>
    </div>
    </form>
  `;

    loadModalContent(dest, "confirmBox", "modal-xl", 1060, "true", "Confirm report complete", "cancelConfirm", saveReportDetails);
    document.querySelectorAll('.form-control').forEach(function(selectEl) {
        new mdb.Select(selectEl);
    });
}

function saveReportDetails() {
    const form = document.getElementById('formComplete');
    const formData = new FormData(form);
    formData.append("stage", `save_stage_1`);
    formData.append("reportComplete", `1`);

    fetch(`${ROOT_URL}/includes/elec/load_stage.php?tenant=${TENANT_URL}`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showResponse("success", "Installation details saved successfully.");
                //alert('Installation details saved successfully.');
            } else {
                //debug(response)
                showResponse("danger", "Error saving installation details: " + data.message);
            }
        })
        .catch(error => {
            console.error('Error saving installation details:', error);
            alert('An error occurred while saving installation details.');
        });
}


function cancelReport() {
    alert("Cancel report functionality is triggered.");
}
</script>
<?php if ($circuitsCount === 0): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update the landing message in the stageContent area.
    var stageContent = document.getElementById('stageContent');
    if (stageContent) {
        stageContent.innerHTML = `
            <div id="landingMessage" class="d-flex flex-column align-items-center justify-content-center my-5">
                <span class="fa-stack fa-4x">
                    <i class="fad fa-square fa-stack-2x text-dark"></i>
                    <i class="fad fa-bolt fa-stack-1x text-light fa-inverse"></i>
                </span>
                <h2 class="mt-3 text-primary">Electrical Inspection Report</h2>
                <p class="lead text-muted">Select a stage from the checklist to begin your inspection.</p>
                <div class="alert alert-warning mt-3">
                    No circuits detected. Please <a href="index.php?t=includes/master&p=elec.php&view=elec_new_circuit&data=<?= $d[0]?>|<?= $d[1]?>|<?= $d[2]?>" class="alert-link">define at least one circuit</a>.
                </div>
            </div>
        `;
    }

    // Disable all the stage checklist items.
    var stageItems = document.querySelectorAll('#reportChecklist li');
    stageItems.forEach(function(li) {
        li.classList.add('disabled'); // Bootstrap's disabled styling (if available)
        li.style.pointerEvents = 'none'; // Prevent clicks
        li.style.opacity = '0.6'; // Visual indication of disabled state
    });
});
</script>
<?php endif; ?>