<?php
if (!isset($_REQUEST['circuit_id']) || !isset($_REQUEST['data'])) {
    die("Error: Missing required parameters.");
}

$circuit_id = intval($_REQUEST['circuit_id']);
$data = explode("|", $_REQUEST['data']);
$board_id = intval($data[0]);

function get_board_details($board_id) {
    global $con;
    $query = "
       SELECT 
            b.board_name, 
            CONCAT(l.locname, ' [ ', l.postcode, ' ]') AS location_name,
            (
                SELECT COUNT(DISTINCT LEFT(circuit_no, LENGTH(circuit_no) - 2)) 
                FROM elec_circuit 
                WHERE board_id = ?
            ) AS existing_circuits 
        FROM elec_board b
        LEFT JOIN locations l ON b.locnumber = l.locnumber
        WHERE b.board_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("ii", $board_id, $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    return $row ?: ['board_name' => 'Unknown', 'location_name' => 'Unknown', 'existing_circuits' => 0];
}

$board_details = get_board_details($board_id);
?>
<div class="note note-secondary mb-3">
    <strong>Editing a circuit:</strong> When editing a new circuit, the only required field is the "Circuit Description", all others can be left blank. If this has been incorporated into a report, the report will need to be regenerated in
    order to apply any changes to the circuit in the document.
</div>
<div class="container-fluid mt-3">
    <div class="row">
        <!-- Form Column -->
        <div class="col-md-9 order-2 order-md-1">
            <form id="editCircuitForm">
                <input type="hidden" name="tenant" value="<?= TENANT_URL ?>">
                <input type="hidden" name="circuit_id" value="<?= $circuit_id ?>">
                <input type="hidden" name="board_id" value="<?= $board_id ?>">

                <!-- Placeholder for dynamic content -->
                <div id="circuitsContainer"></div>

                <!-- Submit Button -->
                <button id="btn_update" type="button" class="btn btn-info mt-3 hidden" onclick="updateCircuit()">Update Circuit</button>
            </form>
        </div>
        <!-- Vital Statistics Column -->
        <div class="col-md-3 order-1 order-md-2 mb-4">

            <div class="card">
                <div class="card-header">
                    Board Information
                </div>
                <div class="card-body">
                    <p><strong>Board Name:</strong> <?= htmlspecialchars($board_details['board_name']) ?></p>
                    <p><strong>Location:</strong> <?= htmlspecialchars($board_details['location_name']) ?></p>
                    <p><strong>Existing Circuits:</strong> <?= $board_details['existing_circuits'] ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
// Fetch and populate circuit data
document.addEventListener("DOMContentLoaded", () => {
    fetch(ROOT_URL + '/includes/elec/fetch_circuit_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `circuit_id=<?= $circuit_id ?>&board_id=<?= $board_id ?>&tenant=<?= TENANT_URL ?>`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const circuits = data.data;
                const container = document.getElementById('circuitsContainer');
                container.innerHTML = ''; // Clear any previous content

                circuits.forEach((circuit, index) => {
                    // Determine whether to hide this card (all but the first will be hidden)
                    const isHidden = index === 0 ? '' : 'd-none';

                    // Determine header color based on the ending of circuit.circuit_no.
                    // Adjust the conditions if needed.
                    let headerColor = '';
                    const ending = circuit.circuit_no.slice(-2); // get the last two characters
                    if (ending === 'L1') {
                        headerColor = 'darkred';
                    } else if (ending === 'L2') {
                        headerColor = 'darkgrey';
                    } else if (ending === 'L3') {
                        headerColor = 'black';
                    }

                    container.innerHTML += `
                    <div class="card mb-3">
                        <div class="card-header d-flex justify-content-between align-items-center" style="background-color: ${headerColor} !important;">
                            <strong id="card-header-${circuit.circuit_no}">Circuit ${circuit.circuit_no}</strong>
                            <button type="button" class="btn btn-link p-0 text-light" onclick="toggleCard('card-body-${circuit.circuit_no}')">
                                &#9660;
                            </button>
                        </div>
                        <div class="card-body ${isHidden}" id="card-body-${circuit.circuit_no}">
                            <input type="hidden" name="circuit_no[]" value="${circuit.circuit_no}">
                            <div class="mb-3">
                                <label class="form-label">Circuit Description</label>
                                <input type="text" class="form-control" name="circuit_description[]" value="${circuit.circuit_description || ''}">
                            </div>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Cable Type</label>
                                    <input type="text" class="form-control" name="cable_type[]" value="${circuit.cable_type || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Reference Method</label>
                                    <input type="text" class="form-control" name="reference_method[]" value="${circuit.reference_method || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Live (mm²)</label>
                                    <input type="number" class="form-control" name="number_size_live[]" value="${circuit.number_size_live || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">CPC (mm²)</label>
                                    <input type="number" class="form-control" name="number_size_cpc[]" value="${circuit.number_size_cpc || ''}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">BS(EN)</label>
                                    <input type="text" class="form-control" name="bsen[]" value="${circuit.bsen || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">BS(EN) Type</label>
                                    <input type="text" class="form-control" name="bs_type[]" value="${circuit.bs_type || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Rating (A)</label>
                                    <input type="number" class="form-control" name="rating[]" value="${circuit.rating || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Breaking Capacity (kA)</label>
                                    <input type="number" step="0.01" class="form-control" name="breaking_capacity[]" value="${circuit.breaking_capacity || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">RCD Tripping Current (mA)</label>
                                    <input type="number" class="form-control" name="rcd_tripping_current[]" value="${circuit.rcd_tripping_current || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">RCD Type</label>
                                    <input type="text" class="form-control" name="rcd_type[]" value="${circuit.rcd_type || ''}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Max Allowed ZS (Ω)</label>
                                    <input type="number" step="0.01" class="form-control" name="max_allowed_zs[]" value="${circuit.max_allowed_zs || ''}">
                                </div>
                            </div>
                        </div>
                    </div>
                    `;
                });
            } else {
                alert('Failed to load circuit data: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error fetching circuit data:', error);
        });
});


// Toggle card visibility
function toggleCard(id) {
    const cardBody = document.getElementById(id);
    if (cardBody.classList.contains('d-none')) {
        cardBody.classList.remove('d-none');
    } else {
        cardBody.classList.add('d-none');
    }
}

// Submit updates
function updateCircuit() {
    const form = document.getElementById('editCircuitForm');
    const formData = new FormData(form);

    fetch(ROOT_URL + '/includes/elec/elec_update_circuit.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showResponse('success', 'Circuits updated successfully!');
                window.location.href = 'index.php?t=includes/master&p=elec.php&view=elec_list_circuit&data=<?= $_REQUEST['data']?>'
            } else {
                showResponse('danger', 'Update failed: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error during update:', error);
        });
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=client.php&view=list">Clients</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&clientnumber=<?= $d['1']?>&view=elec_client"><?= $cd['clientname']?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&view=elec_list_circuit&data=<?=$_REQUEST['data']?>">Board: <?= htmlspecialchars($board_details['board_name']) ?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item active">Edit Circuit</li>'

    document.getElementById('footerControls').innerHTML = '<button class="btn btn-secondary" onclick="triggerAction(\'btn_update\')">Update Circuit</button>';

});
</script>