<?php
require_once('../../../' . $_REQUEST['tenant'] . '/config.php');

if (!isset($_POST['report_id']) || !isset($_POST['stage'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters.']);
    exit;
}

$report_id = intval($_POST['report_id']);
$stage = intval($_POST['stage']);

// Determine the correct column to clear
switch ($stage) {
    case 1:
        $column = 'installation_details';
        break;
    case 2:
        $column = 'schedule_of_inspection';
        break;
    case 3:
        $column = 'condition_schedule';
        break;
    case 4:
        $column = 'circuit_results';
        break;
    default:
        echo json_encode(['success' => false, 'message' => 'Invalid stage.']);
        exit;
}

// Clear the data from the selected column
$updateQuery = "UPDATE elec_report SET $column = NULL WHERE report_id = ?";
$stmt = $con->prepare($updateQuery);
$stmt->bind_param("i", $report_id);
$success = $stmt->execute();
$stmt->close();

// Also reset the stage_status for this stage
$query = "SELECT stage_status FROM elec_report WHERE report_id = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $report_id);
$stmt->execute();
$result = $stmt->get_result();
$reportData = $result->fetch_assoc();
$stmt->close();

// Decode stage_status JSON
$stageStatus = !empty($reportData['stage_status']) ? json_decode($reportData['stage_status'], true) : [];

// Remove the cleared stage from stage_status
unset($stageStatus[$stage]);

// Encode and update stage_status
$stageStatusJson = json_encode($stageStatus);
$updateStatusQuery = "UPDATE elec_report SET stage_status = ? WHERE report_id = ?";
$updateStatusStmt = $con->prepare($updateStatusQuery);
$updateStatusStmt->bind_param("si", $stageStatusJson, $report_id);
$updateStatusSuccess = $updateStatusStmt->execute();
$updateStatusStmt->close();

// Remove all images for this report

$imagesFolder = '../../../' . $_REQUEST['tenant'] . '/images/report_images';

// Create the pattern for files starting with the report_id followed by an underscore and ending with .jpg
$pattern = $imagesFolder . '/' . $report_id . '_*.jpg';

// Get an array of matching files
$files = glob($pattern);

// Loop through each file and delete it
foreach ($files as $file) {
    if (is_file($file)) {
        // Optionally, you can check if unlink() returns false and log an error
        unlink($file);
    }
}

// --------------------------

if ($success && $updateStatusSuccess) {
    echo json_encode(['success' => true, 'message' => 'Stage cleared successfully.', 'stage_status' => $stageStatus]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to clear stage.']);
}
?>