<?php
// includes/surveyor/boost_request.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/* Config: tenant-first load is already active in core runtime.
   We only need access to $con for tenant, $admin_con is NOT required here since we only post to admin. */
 if(file_exists('../../../'.$_REQUEST['tenant'].'/config.php')) {
    require_once('../../../'.$_REQUEST['tenant'].'/config.php');}
// Inputs
$client_id = isset($_REQUEST['client_id']) ? (int)$_REQUEST['client_id'] : 0;
if ($client_id <= 0) {
    $r = $GLOBALS['con']->query("SELECT client_id FROM subscription_params LIMIT 1");
    if ($r && ($row = $r->fetch_assoc())) $client_id = (int)$row['client_id'];
}

// Tenant-side capacity overview
$base_limit = 0; 
$active     = 0;

$sr = $GLOBALS['con']->query("SELECT surveyor_limit FROM subscription_params LIMIT 1");
if ($sr && ($row = $sr->fetch_assoc())) $base_limit = (int)$row['surveyor_limit'];

$cr = $GLOBALS['con']->query("SELECT COUNT(*) AS c FROM surveyor WHERE statuslive=1");
if ($cr && ($row = $cr->fetch_assoc())) $active = (int)$row['c'];

// Endpoint: post to admin system

$ADMIN_DEST = 'https://'.ADMIN_DEFER; // ensure correct host
$ACTION = $ADMIN_DEST . '/files/boost_request_save.php';
?>
<div id="boost-request" class="container-fluid py-2">
  <!-- … your capacity note … -->

  
<form id="boostForm">
  <input type="hidden" name="tenant" value="<?= TENANT_URL ?>">
  <input type="hidden" name="client_id" value="<?= (int)$client_id ?>">
  <div class="mb-3">
    <label for="qty" class="form-label">Number of extra surveyors</label>
    <input type="number" name="qty" id="qty" class="form-control" required min="1">
  </div>
  <div class="mb-3">
    <label for="reason" class="form-label">Reason</label>
    <textarea name="reason" id="reason" class="form-control"></textarea>
  </div>
  <button type="button" class="btn btn-info" onclick="submitBoost()">Submit Boost Request</button>
</form>
</div>

<?php


?>
<script>
function submitBoost() {
  const form = document.getElementById('boostForm');
  const formData = new FormData(form);

  // ABSOLUTE URL. No ROOT_URL.
  fetch("<?= htmlspecialchars($ACTION) ?>", {
    method: 'POST',
    body: formData
  })
  .then(r => r.text())
  .then(() => { showResponse('success','Boost request submitted'); killModal('popupBox'); })
  .catch(() => { showResponse('danger','Error submitting boost request'); });
}
</script>