<div class="note note-secondary mb-4">
    In order to integrate your chosen vehicles into the finance module, you must add your vehicles details here. For tax purposes, please set the initial mileage of the vehicle, if migrating from another system, please state the current
    mileage claimed for the financial year so far. Each claim will be caluclated and this figure will automatically appended.
</div>

<div class="row mb-4">
    <div class="col-12">
        <a href="javascript:void(0)" class="btn btn-secondary float-end" onClick="regNew()">New Vehicle <i class="fad fa-plus "></i></a>
    </div>
</div>

<div class="row">
    <div id="vehicleData"></div>
</div>

<script>
function getVehicles() {
    fetch(ROOT_URL + '/includes/vehicles/vehicle_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "getVehicles",
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(ret => {
            document.getElementById('vehicleData').innerHTML = ret;
        })
        .catch(error => console.error('Error fetching vehicles:', error));
}

getVehicles();

function regNew() {
    const url = ROOT_URL + '/includes/vehicles/vehicle_new.php';
    const params = 'tenant=' + encodeURIComponent(TENANT_URL);

    loadContentAndExecuteScripts(url, 'vehicleData', params, function() {
        console.log('New vehicle form loaded successfully');
    });
}

function cancelNew() {
    getVehicles();
}


function editVehicle(i) {
    const url = ROOT_URL + '/includes/vehicles/vehicle_edit.php';
    const params = 'tenant=' + encodeURIComponent(TENANT_URL) + '&id=' + encodeURIComponent(i);

    loadContentAndExecuteScripts(url, 'vehicleData', params, function() {
        console.log('Edit vehicle form loaded successfully');
    });
}


function confirmRemoveVehicle(i) {
    const dest = "<p>Are you sure you want to remove this vehicle?</p>";
    loadModalContent(dest, "confirmBox", "modal-md", 1060, "true", "", "cancelConfirm", () => removeVehicle(i));
}

function removeVehicle(i) {
    const row = document.getElementById('row' + i);
    row.classList.add('table-danger');
    row.style.transition = "opacity 0.5s ease-out";
    row.style.opacity = "0";

    setTimeout(() => {
        row.style.display = "none";
        fetch(ROOT_URL + '/includes/vehicles/vehicle_functions.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    FUNCTION: 'del',
                    id: i,
                    tenant: TENANT_URL
                })
            })
            .then(response => response.text())
            .then(ret => {
                if (ret.trim() === "s") {
                    showResponse('success', 'Vehicle deleted successfully');
                    killModal('confirmBox');
                }
            })
            .catch(error => console.error('Error deleting vehicle:', error));
    }, 500); // Adjust fadeOut timing
}



// Update breadcrumb navigation
document.getElementById('navBox').innerHTML = `
    <li class="breadcrumb-item">Tools 
        <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i>
    </li>
    <li class="breadcrumb-item active">Vehicles</li>`;
</script>