<?php
if (file_exists('/config.php')) {
    require_once('/config.php');
}

$stateFile = '/home/enrepco/' . TENANT_URL . '/.tenant_state.json';
$msg = '';
$until = '';
if (is_file($stateFile)) {

    $raw = @file_get_contents($stateFile);
    if ($raw !== false) {
        $st = json_decode($raw, true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($st)) {
            $msg   = trim((string)($st['message'] ?? ''));
            $until = trim((string)($st['until'] ?? ''));
        }
    }
}
?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <?= "
  <link href='" . ROOT_URL . "/packages/mdb/css/mdb.min.css' rel='stylesheet' />
  <link href='" . ROOT_URL . "/packages/mdb/plugins/css/all.min.css' rel='stylesheet' />
  <link href='" . ROOT_URL . "/src/css/custom2.min.css' rel='stylesheet'/>
  <link href='" . ROOT_URL . "/packages/font-awesome/css/all.min.css' rel='stylesheet' />"; ?>
    <title>Maintenance</title>
</head>

<body style="background:#202f43">
    <div class="container py-5">
        <div class="card shadow-3 rounded-4">
            <div class="card-body text-center p-5">
                <i class="fad fa-tools fa-3x mb-3"></i>
                <h3 class="mb-2">Scheduled maintenance</h3>
                <p class="text-muted mb-4">EnRep is temporarily unavailable. Try again shortly.</p>

                <?php if ($msg !== '' || $until !== ''): ?>
                <div class="alert alert-warning text-start mx-auto" style="max-width:720px">
                    <?php if ($msg !== ''): ?>
                    <p class="text-dark text-center fs-5"><?= nl2br(htmlspecialchars($msg, ENT_QUOTES, 'UTF-8')) ?></p>
                    <?php endif; ?>

                </div>
                <?php endif; ?>

                <button class="btn btn-info" data-mdb-ripple-init data-mdb-tooltip-init data-mdb-placement="top"
                    data-mdb-trigger="hover" title="Retry" onclick="location.reload()">
                    <i class="fad fa-sync-alt me-2"></i>Reload
                </button>
            </div>
            <div class="col-12 text-center"><img src='<?= ROOT_URL ?>/images/logo_border.png' /></div>
        </div>
    </div>
</body>

</html>