<?php
if (file_exists('../../../' . $_REQUEST['tenant'] . '/config.php')) {
    require_once('../../../' . $_REQUEST['tenant'] . '/config.php');
}
if (file_exists('/config.php')) {
    require_once('/config.php');
}

require('../asset/asset_functions.php');
//LOAD WS DATA
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `lwrittenscheme` WHERE `id`=? ") or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i', $_REQUEST['lws']);
$stmt->execute();
$s = $stmt->get_result();
$stmt->close();
$n = mysqli_fetch_array($s);

// CHECK REV STATUS & SET SAVEMODE
if ($n['rev'] == "0") {
    $active = "no";
    $savemode = "standalone";
} else {
    $savemode = "revise";
}
if ($n['del'] == "0") {
    $alertDelivery = 'none';
} else {
    $alertDelivery = 'block';
}
//GET CLIENT DETAILS
$stmt = $GLOBALS['con']->prepare("SELECT `clientnumber`,`clientname`,`contract_number`,`email` FROM `clientdetails` WHERE `clientnumber`='" . $n['clientnumber'] . "' ") or die(mysqli_error($GLOBALS['con']));
$stmt->execute();
$cc = $stmt->get_result();
$stmt->close();
$cd = mysqli_fetch_array($cc);

//LOAD LWS CURRENT LIST
$ilist = array();
$itable = array();
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `lwsitems` WHERE `lwsnumber`=? AND `type`='1'") or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i', $n['id']);
$stmt->execute();
$cic = $stmt->get_result();
$stmt->close();
while ($cicl = mysqli_fetch_array($cic)) {
    $ilist[] = $cicl['itemnumber'];
    $itable[] = $cicl;
}

//LOAD WS CURRENT LIST
$lilist = array();
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `wsitems` WHERE `wsnumber`=? AND `type`='1'") or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i', $n['id']);
$stmt->execute();
$cic = $stmt->get_result();
$stmt->close();
while ($cicl = mysqli_fetch_array($cic)) {
    $lilist[] = $cicl['itemnumber'];
}

//LOAD CLIENT ITEMS
$stmt = $GLOBALS['con']->prepare("SELECT `clientnumber`,`itemnumber`,`desc`,`serialnumber`,`plantnumber`,`locnumber` FROM `itemdetails` WHERE `clientnumber`=? AND `statuslive`='1'") or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i', $n['clientnumber']);
$stmt->execute();
$ic = $stmt->get_result();
$stmt->close();


?>
<div class="col-12">
    <div id="prompt" style="display:<?= $alertDelivery ?>">
        <p class="alert alert-danger text-center">A revision has been detected - Reissue documents</p>
    </div>
</div>
<div id="modeSwitch" class="row">
    <div class="col-12">
        <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" id="details-tab" data-mdb-toggle="tab" href="#details-content" role="tab"
                    aria-controls="details-content" aria-selected="true" data-mdb-tooltip-init data-mdb-trigger="hover"
                    data-mdb-placement="bottom" title="Written Scheme Details">
                    <i class="fad fa-file-alt"></i> Details
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link text-dark" id="parts-tab" data-mdb-toggle="tab" href="#parts-content" role="tab"
                    aria-controls="parts-content" aria-selected="false" data-mdb-tooltip-init data-mdb-trigger="hover"
                    data-mdb-placement="bottom" title="Parts Of the system">
                    <i class="fad fa-cogs"></i> Parts
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link text-dark" id="delivery-tab" data-mdb-toggle="tab" href="#delivery-content"
                    role="tab" aria-controls="delivery-content" aria-selected="false" data-mdb-tooltip-init
                    data-mdb-trigger="hover" data-mdb-placement="bottom" title="Deliver documents">
                    <i class="fad fa-truck"></i> Delivery
                </a>
            </li>
            <li class="ms-auto">
                <?php if (file_exists('../../../' . TENANT_URL . '/output/lwsfiles/' . $n['clientnumber'] . '/' . $n['id'] . '.pdf')) { ?><a
                    class="btn btn-secondary btn-sm"
                    href="output/lwsfiles/<?= $n['clientnumber'] ?>/<?= $n['id'] ?>.pdf" target="_blank"><i
                        class="fad fa-file"></i></a><?php } else {
                                                    } ?>
                <div id="delButtons" class="mt-3 mb-n3">
                    <span id="lwsDownload">
                        <?php if (file_exists('../../../' . TENANT_URL . '/output/lwsfiles/' . $n['clientnumber'] . '/' . $n['id'] . '.pdf')) { ?><a
                            class="btn btn-info btn-sm"
                            href="output/lwsfiles/<?= $n['clientnumber'] ?>/<?= $n['id'] ?>.pdf?<?= rand() ?>"
                            target="_blank" data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover"
                            totitle="hover" title="View stored WS documentation"><i class="fad fa-file-pdf"></i>
                            LWS</a><?php } else {
                                                                                                                                                                                                    } ?>
                    </span>

                </div>
            </li>
        </ul>
    </div>

</div>
<div class="tab-content" id="myTabContent">


    <div class="tab-pane fade show active" id="details-content" role="tabpanel" aria-labelledby="details-tab">
        <div class="card">
            <div class="card-header">Details</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label class="col-12 col-md-6 control-label" for="contract_number">Contract No</label>
                            <div class="col-12 col-md-4"><input class="form-control form-control-sm " type="text"
                                    name="contract_number" id="contract_number" value="<?= $cd['contract_number'] ?>"
                                    readonly /></div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row">
                            <label class="col-12 col-md-6 control-label" for="no">Written Scheme No</label>
                            <div class="col-12 col-md-4"><input class="form-control form-control-sm " type="text"
                                    name="no" id="no" value="<?= $n['no'] ?>" readonly /></div>
                        </div>
                    </div>

                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group row">
                            <div class="col-md-4"><label class="control-label" for="wSol">Periodicity</label></div>
                            <div class="col-md-5"><select class="form-control form-control-sm" name="wSol" id="wSol">
                                    <option value="">SELECT</option>
                                    <option value="6" <?php if ($n['wSol'] == 6) { ?> selected<?php } ?>>6</option>
                                    <option value="12" <?php if ($n['wSol'] == 12) { ?> selected<?php } ?>>12</option>
                                    <option value="18" <?php if ($n['wSol'] == 18) { ?> selected<?php } ?>>18</option>
                                    <option value="24" <?php if ($n['wSol'] == 24) { ?> selected<?php } ?>>24</option>
                                </select></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group row">
                            <div class="col-md-4"><label class="control-label" for="title">Title</label></div>
                            <div class="col-12 col-md-4"><input class="form-control form-control-sm " type="text"
                                    name="title" id="title" value="<?= $n['title'] ?>" /></div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="col-12 col-md-4" data-mdb-select-init>
                            <label class="control-label" for="surveyor">Certified by</label>
                            <?= listSurveyor($n['surveyor'], 'wsSurveyor', 'select') ?>
                        </div>
                    </div>


                    <div id="date-picker" class="col-12 col-md-6 " data-date-type="open" data-mdb-toggle-button="false">
                        <label class="control-label" for="date">Date of creation</label>
                        <input class="form-control form-control-sm" data-mdb-confirmDateOnSelect
                            data-mdb-toggle="datepicker" type="text" name="date" id="date"
                            value="<?php if ($n['date'] != "") echo htmlspecialchars(date('d-m-Y', $n['date'])); ?>" />
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-12 mt-5">
                        <div id="setButton" class="float-start"><span class="badge badge-pill badge-info">r-2</span>
                        </div>
                        <div class="text-center float-end"><button class="btn btn-success" onclick="saveWs()"> Save
                                Details</button></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="tab-pane fade" id="parts-content" role="tabpanel" aria-labelledby="parts-tab">
        <div class="card">
            <div class="card-header">Parts <a href="javascript:void(0)"
                    class="btn btn-success btn-sm float-end m-0 px-3 py-2 z-depth-0 waves-effect"
                    onClick="toggleVisibility('parts')"><i class="fad fa-plus"></i></a></div>
            <div class="card-body">
                <div id="parts" style="max-height:300px; overflow-y:auto; display:none">
                    <h2>Add new item to the Written Scheme <div class="float-end"><a href="javascript:void(0)"
                                class="btn btn-secondary" onclick="toggleVisibility('parts')">Hide</a></h2>
                    <table id="inactive" class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Serial</th>
                                <th>Plantnumber</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($itd = mysqli_fetch_array($ic)) {
                                if (in_array($itd['itemnumber'], $ilist) || in_array($itd['itemnumber'], $lilist)) {
                                } else { ?>
                            <tr>
                                <td><?= $itd['desc'] ?></td>
                                <td><?= $itd['serialnumber'] ?></td>
                                <td><?= $itd['plantnumber'] ?></td>
                                <td align="right">
                                    <a href="index.php?t=includes/master&p=asset.php&view=edit_attached&data=<?= $n['clientnumber'] ?>|<?= $itd['locnumber'] ?>|<?= $itd['itemnumber'] ?>"
                                        class="btn btn-secondary btn-sm me-4" data-toggle="tooltip"
                                        data-placement="left" title="View <?= $itd['desc'] ?>"><i
                                            class="fad fa-eye"></i></a>

                                    <a id="A<?= $itd['itemnumber'] ?>" href="javascript:void(0)"
                                        class="btn btn-success btn-sm"
                                        onClick="addConfirm('<?= $itd['itemnumber'] ?>','A<?= $itd['itemnumber'] ?>')"
                                        data-toggle="tooltip" data-placement="left" title="Add <?= $itd['desc'] ?>"><i
                                            class="fad fa-plus-circle"></i></a>
                                </td>
                            </tr>
                            <?php }
                            } ?>
                        </tbody>
                    </table>
                </div>
                <h2>Current items covered by this Written Scheme</h2>
                <div id="list" style="max-height:200px; overflow-y:auto;">
                    <table id="active" class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Serial</th>
                                <th>Plantnumber</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($itable as $aws) {
                                $stmt = $GLOBALS['con']->prepare("SELECT `clientnumber`,`itemnumber`,`desc`,`plantnumber`,`serialnumber`,`locnumber` FROM `itemdetails` WHERE `itemnumber`=?") or die(mysqli_error($GLOBALS['con']));
                                $stmt->bind_param('i', $aws['itemnumber']);
                                $stmt->execute();
                                $icx = $stmt->get_result();
                                $stmt->close();
                                $itd = mysqli_fetch_array($icx)
                            ?>
                            <tr>
                                <td><?= $itd['desc'] ?></td>
                                <td><?= $itd['serialnumber'] ?></td>
                                <td><?= $itd['plantnumber'] ?></td>
                                <td align="right">
                                    <a href="index.php?t=includes/master&p=asset.php&view=edit_attached&data=<?= $n['clientnumber'] ?>|<?= $itd['locnumber'] ?>|<?= $itd['itemnumber'] ?>"
                                        class="btn btn-secondary btn-sm me-4" data-toggle="tooltip"
                                        data-placement="left" title="View <?= $itd['desc'] ?>"><i
                                            class="fad fa-eye"></i></a>
                                    <a id="R<?= $itd['itemnumber'] ?>" href="javascript:void(0)"
                                        class="btn btn-danger btn-sm "
                                        onClick="delConfirm('<?= $itd['itemnumber'] ?>','R<?= $itd['itemnumber'] ?>')"
                                        data-toggle="tooltip" data-placement="left"
                                        title="Remove <?= $itd['desc'] ?>"><i class="fad fa-minus-circle"></i></a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-pane fade" id="delivery-content" role="tabpanel" aria-labelledby="delivery-tab">
        <div id="delContainer" class="card">
            <div class="card-header">Delivery</div>
            <div class="card-body">
                <div id="delConf" class="text-center"><a class="btn btn-secondary" href="javascript:void(0)"
                        onClick="genLWS()">Generate Documents</a></div>

                <div id="loading" class="col-md-12 text-center" style="display:none">
                    <i class="fa fa-spinner fa-spin fa-3x fa-fw"></i>

                    <div class="spacer"></div>
                </div>

                <div id="delMail" style="display:none">
                    <?php
                    $_REQUEST['mode'] = "popup";
                    $_REQUEST['data'] = $n['clientnumber'] . '|' . $cd['clientname'] . '|' . $cd['email'] . '|Your LOLER Written Scheme|Please find enclosed your LOLER written scheme documentation|../data/lwsfiles/' . $n['clientnumber'] . '/' . $_REQUEST['lws'] . '.pdf';
                    include('../master/mailer.php');
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function genLWS() {
    $('#loading').css('display', 'block')
    $.post(ROOT_URL + '/functions/generators/genLWsPDF.php', {
        clientnumber: '<?= $n['clientnumber'] ?>',
        lwsnumber: '<?= $_REQUEST['lws'] ?>',
        tenant: TENANT_URL
    }, function(result) {
        debug(result)
        if ($.trim(result) === "success") {
            $('#loading').css('display', 'none')
            $('#delConf').css('display', 'none')
            $('#delMail').css('display', 'block')
            $.post(ROOT_URL + '/includes/master/lws_functions.php', {
                mode: 'setLWSIDel',
                lwsnumber: '<?= $n['id'] ?>',
                clientnumber: '<?= $n['clientnumber'] ?>',
                tenant: TENANT_URL
            }, function(result) {
                //debug(result)
            })
            $('#attachment_1').val('<?= $n['id'] ?>.pdf')
            $('#source_1').val('output/lwsfiles/<?= $n['clientnumber'] ?>')
            $('#lwsDownload').html(
                '<a class="btn btn-info btn-sm" href="output/lwsfiles/<?= $n['clientnumber'] ?>/<?= $_REQUEST['lws'] ?>.pdf?<?= rand() ?>" target="_blank" data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover"totitle="hover"  title="View stored LWS documentation"><i class="fad fa-file-pdf"></i> LWS</a>'
            )

            $('#loading').css('display', 'none')
        }
    })

}

$('#mailSendButton').click(function() {
    $('#prompt').fadeOut();
})



function addEConfirm() {
    var dest = "<p>Are you sure you wish to add this exclusion to the Written Scheme?</p>";
    loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Add Item", "cancelConfirm", addEPart);
}

// Function to add exclusion
function addEPart() {
    var val = Math.floor(1000 + Math.random() * 9000);
    var exdesc = document.getElementById('wseDesc').value
    var exswl = document.getElementById('wseSwl').value
    if (exswl == '') {
        showResponse('warning', 'Please add a safe operating limit');
        $('#confirmBox').modal('hide');
        return;
    }
    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'addLWSIE',
                lwsnumber: '<?= $n['id'] ?>',
                clientnumber: '<?= $n['clientnumber'] ?>',
                desc: exdesc,
                swl: exswl,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(() => {
            showResponse('success', 'The exclusion has been successfully added to the WS');
            $('#confirmBox').modal('hide');
            const newRow = `
            <tr id="R${val}">
                <td class="wsDesc">${document.getElementById('wseDesc').value}</td>
                <td class="wsSWL">${document.getElementById('wseSwl').value}</td>
                <td>
                    <a href="javascript:void(0)" class="btn btn-secondary btn-sm" onclick="cloneWse('R${val}')" data-toggle="tooltip" data-placement="left" title="Clone Exclusion">
                        <i class="far fa-clone"></i>
                    </a>
                </td>
            </tr>
        `;
            document.querySelector('#exList tbody').insertAdjacentHTML('beforeend', newRow);
        });
}

// Function to confirm exclusion removal
function delEConfirm(i, l) {
    var dest = "<p>Are you sure you wish to remove this exclusion from the Written Scheme?</p>";
    loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Remove Exclusion", "cancelConfirm", () => delEPart(
        i, l));
}

// Function to remove exclusion
function delEPart(i, l) {
    $('#confirmBox').modal('hide');

    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'removeLWSIE',
                id: i,
                clientnumber: '<?= $n['clientnumber'] ?>',
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(() => {
            showResponse('success', 'The exclusion has been successfully removed from the WS');
            var tr1 = document.getElementById(l).closest('tr');
            tr1.style.display = 'none';
        });
}

// Function to confirm item addition
function addConfirm(i, l) {
    var dest =
        "<p>Are you sure you wish to add this item to the LOLER Written Scheme?<br><small>This will constitute a revision and documents should be re-submitted to the client</small></p>";
    loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Add Item", "cancelConfirm", () => addPart(i, l));
}

// Function to add item
function addPart(i, l) {
    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'addLWSI',
                lwsnumber: '<?= $n['id'] ?>',
                clientnumber: '<?= $n['clientnumber'] ?>',
                itemnumber: i,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(() => {
            showResponse('success', 'The item has been successfully added to the LWS');
            $('#confirmBox').modal('hide');
            var tr1 = document.getElementById(l).closest('tr');
            var cells = tr1.getElementsByTagName('td');
            cells[3].innerHTML = cells[3].innerHTML.replace('addConfirm', 'delConfirm').replace('fa-plus-circle',
                'fa-minus-circle').replace('btn-outline-success', 'btn-outline-danger');
            document.querySelector('#active tbody').appendChild(tr1);
            document.getElementById('prompt').style.display = 'block';
        });
}

// Function to confirm item removal
function delConfirm(i, l) {
    var dest =
        "<p>Are you sure you wish to remove this item from the LOLER Written Scheme?<br><small>This will constitute a revision and documents should be re-submitted to the client</small></p>";
    loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Remove Item", "cancelConfirm", () => delPart(i, l));
}

// Function to remove item
function delPart(i, l) {
    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'removeLWSI',
                lwsnumber: '<?= $n['id'] ?>',
                clientnumber: '<?= $n['clientnumber'] ?>',
                itemnumber: i,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(() => {
            showResponse('success', 'The item has been successfully removed to the LWS');
            $('#confirmBox').modal('hide');
            var tr2 = document.getElementById(l).closest('tr');
            var cells = tr2.getElementsByTagName('td');
            cells[3].innerHTML = cells[3].innerHTML.replace('delConfirm', 'addConfirm').replace('fa-minus-circle',
                'fa-plus-circle').replace('btn-outline-danger', 'btn-outline-success');
            document.querySelector('#inactive tbody').appendChild(tr2);
            document.getElementById('prompt').style.display = 'block';
        });
}

// Function to confirm revision entry removal
function remrevConfirm(i) {
    var dest =
        "<p>Are you sure you wish to revision entry from the LOLER Written Scheme?<br><small>This cannot be undone</small></p>";
    loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Remove revision entry", "cancelConfirm", () =>
        remRev(i));
}

// Function to remove revision entry
function remRev(i) {
    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'remLRev',
                lwsnumber: '<?= $n['id'] ?>',
                clientnumber: '<?= $n['clientnumber'] ?>',
                entry: i,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(() => {
            showResponse('success', 'The entry has been successfully removed from the LWS');
            $('#confirmBox').modal('hide');
            var tr2 = document.getElementById('Rr' + i);
            tr2.style.display = 'none';
        });
}


// Function to reload WS data
function relWs() {
    fetch(`${ROOT_URL}/includes/master/ws_data.php?clientnumber=<?= $n['clientnumber'] ?>`)
        .then(response => response.text())
        .then(html => {
            document.getElementById('lwsData').innerHTML = html;
        });
}


// Function to save WS
function saveWs() {

    if (document.getElementById('wsSurveyor').value === "NULL") {
        showResponse('warning', 'Please specify a Surveyor before saving this Written Scheme');
    } else {
        fetch(ROOT_URL + '/includes/master/lws_functions.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    mode: 'updateLWS',
                    lwsnumber: '<?= $n['id'] ?>',
                    clientnumber: '<?= $n['clientnumber'] ?>',
                    surveyor: document.getElementById('wsSurveyor').value,
                    date: document.getElementById('date').value,
                    wsol: document.getElementById('wSol').value,
                    title: document.getElementById('title').value,
                    tenant: TENANT_URL
                })
            })
            .then(response => response.text())
            .then(result => {

                if (result.trim() === "success") {
                    relLWs();
                    showResponse('success', 'The LOLER written Scheme has been successfully updated');
                } else {
                    console.log(result);
                    showResponse('danger', result);
                }
            });
    }
}

// Function to confirm WS commit
function setConfirm() {
    if (document.getElementById('wsSurveyor').value !== "NULL") {
        var dest =
            "<p>Mark this written scheme as complete?<br><small>Further alterations will be defined as revisions</small></p>";
        loadModalContent(dest, "confirmBox", "modal-lg", 1060, "true", "Commit LOLER Written Scheme", "cancelConfirm",
            setWs);
    } else {
        showResponse('warning', 'Please specify a Surveyor before committing this LOLER Written Scheme');
    }
}


function setWs() {

    fetch(ROOT_URL + '/includes/master/lws_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                mode: 'setLWSI',
                clientnumber: '<?= $n['clientnumber'] ?>',
                lwsnumber: '<?= $n['id'] ?>',
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {
            if (result.trim() === "success") {
                showResponse('success', 'The written Scheme has been successfully locked');
                $('#multiBox').modal('hide');
            } else {
                console.log(result);
                showResponse('danger', result);
            }
        });
}

var modalElement = document.getElementById('myTabContent');
var tabElement = document.getElementById('modeSwitch');



var modalTabs = document.querySelector('#lwsBox .nav-tabs');
var tabElements = modalTabs.querySelectorAll('[data-mdb-toggle="tab"]');
tabElements.forEach((tab) => {
    tab.addEventListener('click', function(e) {
        e.preventDefault();
        var tabTrigger = new mdb.Tab(tab);
        tabTrigger.show();
    });
});


var mySelect = new mdb.Select(document.getElementById('wsSurveyor'), {
    filter: true,
    container: "#lwsBox"
});



var mydate = new mdb.Datepicker(document.getElementById('date-picker'), {
    confirmDateOnSelect: true,
    format: "dd-mm-yyyy",
});
</script>