<?php require_once(ROOT_URL . '/includes/master/form_functions.php'); ?>
<div class="alert alert-info p-2">
    <p class="text-center m-0">Incomplete reports <br>
        </a></h2>
</div>

<div class="tab-content card">

    <div class="tab-pane fade show active" id="repcard" role="tabpanel" aria-labelledby="reptab">
        <?php
        $stmt = $GLOBALS['con']->prepare("
        SELECT a.clientnumber, a.repitem, a.repnumber, a.reptype, a.itemnumber, a.insdate, 
            a.adefect, a.bdefect, b.itemnumber, b.plantnumber, b.desc, b.locnumber, a.result, 
            s.surname, s.forename
        FROM reportitems_temp a
        INNER JOIN itemdetails b ON b.itemnumber = a.itemnumber
        INNER JOIN surveyor s ON s.id = a.esname
        ORDER BY ABS(a.repitem) DESC
        ") or die(mysqli_error($GLOBALS['con']));
        $stmt->execute();
        $r = $stmt->get_result();
        $stmt->close();
        $rnum = mysqli_num_rows($r);
        if ($rnum < 1) { ?>
        <div class="alert alert-warning text-center p-2"><i class="fad fa-exclamation-triangle text-danger"
                aria-hidden="true"></i> No reports on file <i class="fad fa-exclamation-triangle text-danger"
                aria-hidden="true"></i></div>

        <?php } else { ?>

        <div class="row d-flex flex-row flex-wrap">
            <?php
                while ($dta = mysqli_fetch_array($r)) {
                    $tag = "";
                    //$conv=strtotime($dta['insdate']);
                    $date = date('d-m-Y', $dta['insdate']);
                    $adefect = explode("|", $dta['adefect']);
                    if ($dta['result'] == "DEFECTS") {
                        $col = "#F4AA09";
                        $title = "DEFECTS<br>" . $dta['bdefect'];
                        $file = "file-exclamation";
                    }
                    if ($dta['result'] == "URGENT") {
                        $col = "#e96152";
                        $title = "URGENT<br>" . $adefect[0];
                        $file = "file-excel";
                    }
                    if ($dta['result'] == "PASS") {
                        $col = "#007E33";
                        $tag = "Pass";
                        $title = "Pass";
                        $file = "file-powerpoint";
                    }
                    if ($dta['result'] == "OBS") {
                        $col = "#333333";
                        $tag = "Obs";
                        $title = "OBS<br>" . $dta['obs'];
                        $file = "file-alt";
                    }
                    if ($dta['result'] == "PNA") {
                        $col = "#cccccc";
                        $tag = "PNA";
                        $title = "PNA";
                        $file = "file";
                    }
                    if ($dta['result'] == "") {
                        $col = "#9211E8";
                        $tag = "P2UD";
                        $title = "P2UD";
                        $file = "file";
                    }

                ?>
            <div id="R<?= $dta['repitem'] ?>" class="col-6 col-md-2 h-100 ">
                <div class="card card-body mb-4">
                    <p class="text-center"><strong><?= getClientName($dta['clientnumber']) ?></strong></p>
                    <p class="fileIcon text-center"><i style="color:<?= $col ?>"
                            class="fad fa-file-signature fa-4x ms-3" aria-hidden="true"></i></p>
                    <p class="text-center">
                        <strong><?= $dta['desc'] ?></strong><br><?= $dta['plantnumber'] ?><br><small><?= getReportDesc($dta['reptype'], 'formtype') ?></small><br>
                        <?= $date ?><br><small class="text-info">Started by: <b><?= $dta['forename'] ?>
                                <?= $dta['surname'] ?></b></small>
                    </p>
                    <p class="text-center">
                        <a href="index.php?t=includes/master&p=formgen.php&mode=continue&formnumber=<?= $dta['reptype'] ?>&repnumber=<?= $dta['repnumber'] ?>&data=<?= $dta['clientnumber'] ?>|<?= $dta['locnumber'] ?>|<?= $dta['itemnumber'] ?>&savemode=edit"
                            class="btn btn-secondary ms" data-mdb-tooltip-init data-mdb-placement="bottom"
                            data-mdb-trigger="hover" data-mdb-trigger="hover" title="Edit Report"><i
                                class="fad fa-pencil"></i></a>

                        <a href="javascript:void(0)" onclick="removeRep('<?= $dta['repitem'] ?>')"
                            class="btn btn-danger ms-4" data-mdb-tooltip-init data-mdb-placement="bottom"
                            data-mdb-trigger="hover" title="Delete Report"><i class="fad fa-trash"></i></a>
                    </p>
                </div>
            </div>

            <?php } ?>
        </div>
        <?php } ?>
    </div>

</div>
<script>
function getChecks() {
    var selected = ''
    $('input[type=checkbox]').each(function() {
        if ($(this).is(":checked")) {
            selected = selected + ($(this).attr('name') + '|');
        }

    });
    //alert(selected)
}

function removeRep(r) {

    const target = event.target.dataset.href;
    var dest = '<p class="text-center">Are you sure you wish to remove this incomplete report?</p>';
    loadModalContent(dest, "killBox", "modal-xl", 1060, "true", "Remove incomplete report", 'cancelConfirm', () =>
        confirmRemove(r));

}

function confirmRemove(r) {
    $.post('<?= ROOT_URL ?>/includes/master/items.php', {
        mode: 'removeReport',
        id: r,
        tenant: TENANT_URL
    }, function(ret) {

        $("#R" + r).fadeOut();
        showResponse('success', 'Report removed from the system successfully')
        killModal('killBox')
    })
}
document.getElementById('navBox').innerHTML = '<li class="breadrumb-item active">Incomplete Reports</li>';
</script>