<div id="newButton" class="float-end"><a class="btn btn-secondary" href="javascript:void(0)" onClick="loadNew()"><i class="fad fa-plus"></i> New Entry</a></div>
<div class="col-12 col-md-6 note note-secondary">
    Registered HSE contacts enable automatic delivery of notifications via the report delivery email system.
</div>
<br>
<h3 class="lead"><strong>Registered HSE locations</strong></h3>
<div id="hseTable"></div>
<div id="new_item"></div>

<script>
// Function to load data into #hseTable
function loadData() {
    loadContentAndExecuteScripts(
        ROOT_URL + '/includes/hse/hse_data.php?tenant=' + TENANT_URL, // URL
        'hseTable', // Container ID
        '', // No additional parameters needed for this request
        function() {
            // Any additional initialization or scripts that need to be executed
            var liveAssetTable = document.getElementById('listTable');
            new DataTable(liveAssetTable); // Assuming vanilla DataTable initialization

        }
    );
}

// Function to load new item form into #new_item 
function loadNew() {
    loadContentAndExecuteScripts(
        ROOT_URL + '/includes/hse/hse_new.php?tenant=' + TENANT_URL, // URL
        'new_item', // Container ID
        '', // No additional parameters needed for this request
        function() {
            // Any additional initialization or scripts that need to be executed
            console.log('New item form loaded successfully into #new_item');
        }
    );
}

// Function to load edit item form into #new_item 
function loadEdit(id) {
    loadContentAndExecuteScripts(
        ROOT_URL + '/includes/hse/hse_edit.php?id=' + encodeURIComponent(id) + '&tenant=' + TENANT_URL, // URL with ID
        'new_item', // Container ID
        '', // No additional parameters needed for this request
        function() {
            // Any additional initialization or scripts that need to be executed
            console.log('Edit form loaded successfully into #new_item');
        }
    );
}

// Load initial data
loadData();

// Update #navBox with HTML content
document.getElementById('navBox').innerHTML = `
    <li class="breadcrumb-item">Tools 
        <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i>
    </li>
    <li class="breadcrumb-item active">Health and Safety Executive Directory</li>
`;

function killtoggle() {
    document.getElementById('new_item').innerHTML = '';
}
</script>