<?php

//asset base local path, ***NO TRAILING SLASH***
define("XF_ASSET_BASE", "documents");

//asset base virtual path - for displaying on page or link
define("XF_ASSET_BASE_VIRTUAL", "documents");

//set readonly mode
define("XF_READ_ONLY", false);

//set document download mode
define("XF_ALLOW_DOWNLOAD", true);

//set allow delete
define("XF_ALLOW_DELETE", true);

//set allow rename
define("XF_ALLOW_RENAME", true);

//allow edit existing image (new in 2.0)
define("XF_ALLOW_EDIT", true);

//maximum upload size.
define("XF_MAX_SIZE", 2000000);

//automatic creating thumbnails.
define("XF_AUTO_THUMB_CREATION", true);

//max automatic thumbnail width (in px).
define("XF_AUTO_THUMB_MAX_WIDTH", 150);

//max automatic thumbnail height (in px).
define("XF_AUTO_THUMB_MAX_HEIGHT", 120);

//automatic thumbnail target folder.
define("XF_AUTO_THUMB_NAME", "xfthumbs");

//-----------------------------------------
//boot up
//-----------------------------------------

//define image type group
$__IMAGE_FILES = array("jpg", "jpeg", "png", "gif");

//set allowed type for upload.
//$__UPLOAD_FILE_TYPES = array("*"); //allow everything - NOT RECOMMENDED!!!
$__UPLOAD_FILE_TYPES = array("jpg", "jpeg", "png", "gif", "pdf", "zip", "txt", "doc", "docx");


//define language
define("XF_LANGUAGE", "en-US");

//language file
$__XFLANG = parse_ini_file("packages/filebrowser/server/i18n-" . XF_LANGUAGE . ".txt");

//For security, you can add user access/user authentication check below.
//for example:
//   if (not authenticated) die("");

?>

    <link rel="stylesheet" type="text/css" href="packages/filebrowser/css/xprofile.css" />
    <link rel="stylesheet" type="text/css" href="packages/filebrowser/css/xproupload.css" />
    
    <script src="packages/filebrowser/xprofile_lang.js" type="text/javascript"></script>
    <script src="packages/filebrowser/xprofile.js" type="text/javascript"></script>
    <script src="packages/filebrowser/xproupload.js" type="text/javascript"></script>

    <script src="packages/filebrowser/external/caman/dist/caman.full.js" type="text/javascript"></script>
    
   <div id="fileman" class="container"></div>
   
   <script>
        jQuery(document).ready(function() {

            //set readonly, readonly mode, must be called before iniFileManager();
            XPROFile.readonly = <?php print (XF_READ_ONLY==true?"true":"false"); ?>;
			
			XPROFile.download = <?php print (XF_ALLOW_DOWNLOAD==true?"true":"false"); ?>;

            XPROFile.allowDelete = <?php print (XF_ALLOW_DELETE==true?"true":"false"); ?>;
            
            XPROFile.allowRename = <?php print (XF_ALLOW_RENAME==true?"true":"false"); ?>;

            XPROFile.allowEdit = <?php print (XF_ALLOW_EDIT==true?"true":"false"); ?>;

            //set allowed file types, below are default.
            //
            //XPROFile.allowedTypes = ["jpg", "png", "gif", "txt", "jpeg", "zip", "pdf", "doc", "docx"];
            
            //set max upload size, 0 is unlimited, default is 0.
            //This is client limit, upload file size also restricted by 
            //PHP configuration (upload_max_filesize and post_max_size directive in PHP.ini)
            //            
            //XPROFile.maxSize = 0;
        
            XPROFile.iniFileManager();
            
            
        });
    </script>