<?php
function deleteFilesOlderThanYears($dir, $yearsToCheck, $exceptions = []) {
    foreach(glob("$dir/*") as $file) {
        if(is_dir($file)) {
            deleteFilesOlderThanYears($file, $yearsToCheck, $exceptions); // recursively delete files in subfolders
        } else {
            // Check if the file is older than specified number of years
            if(time() - filemtime($file) > $yearsToCheck * 31536000) { // 1 year = 31536000 seconds
                // Check if the file is not in the exceptions list
                if(!in_array(basename($file), $exceptions)) {
                    unlink($file); // delete the file
                    echo "Deleted: $file<br>";
                } else {
                    echo "Skipped (Exception): $file<br>";
                }
            }
        }
    }
}

// Specify the directory you want to start the deletion from
$directory = '/path/to/your/folder';

// Number of years to check
$yearsToCheck = 1;

// List of file names to be excluded from deletion (exceptions)
$exceptions = ['file1.txt', 'file2.jpg'];

deleteFilesOlderThanYears($directory, $yearsToCheck, $exceptions);
?>