<?php switch($_REQUEST['view']){
default: break;
case 'new': require(ROOT_URL.'/includes/broker/broker_new.php');break;
case 'edit': require(ROOT_URL.'/includes/broker/broker_edit.php');break;
case"load": require(ROOT_URL.'/includes/broker/broker_load.php');break;
case "list": require(ROOT_URL.'/includes/broker/broker_list.php');break;
case "clientlist": require(ROOT_URL.'/includes/broker/broker_clientlist.php');break;
}
?>
<script>
function inlineFilter(i) {
    var table = $('#datatable').DataTable();
    table.search(i).draw();
};

function convert(i) {
    var dest = '<p>Do you wish to convert this broker to an agent?</p>';
    loadModalContent(dest, "convertBox", "modal-lg", 1060, "true", "Convert to Agent", "cancelConfirm", () => convertAction(i));

}

function convertAction(i) {
    fetch(ROOT_URL + '/includes/broker/broker_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "convert",
                id: i,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {
            // Process the result (you can debug it here if needed)
            document.getElementById('R' + i).style.display = 'none'; // Equivalent to fadeOut
            killModal('convertBox');
            showResponse('success', 'broker moved to Brokers successfully');
        })
        .catch(error => {
            console.error('Error:', error);
        });
}


document.addEventListener('DOMContentLoaded', function() {
    const brokerForm = document.getElementById('brokerForm');

    if (brokerForm) { // Check if the form exists
        brokerForm.addEventListener('submit', function(event) {
            event.preventDefault();

            const formData = new FormData(brokerForm);

            fetch(ROOT_URL + '/includes/broker/broker_functions.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(result => {

                    if (result.trim() === "success") {
                        showResponse('success', 'Your changes have been saved successfully');
                    } else {
                        showResponse('danger', 'There was a problem, please check your details and try again<br><br>' + result);
                    }

                })
                .catch(error => {
                    console.error('Error:', error);
                });
        });
    }
});



document.body.addEventListener('click', function(event) { // Event delegation on body
    if (event.target.classList.contains('emailButton')) {
        const target = event.target.dataset.href;
        const string = event.target.dataset.values;
        var dest = encodeURI(target + "?data=" + string + "&tenant=" + TENANT_URL);
        loadModalContent(dest, "mailerBox", "modal-xl", 1060, "true", "Direct Mailer");

    }
});
</script>