<?php
if(file_exists('../../../../'.$_REQUEST['tenant'].'/config.php')) {
    require_once('../../../../'.$_REQUEST['tenant'].'/config.php');
}
if(file_exists('/config.php')) {
    require_once('/config.php');
}

$clientnumber = isset($_GET['clientnumber']) ? intval($_GET['clientnumber']) : 0;
if (!$clientnumber) exit;

$q = $con->query("SELECT clientname, contract_number, rate_per_hour, broker_number, commission FROM clientdetails WHERE clientnumber = $clientnumber LIMIT 1");
if (!$q || !$q->num_rows) exit;

$c = $q->fetch_assoc();
$description = 'Renewal of ' . htmlspecialchars($c['clientname']) . ', contract number ' . htmlspecialchars($c['contract_number']);
$fee = floatval($c['rate_per_hour']);
$qty = 1;
$total = number_format($fee * $qty, 2);
$service = 'Contract Renewal';

$commission = '';
if (!empty($c['broker_number']) && $c['broker_number'] > 0 && !empty($c['commission'])) {
    $percent = floatval($c['commission']);
    $com = ($fee * $percent) / 100;
    //$commission = '<small class="text-muted">Broker commission: GBP ' . number_format($com, 2) . '</small>';
}

// Return one row to be injected into #invoiceItems
?>

<tr>
    <td class="align-middle service" contenteditable="true" oninput="calculateInvoiceTotal()"><?= $service ?></td>
    <td class="align-middle notes" contenteditable="true"><?= $description ?></td>
    <td class="align-middle fee" contenteditable="true" oninput="calculateInvoiceTotal()"><?= number_format($fee, 2) ?></td>
    <td class="align-middle qty">1</td>
    <td class="align-middle text-center">
        <button type="button" class="btn btn-sm btn-danger" onclick="confirmRemoveRow(this)" data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" title="Remove entry">
            <i class="fad fa-trash"></i>
        </button>
    </td>
</tr>
<script>
calculateInvoiceTotal();
</script>