<style>
.filterButtons {
    display: none
}

.yellow {
    background-color: yellow
}
</style>
<div class="note note-secondary mb-5"><strong>Asset search:</strong> Search across all clients for matching information, results for both active and archived assets will be matched.</div>
<div class="container">
    <div class="input-group md-form form-sm form-2 pl-0">
        <input id="searchTerm" class="form-control my-0 py-1 red-border" type="text" placeholder="Search" aria-label="Search">
        <div class="input-group-append">
            <span class="input-group-text bg-info text-white" id="basic-text1" onclick="searchAssets()"><i class="fad fa-search text-grey" aria-hidden="true"></i></span>
        </div>
    </div>
</div>
<div id="loadingObject" style="position: fixed; top:50%; width:100%; display:none">
    <h1 class="text-center"><i class="fad fa-radar fa-spin fa-3x fa-fw" style="--fa-primary-color: #0055A6; --fa-secondary-color: gray;"></i><br>Searching Data for "<span id="term"></span>" <br><small><span id="count">Please
                wait</span></small><span class="sr-only">Searching...</span></h1>
</div>

<div id="results"></div>
<link rel="stylesheet" type="text/css" href="<?=ROOT_URL?>/packages/dfinal/datatables.min.css" />
<script type="text/javascript" src="<?=ROOT_URL?>/packages/dfinal/datatables.min.js"></script>
<script>
function searchAssets() {
    var term = document.getElementById('searchTerm').value;

    if (term !== '') {
        document.getElementById('term').textContent = term;
        document.getElementById('searchTerm').value = '';
        document.getElementById('results').innerHTML = '';
        document.getElementById('loadingObject').style.display = 'block';

        // Parameters for the POST request
        var params = 'FCN=search&searchString=' + encodeURIComponent(term) + '&tenant=' + encodeURIComponent(TENANT_URL);

        // Use loadContentAndExecuteScripts to handle the request
        loadContentAndExecuteScripts(
            ROOT_URL + '/includes/asset/asset_search_functions.php', // URL
            'results', // Container ID
            params, // POST parameters
            function() {
                document.getElementById('loadingObject').style.display = 'none';

                // Initialize DataTables after content is loaded
                var liveAssetTable = document.getElementById('liveAssetTable');
                var archiveAssetTable = document.getElementById('archiveAssetTable');

                if (liveAssetTable) {
                    new DataTable(liveAssetTable); // Assuming vanilla DataTable initialization
                }

                if (archiveAssetTable) {
                    new DataTable(archiveAssetTable); // Assuming vanilla DataTable initialization
                }
            }
        );
    } else {
        showResponse('warning', 'Please add a search term before proceeding');
    }
}

document.getElementById('navBox').innerHTML = '<li class="breadcrumb-item">Tools <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item active">Global Asset Search</li>';
</script>