<?php
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `agents` WHERE `agent_number`=?")or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i',$_REQUEST['agent_number']);$stmt->execute();$r=$stmt->get_result();$stmt->close();
$cd=mysqli_fetch_array($r);

$email_values = [
    0 => '0', //client
    1 => $cd['agent_name'], //type
    2 => $cd['email'], //recipient
    3 => '', //subject
    4 => '', //message
    5 => '', //attachment
    6 => '' //source
];
$email64_values = base64_encode(json_encode($email_values));
?>
<style>
.pwstrength_viewport_progress .progress {
    height: 15px !important
}
</style>
<div class="row mb-4">
    <div class="col-12 col-md-12">
        <div class="float-end">
            <?php if($cd['tel']!=""){?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Phone <?= $cd['agent_name']?>" id="phone" href="tel:<?= $cd['tel']?>"
               class="btn btn-secondary noprint me-2"><i class="fad fa-phone"></i></a>
            <?php }?>

            <?php if(!filter_var($cd['email'], FILTER_VALIDATE_EMAIL) === false) {?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Email <?= $cd['agent_name']?>" href="javascript:void(0)"
               class="btn btn-secondary emailButton me-2"
               data-values="<?= $email64_values?>" data-href="<?=ROOT_URL?>/includes/master/mailer.php"><i class="fad fa-envelope"></i></a>
            <?php }if($cd['statuslive']==1){?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Archive <?= $cd['agent_name']?>" href="javascript:void(0)"
               onClick="archiveAgent('<?= $cd['agent_number']?>')"
               class="btn btn-secondary me-2"><i class="fad fa-archive"></i></a>
            <?php } else {?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Reinstate <?= $cd['agent_name']?>" href="javascript:void(0)"
               onClick="reinstateAgent('<?= $cd['agent_number']?>')"
               class="btn btn-secondary"><i class="fad fa-upload"></i></a>
            <?php }?>
        </div>
    </div>
</div>

<form id="agentForm" class="form-horizontal">
    <div class="row">
        <?php require_once(ROOT_URL.'/forms/elements/agent_details.frm');?>
    </div>
    <div class="row">

        <div class="col-12 col-md-4 text-center">
            <div class="card">
                <div class="card-header">Active</div>
                <div class="card-body">
                    <div class="form-group row">
                        <?php if($cd['statuslive']=="1" || $_REQUEST['view']=="new"){$checked="checked";}if($cd['statuslive']=="0"){$checked="";}?>
                        <label class="col-12 col-md-3 control-label" for="statuslive">Live Agent</label>
                        <div class="col-12 col-md-9">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" name="statuslive" id="statuslive" <?= $checked?>>
                                <label class="form-check-label" for="statuslive"></label>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="agent_number" value="<?= $_REQUEST['agent_number']?>">
    <input type="hidden" id="function" name="FUNCTION" value="update">
    <input type="hidden" name="tenant" value="<?=TENANT_URL?>">
    <input id="btn_update" type="submit" name="submit" value="Update" class="hidden" />
</form>


<script type="text/javascript" src="<?=ROOT_URL?>/packages/jqpass/dist/pwstrength-bootstrap.min.js"></script>
<script>
function archiveAgent(i) {
    var dest = '<p>Do you wish to archive this agent?</p>';
    loadModalContent(dest, "archiveBox", "modal-lg", 1060, "true", "Convert to Agent", "cancelConfirm", () => archiveAgentAction(i));

}

function archiveAgentAction(id) {
    fetch(ROOT_URL + '/includes/agent/agent_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "archive",
                id: id,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {

            window.location.href = 'index.php?t=includes/master&p=agent.php&view=list';
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function reinstateAgent(i) {
    var dest = '<p>Do you wish to reinstate this agent?</p>';
    loadModalContent(dest, "reinstateBox", "modal-lg", 1060, "true", "Convert to Agent", "cancelConfirm", () => reinstateAgentAction(i));
}

function reinstateAgentAction(id) {
    fetch(ROOT_URL + '/includes/agent/agent_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "reinstate",
                id: id,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {
            // Handle the result (you can debug if needed)
            window.location.href = 'index.php?t=includes/master&p=agent.php&view=list';
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

document.addEventListener("DOMContentLoaded", function() {
    document.getElementById('footerControls').innerHTML = '<button class="btn btn-secondary" onclick="triggerAction(\'btn_update\')">UPDATE</button>'
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=agent.php&view=list">Agents</a><i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item"><a href="javascript:void(0)">Edit Agent</a><i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item active"><?= $cd['agent_name']?></li>'
});
</script>