<div class="row">
    <!-- Location Details -->
    <div id="detailsBox" class="col-12">
        <div class="card mb-3">
            <div class="card-header">Location Details</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12 col-md-6">
                        <!-- Location Reference -->
                        <div class="mb-2">
                            <label for="locref" class="form-label">Location Reference <small>(Not required)</small></label>
                            <input type="text" id="locref" name="locref" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locref']) ?>" />
                        </div>

                        <!-- Location Name -->
                        <div class="mb-2">
                            <label for="locname" class="form-label">Location Name</label>
                            <input type="text" id="locname" name="locname" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locname']) ?>" placeholder="E.G: Pump House" />
                        </div>

                        <!-- Address 1 -->
                        <div class="mb-2">
                            <label for="locaddress1" class="form-label">First Line of address</label>
                            <input type="text" id="locaddress1" name="locaddress1" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locaddress1']) ?>" />
                        </div>

                        <!-- Address 2 -->
                        <div class="mb-2">
                            <label for="locaddress2" class="form-label">Second Line of address</label>
                            <input type="text" id="locaddress2" name="locaddress2" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locaddress2']) ?>" />
                        </div>

                        <!-- Address 3 -->
                        <div class="mb-2">
                            <label for="locaddress3" class="form-label">Town</label>
                            <input type="text" id="locaddress3" name="locaddress3" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locaddress3']) ?>" />
                        </div>

                        <!-- Address 4 -->
                        <div class="mb-2">
                            <label for="locaddress4" class="form-label">County</label>
                            <input type="text" id="locaddress4" name="locaddress4" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['locaddress4']) ?>" />
                        </div>

                        <!-- Post Code -->
                        <div class="mb-2">
                            <label for="postcode" class="form-label">Post Code</label>
                            <input type="text" id="postcode" name="postcode" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['postcode']) ?>" />
                        </div>
                    </div>

                    <div class="col-12 col-md-6">
                        <!-- Phone 1 -->
                        <div class="mb-2">
                            <label for="phone1" class="form-label">Phone 1</label>
                            <input type="tel" id="phone1" name="phone1" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['phone1']) ?>" />
                        </div>

                        <!-- Phone 2 -->
                        <div class="mb-2">
                            <label for="phone2" class="form-label">Phone 2</label>
                            <input type="tel" id="phone2" name="phone2" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['phone2']) ?>" />
                        </div>

                        <!-- Mobile -->
                        <div class="mb-2">
                            <label for="mobile" class="form-label">Mobile</label>
                            <input type="tel" id="mobile" name="mobile" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['mobile']) ?>" />
                        </div>

                        <!-- Fax -->
                        <div class="mb-2">
                            <label for="fax" class="form-label">Fax</label>
                            <input type="tel" id="fax" name="fax" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['fax']) ?>" />
                        </div>

                        <!-- Email -->
                        <div class="mb-2">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" id="email" name="email" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['email']) ?>" />
                        </div>

                        <!-- Print Label Button -->
                        <div class="text-md-end mt-3">
                            <button type="button" class="btn btn-secondary btn-sm" onclick="printContent('label','Address Information')">
                                <i class="fad fa-print"></i> Print Label
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Hidden Label Table for Printing -->
    <table id="label" class="d-none">
        <tr>
            <td><b><?= htmlspecialchars($_REQUEST['clientname']) ?></b></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['locname']) ?></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['locaddress1']) ?></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['locaddress2']) ?></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['locaddress3']) ?></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['locaddress4']) ?></td>
        </tr>
        <tr>
            <td><?= htmlspecialchars($cd['postcode']) ?></td>
        </tr>
    </table>

    <!-- Contact Details -->
    <div class="col-12 col-md-6">
        <div class="card mb-3">
            <div class="card-header">Contact Details</div>
            <div class="card-body">
                <!-- Primary Contact -->
                <div class="mb-2">
                    <label for="contactlc" class="form-label">Primary Contact</label>
                    <input type="text" id="contactlc" name="contactlc" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['contactlc']) ?>" />
                </div>

                <!-- Secondary Contact -->
                <div class="mb-2">
                    <label for="contactpm" class="form-label">Secondary Contact</label>
                    <input type="text" id="contactpm" name="contactpm" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['contactpm']) ?>" />
                </div>

                <!-- Contact Tel -->
                <div class="mb-2">
                    <label for="contacttel" class="form-label">Contact Tel</label>
                    <input type="text" id="contacttel" name="contacttel" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['contacttel']) ?>" />
                </div>

                <!-- Additional Contact -->
                <div class="mb-2">
                    <label for="contactother" class="form-label">Additional Contact</label>
                    <input type="text" id="contactother" name="contactother" class="form-control form-control-sm" value="<?= htmlspecialchars($cd['contactother']) ?>" />
                </div>
            </div>
        </div>
    </div>

    <!-- Options -->
    <div class="col-12 col-md-6">
        <div class="card mb-3">
            <div class="card-header">Options</div>
            <div class="card-body">
                <!-- Live Location Checkbox -->
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="statuslive" name="statuslive" <?= ($cd['statuslive'] == "1" || $cd['statuslive'] == "") ? "checked" : "" ?> />
                    <label class="form-check-label" for="statuslive">Live Location</label>
                </div>

                <!-- Delivery Format -->
                <div class="mb-2">
                    <label class="form-label" for="report_format">Delivery Format</label>
                    <select class="form-select form-select-sm" id="report_format" name="report_format">
                        <option value="Email" <?= ($cd['report_format'] == "Email") ? "selected" : "" ?>>Email</option>
                        <option value="Paper" <?= ($cd['report_format'] == "Paper") ? "selected" : "" ?>>Paper</option>
                        <option value="Both" <?= ($cd['report_format'] == "Both") ? "selected" : "" ?>>Email & Paper</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Notes -->
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-header">Notes</div>
            <div class="card-body">
                <div class="mb-2">
                    <label for="locnotes" class="form-label">Notes</label>
                    <textarea class="form-control form-control-sm" id="locnotes" name="locnotes" rows="5"><?= htmlspecialchars($cd['locnotes']) ?></textarea>
                </div>
            </div>
        </div>
    </div>
</div>