<?php
// Function to safely get values from the array
function safeValue($array, $key, $default = '', $formatDate = false) {
    // Check if key exists and is not null
    $value = $array[$key] ?? $default;

    // Check if the value needs date formatting
    if ($formatDate && is_numeric($value)) {
        $value = date('d-m-Y', $value); // Convert timestamp to a formatted date
    }

    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

// Check if we are in 'new' mode
$isNewMode = $_REQUEST['view'] === 'new';

// Initialize the $cd array with default values if in new mode
$cd = $isNewMode ? [
    'contractor_name' => '',
    'address1' => '',
    'address2' => '',
    'town' => '',
    'county' => '',
    'post' => '',
    'pri_contact' => '',
    'tel' => '',
    'fax' => '',
    'email' => '',
] : $cd;
?>

<div class="col-12">
    <div class="card">
        <div class="card-header">Contractor Details</div>
        <div class="card-body">
            <div class="row">
                <!-- Left Column -->
                <div class="col-12 col-md-6">
                    <!-- Company Name -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="contractor_name">Company Name</label>
                        <div class="col-12 col-md-9">
                            <input class="form-control" type="text" name="contractor_name" id="contractor_name" 
                                   value="<?= safeValue($cd, 'contractor_name') ?>" required />
                        </div>
                    </div>

                    <!-- Address1 -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="address1">Address1</label>
                        <div class="col-12 col-md-6">
                            <input class="form-control" type="text" name="address1" id="address1" 
                                   value="<?= safeValue($cd, 'address1') ?>" required />
                        </div>
                    </div>

                    <!-- Address2 -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="address2">Address2</label>
                        <div class="col-12 col-md-6">
                            <input class="form-control" type="text" name="address2" id="address2" 
                                   value="<?= safeValue($cd, 'address2') ?>" />
                        </div>
                    </div>

                    <!-- Town -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="town">Town</label>
                        <div class="col-12 col-md-6">
                            <input class="form-control" type="text" name="town" id="town" 
                                   value="<?= safeValue($cd, 'town') ?>" />
                        </div>
                    </div>

                    <!-- County -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="county">County</label>
                        <div class="col-12 col-md-6">
                            <input class="form-control" type="text" name="county" id="county" 
                                   value="<?= safeValue($cd, 'county') ?>" />
                        </div>
                    </div>

                    <!-- Postcode -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="post">Postcode</label>
                        <div class="col-12 col-md-4">
                            <input class="form-control" type="text" name="post" id="post" 
                                   value="<?= safeValue($cd, 'post') ?>" />
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-12 col-md-6">
                    <!-- Primary Contact -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="pri_contact">Primary Contact</label>
                        <div class="col-12 col-md-8">
                            <input class="form-control" type="text" name="pri_contact" id="pri_contact" 
                                   value="<?= safeValue($cd, 'pri_contact') ?>" required />
                        </div>
                    </div>

                    <!-- Telephone -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="tel">Tel</label>
                        <div class="col-12 col-md-5">
                            <input class="form-control" type="tel" name="tel" id="tel" 
                                   value="<?= safeValue($cd, 'tel') ?>" required />
                        </div>
                    </div>

                    <!-- Fax -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="fax">Fax</label>
                        <div class="col-12 col-md-5">
                            <input class="form-control" type="tel" name="fax" id="fax" 
                                   value="<?= safeValue($cd, 'fax') ?>" />
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="form-group row mb-3">
                        <label class="col-12 col-md-2 control-label" for="email">Email</label>
                        <div class="col-12 col-md-8">
                            <input class="form-control" type="email" name="email" id="email" 
                                   value="<?= safeValue($cd, 'email') ?>" required />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
