<div class="card mb-4">
    <div class="card-header">PSSR Written Scheme<a href="javascript:void(0)" class="btn btn-secondary btn-sm float-end" onClick="addWS()" data-mdb-tooltip-init data-mdb-placement="left" title="New Written Scheme"><i
               class="fad fa-plus"></i></a><span id="wsSearch"><a href="javascript:void(0)" class="btn btn-secondary btn-sm float-end me-2" data-mdb-tooltip-init data-mdb-placement="left" title="Search WS Library" onClick="searchWs()"><i
                   class="fad fa-search"></i></a></span></div>
    <div class="card-body p-0">
        <div id="wsData" style="max-height:200px; overflow-x:hidden"></div>
    </div>
</div>
<script>
// Function to create the search input field with a button
function searchWs() {
    hideTooltips()
    // Get the wsSearch element
    const wsSearch = document.getElementById('wsSearch');

    // Create a div for the input group
    const inputGroup = document.createElement('div');
    inputGroup.className = 'input-group mb-3 mt-3';

    // Create the input field
    const input = document.createElement('input');
    input.id = 'searchString';
    input.type = 'text';
    input.className = 'form-control form-control-sm';
    input.placeholder = 'Search';
    input.setAttribute('aria-label', 'Search');
    input.setAttribute('aria-describedby', 'button-addon2');
    input.addEventListener('keyup', filterWs); // Bind filterWs function on keyup

    // Create the button
    const button = document.createElement('button');
    button.className = 'btn btn-sm btn-danger m-0 px-2 py-1 z-depth-0 waves-effect';
    button.type = 'button';
    button.id = 'button-addon2';
    button.addEventListener('click', closeFilter);

    // Create the button icon
    const icon = document.createElement('i');
    icon.className = 'fas fa-times fa-2x';

    // Append the icon to the button
    button.appendChild(icon);

    // Append the input and button to the input group
    inputGroup.appendChild(input);
    inputGroup.appendChild(button);

    // Clear the current content and append the input group to wsSearch
    wsSearch.innerHTML = '';
    wsSearch.appendChild(inputGroup);
}

// Function to close the filter and show the search button
function closeFilter() {
    // Get the wsSearch element
    const wsSearch = document.getElementById('wsSearch');

    // Create an anchor element for the search button
    const anchor = document.createElement('a');
    anchor.href = 'javascript:void(0)';
    anchor.className = 'btn btn-secondary btn-sm float-end me-2';
    anchor.addEventListener('click', searchWs);

    // Create the search icon
    const icon = document.createElement('i');
    icon.className = 'fad fa-search';

    // Append the icon to the anchor
    anchor.appendChild(icon);

    // Clear the current content and append the anchor to wsSearch
    wsSearch.innerHTML = '';
    wsSearch.appendChild(anchor);
}

function filterWs() {
    // Get the search string from the input field
    var str = document.getElementById('searchString').value.toLowerCase();

    // Get all elements with the class 'wsEntry'
    var wsEntries = document.querySelectorAll('.wsEntry');

    // Loop through each wsEntry
    wsEntries.forEach(function(entry) {
        // Hide the entry by default
        entry.style.display = 'none';

        // Find the text within the <p> tags inside the entry
        var text = entry.querySelector('p').textContent.toLowerCase();

        // Check if the text includes the search string
        if (text.includes(str)) {
            // Show the entry if it includes the search string
            entry.style.display = 'block';
        }
    });
}
</script>