<?php
// Function to safely get values from the array
function safeValue($array, $key, $default = '', $formatDate = false) {
    // Check if key exists and is not null
    $value = $array[$key] ?? $default;

    // Check if the value needs date formatting
    if ($formatDate && is_numeric($value)) {
        $value = date('d-m-Y', $value); // Convert timestamp to a formatted date
    }

    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

// Check if we are in 'new' mode
$isNewMode = $_REQUEST['view'] === 'new';

// Initialize the $cd array with default values if in new mode
$cd = $isNewMode ? [
    'clientname' => '',
    'address1' => '',
    'address2' => '',
    'town' => '',
    'county' => '',
    'postcode' => '',
    'phone1' => '',
    'phone2' => '',
    'mobile' => '',
    'fax' => '',
    'email' => '',
    'contract_number' => genContractNo(),
    'delivery_pref' => '1',
    'delivery_type' => 'zip',
    'statuslive' => '1',
    'contractMode' => '0',
    'rate_per_hour' => '',
    'incepton_date' => date('d-m-Y'),
    'term_years' => '1',
    'renewal_date' => date('d-m-Y', strtotime('+ 1 year')),
    'renewal_status' => 'ACTIVE',
    'autoRenew' => '0',
    'clientnotes' => '',
    'billing_name' => '',
    'billing1' => '',
    'billing2' => '',
    'billing_town' => '',
    'billing_county' => '',
    'billing_postcode' => '',
    'billing_phone' => '',
    'billing_email' => '',
    'pri_contact_name' => '',
    'pri_contact_position' => '',
    'pri_contact_tel' => '',
    'pri_contact_mob' => '',
    'pri_contact_email' => '',
    'sec_contact_name' => '',
    'sec_contact_position' => '',
    'sec_contact_tel' => '',
    'sec_contact_mob' => '',
    'sec_contact_email' => '',
    'agent_number' => '0',
    'broker_number' => '0',
    'account_handler' => '',
    'commission' => '0',
    'comType' => '0'
] : $cd;
$rdata = $isNewMode ? [
    'renewalSet' => '',
    'schedule' => 0,
    'plant' => 0,
    'inspection' => 0,
    'nag' => 0,
    'R1' => '',
    'R2' => '',
    'lapse' => 0,
    'lapseDays' => '',
    'notice' => 0,
    'inotice' => 0,
] : json_decode($cd['renewOptions'], true);
?>

<div id="detailsBox" class="card mb-4">
    <div class="card-header bg-primary text-white">Client Details</div>
    <div class="card-body">
        <div class="row">
            <!-- Left Column -->
            <div class="col-md-6">
                <!-- Client Name -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="clientname">Client Name</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="clientname" name="clientname" value="<?= safeValue($cd, 'clientname') ?>" required>
                    </div>
                </div>

                <!-- Address 1 -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="address1">Address 1</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="address1" name="address1" value="<?= safeValue($cd, 'address1') ?>" required>
                    </div>
                </div>

                <!-- Address 2 -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="address2">Address 2</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="address2" name="address2" value="<?= safeValue($cd, 'address2') ?>">
                    </div>
                </div>

                <!-- Town -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="town">Town</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="town" name="town" value="<?= safeValue($cd, 'town') ?>" required>
                    </div>
                </div>

                <!-- County -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="county">County</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="county" name="county" value="<?= safeValue($cd, 'county') ?>">
                    </div>
                </div>

                <!-- Postcode -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="postcode">Postcode</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="postcode" name="postcode" value="<?= safeValue($cd, 'postcode') ?>" required>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="d-flex justify-content-center mt-4 mb-2">
                    <button type="button" class="btn btn-info me-4" onclick="setBilling()">
                        <i class="fad fa-copy"></i> Copy To Billing & Primary Contact
                    </button>
                    <button type="button" class="btn btn-secondary" onclick="printContent('label','<?= safeValue($cd, 'clientname') ?>')">
                        <i class="fad fa-print"></i> Print Label
                    </button>
                </div>

                <!-- Hidden Label -->
                <div id="label" class="d-none">
                    <div id="envelopeLabel">
                        <table class="table envelope-table">
                            <tbody>
                                <tr><td><?= safeValue($cd, 'clientname') ?></td></tr>
                                <tr><td><?= safeValue($cd, 'address1') ?></td></tr>
                                <tr><td><?= safeValue($cd, 'address2') ?></td></tr>
                                <tr><td><?= safeValue($cd, 'town') ?></td></tr>
                                <tr><td><?= safeValue($cd, 'county') ?></td></tr>
                                <tr><td><?= safeValue($cd, 'postcode') ?></td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-md-6">
                <!-- Phone 1 -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="phone1">Phone 1</label>
                    <div class="col-md-9">
                        <input type="tel" class="form-control" id="phone1" name="phone1" value="<?= safeValue($cd, 'phone1') ?>">
                    </div>
                </div>

                <!-- Phone 2 -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="phone2">Phone 2</label>
                    <div class="col-md-9">
                        <input type="tel" class="form-control" id="phone2" name="phone2" value="<?= safeValue($cd, 'phone2') ?>">
                    </div>
                </div>

                <!-- Mobile -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="mobile">Mobile</label>
                    <div class="col-md-9">
                        <input type="tel" class="form-control" id="mobile" name="mobile" value="<?= safeValue($cd, 'mobile') ?>">
                    </div>
                </div>

                <!-- Fax -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="fax">Fax</label>
                    <div class="col-md-9">
                        <input type="tel" class="form-control" id="fax" name="fax" value="<?= safeValue($cd, 'fax') ?>">
                    </div>
                </div>

                <!-- Email -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="email">Email</label>
                    <div class="col-md-9">
                        <input type="email" class="form-control" id="email" name="email" value="<?= safeValue($cd, 'email') ?>">
                    </div>
                </div>

                <!-- Contract Number -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="contract_number">Contract Number</label>
                    <div class="col-md-9">
                        <input type="text" class="form-control" id="contract_number" name="contract_number" value="<?= safeValue($cd, 'contract_number') ?>">
                    </div>
                </div>

                <!-- Delivery Preference -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label">Delivery Preference</label>
                    <div class="col-md-4 form-check">
                        <input type="radio" class="form-check-input" id="delivery_email" name="delivery_pref" value="1" <?= (safeValue($cd, 'delivery_pref', '1') == '1') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="delivery_email">Email</label>
                    </div>
                    <div class="col-md-4 form-check">
                        <input type="radio" class="form-check-input" id="delivery_post" name="delivery_pref" value="2" <?= (safeValue($cd, 'delivery_pref') == '2') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="delivery_post">Post</label>
                    </div>
                </div>

                <!-- Delivery Type -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label">Delivery Type</label>
                    <div class="col-md-4 form-check">
                        <input type="radio" class="form-check-input" id="delivery_zip" name="delivery_type" value="zip" <?= (safeValue($cd, 'delivery_type', 'zip') == 'zip') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="delivery_zip">ZIP</label>
                    </div>
                    <div class="col-md-4 form-check">
                        <input type="radio" class="form-check-input" id="delivery_pdf" name="delivery_type" value="pdf" <?= (safeValue($cd, 'delivery_type') == 'pdf') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="delivery_pdf">PDF</label>
                    </div>
                </div>

                <!-- Live Client Checkbox -->
                <div class="mb-3 row">
                    <label class="col-md-3 col-form-label" for="statuslive">Live Client</label>
                    <div class="col-md-9 form-check">
                        <input type="checkbox" class="form-check-input" id="statuslive" name="statuslive" <?= (safeValue($cd, 'statuslive', '1') == '1') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="statuslive"></label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
