<?php
if (file_exists('../../../' . $_REQUEST['tenant'] . '/config.php')) {
require_once('../../../' . $_REQUEST['tenant'] . '/config.php'); ;
}
if (file_exists('/config.php')) {
require_once('/config.php');
}


header('Content-Type: application/json');

$board_id = $_GET['board_id'] ?? null;

if (!$board_id) {
echo json_encode(['success' => false, 'message' => 'Board ID is missing']);
exit;
}

$query = "SELECT COUNT(*) AS total FROM circuits WHERE board_id = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $board_id);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

$nextCircuitNumber = intval($result['total']) + 1;
$circuitNo = floor(($nextCircuitNumber - 1) / 3) + 1 . 'L' . (($nextCircuitNumber - 1) % 3) + 1;

echo json_encode(['success' => true, 'next_circuit_no' => $circuitNo]);
exit;