<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (file_exists('../../../' . $_POST['tenant'] . '/config.php')) {
    require_once('../../../' . $_POST['tenant'] . '/config.php');
} elseif (file_exists('/config.php')) {
    require_once('/config.php');
} else {
    die(json_encode(['success' => false, 'message' => 'Configuration file not found.']));
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// Validate required parameters
if (!isset($_POST['board_id'], $_POST['circuit_no'], $_POST['circuit_description'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters.']);
    exit;
}

// Log incoming data for debugging
file_put_contents('debug.log', print_r($_POST, true), FILE_APPEND);

// Input arrays
$board_id = intval($_POST['board_id']);
$circuit_nos = $_POST['circuit_no'];
$circuit_descriptions = $_POST['circuit_description'];
$cable_types = $_POST['cable_type'] ?? [];
$reference_methods = $_POST['reference_method'] ?? [];
$number_size_lives = $_POST['number_size_live'] ?? [];
$number_size_cpcs = $_POST['number_size_cpc'] ?? [];
$bsens = $_POST['bsen'] ?? [];
$bs_types = $_POST['bs_type'] ?? [];
$ratings = $_POST['rating'] ?? [];
$breaking_capacities = $_POST['breaking_capacity'] ?? [];
$rcd_tripping_currents = $_POST['rcd_tripping_current'] ?? [];
$rcd_types = $_POST['rcd_type'] ?? [];
$max_allowed_zs = $_POST['max_allowed_zs'] ?? [];

// Validate array lengths
$array_lengths = [
    count($circuit_nos),
    count($circuit_descriptions),
    count($cable_types),
    count($reference_methods),
    count($number_size_lives),
    count($number_size_cpcs),
    count($bsens),
    count($bs_types),
    count($ratings),
    count($breaking_capacities),
    count($rcd_tripping_currents),
    count($rcd_types),
    count($max_allowed_zs),
];

if (count(array_unique($array_lengths)) !== 1) {
    echo json_encode(['success' => false, 'message' => 'Input arrays are inconsistent in length.']);
    exit;
}

// Prepare SQL statement
$query = "
    UPDATE elec_circuit 
    SET 
        circuit_description = ?, 
        cable_type = ?, 
        reference_method = ?, 
        number_size_live = ?, 
        number_size_cpc = ?,
        bsen = ?, 
        bs_type = ?, 
        rating = ?, 
        breaking_capacity = ?, 
        rcd_tripping_current = ?, 
        rcd_type = ?, 
        max_allowed_zs = ?
    WHERE 
        board_id = ? AND circuit_no = ?";

$stmt = $con->prepare($query);
if (!$stmt) {
    echo json_encode(['success' => false, 'message' => 'Failed to prepare SQL statement: ' . $con->error]);
    exit;
}

// Track errors and successful updates
$errors = [];
$successful_updates = 0;

for ($i = 0; $i < count($circuit_nos); $i++) {
    // Sanitize and validate each field
    $circuit_no = $circuit_nos[$i] ?? null;
    $circuit_description = $circuit_descriptions[$i] ?? null;
    $cable_type = $cable_types[$i] === '-' ? null : ($cable_types[$i] ?? null);
    $reference_method = $reference_methods[$i] === '-' ? null : ($reference_methods[$i] ?? null);
    $number_size_live = $number_size_lives[$i] === '-' ? null : ($number_size_lives[$i] ?? null);
    $number_size_cpc = $number_size_cpcs[$i] === '-' ? null : ($number_size_cpcs[$i] ?? null);
    $bsen = $bsens[$i] === '-' ? null : ($bsens[$i] ?? null);
    $bs_type = $bs_types[$i] === '-' ? null : ($bs_types[$i] ?? null);
    $rating = $ratings[$i] === '-' ? null : intval($ratings[$i] ?? null);
    $breaking_capacity = $breaking_capacities[$i] === '-' ? null : ($breaking_capacities[$i] ?? null);
    $rcd_tripping_current = $rcd_tripping_currents[$i] === '-' ? null : intval($rcd_tripping_currents[$i] ?? null);
    $rcd_type = $rcd_types[$i] === '-' ? null : ($rcd_types[$i] ?? null);
    $max_allowed_zs_value = $max_allowed_zs[$i] === '-' ? null : ($max_allowed_zs[$i] ?? null);

    // Bind parameters
    $stmt->bind_param(
        'sssssssddsssis',
        $circuit_description,
        $cable_type,
        $reference_method,
        $number_size_live,
        $number_size_cpc,
        $bsen,
        $bs_type,
        $rating,
        $breaking_capacity,
        $rcd_tripping_current,
        $rcd_type,
        $max_allowed_zs_value,
        $board_id,
        $circuit_no
    );

    // Execute and handle errors
    if (!$stmt->execute()) {
        $errors[] = "Error updating circuit {$circuit_no}: " . $stmt->error;
    } else {
        // Count successful updates
        $successful_updates++;
    }
}

// Close statement
$stmt->close();

// Response
if ($successful_updates > 0 && empty($errors)) {
    echo json_encode(['success' => true, 'message' => 'All circuits updated successfully.']);
} elseif ($successful_updates > 0 && !empty($errors)) {
    echo json_encode(['success' => true, 'message' => 'Some circuits updated successfully.', 'errors' => $errors]);
} else {
    echo json_encode(['success' => false, 'message' => 'No circuits updated.', 'errors' => $errors]);
}
?>