<?php
// elec_list_functions.php - Functions for elec_list.php operations

// Function to fetch all distribution boards for a specified client
function get_all_distros($clientnumber) {
    global $con; // Database connection

    $query = "SELECT * FROM elec_board WHERE clientnumber = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("i", $clientnumber);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $distros = [];
    while ($row = $result->fetch_assoc()) {
        $distros[] = $row;
    }
    $stmt->close();
    
    return $distros;
}

// Additional functions for adding, editing, and deleting distros can go here
?>