<?php
if (file_exists('../../../' . $_POST['tenant'] . '/config.php')) {
    require_once('../../../' . $_POST['tenant'] . '/config.php');
} elseif (file_exists('/config.php')) {
    require_once('/config.php');
} else {
    die(json_encode(['success' => false, 'message' => 'Configuration file not found.']));
}

$board_id = isset($_POST['board_id']) ? intval($_POST['board_id']) : 0;

if (!$board_id) {
    die(json_encode(['success' => false, 'message' => 'Board ID is missing.']));
}

try {
    $query = "
        SELECT 
            SUBSTRING_INDEX(circuit_no, 'L', 1) AS circuit_number,
            MAX(CASE WHEN circuit_no LIKE '%L1' THEN circuit_description ELSE '-' END) AS L1,
            MAX(CASE WHEN circuit_no LIKE '%L2' THEN circuit_description ELSE '-' END) AS L2,
            MAX(CASE WHEN circuit_no LIKE '%L3' THEN circuit_description ELSE '-' END) AS L3,
            MAX(circuit_id) AS circuit_id -- Use the max ID for reference
        FROM elec_circuit
        WHERE board_id = ?
        GROUP BY circuit_number
        ORDER BY circuit_number ASC
    ";

    $stmt = $con->prepare($query);
    $stmt->bind_param('i', $board_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $circuits = [];
    while ($row = $result->fetch_assoc()) {
        $circuits[] = [
            'circuit_number' => $row['circuit_number'],
            'circuit_description' => "<table width=\"100%\"><tr><td width=\"33%\"><span class=\"badge \" style=\"background-color:brown\">L1:</span> {$row['L1']}</td><td width=\"33%\"><span class=\"badge \" style=\"background-color:black\">L2:</span> {$row['L2']}</td><td width=\"33%\"><span class=\"badge \" style=\"background-color:grey\">L3:</span> {$row['L3']}</td></tr></table>",
            'circuit_id' => $row['circuit_id']
        ];
    }

    echo json_encode(['success' => true, 'circuits' => $circuits]);
} catch (Exception $e) {
    error_log("Error fetching circuits: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An error occurred while fetching circuits.']);
}
?>