<?php

$d = explode("|", $_REQUEST['data']);

if (!isset($d[0])) {
    die("Error: Board ID is missing.");
}

$board_id = intval($d[0]);
$clientnumber = intval($d[1]);
$locnumber = intval($d[2]);

// Fetch board details
function get_board_details($board_id) {
    global $con;
    $query = "
       SELECT 
            b.board_name, 
            CONCAT(l.locname, ' [ ', l.postcode, ' ]') AS location_name,
            (
                SELECT COUNT(DISTINCT LEFT(circuit_no, LENGTH(circuit_no) - 2)) 
                FROM elec_circuit 
                WHERE board_id = ?
            ) AS existing_circuits 
        FROM elec_board b
        LEFT JOIN locations l ON b.locnumber = l.locnumber
        WHERE b.board_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("ii", $board_id, $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    return $row ?: ['board_name' => 'Unknown', 'location_name' => 'Unknown', 'existing_circuits' => 0];
}

$board_details = get_board_details($board_id);

// Function to get the next circuit number
function get_next_circuit_no($board_id) {
    global $con;
    $query = "SELECT MAX(SUBSTRING_INDEX(circuit_no, 'L', 1)) AS max_circuit FROM elec_circuit WHERE board_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("i", $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();

    return isset($row['max_circuit']) ? intval($row['max_circuit']) + 1 : 1;
}

$next_circuit_no = get_next_circuit_no($board_id);
$spurs = ['L1', 'L2', 'L3'];

?>
<style>
.is-invalid {
    border: 1px solid red;
    background-color: #ffeeee;
}
</style>

<div class="note note-secondary mb-3">
    <strong>Define a new circuit:</strong> When defining a new circuit, the only required field is the "Circuit Description", all others can be left blank. Use the <span>&#9660;</span> on the right to expand the boxes.
</div>
<div class="container-fluid mt-3">
    <div class="row">
        <!-- Form Column -->
        <div class="col-md-9 order-2 order-md-1">
            <form id="newCircuitForm">
                <input type="hidden" name="tenant" value="<?= TENANT_URL ?>">
                <input type="hidden" name="board_id" value="<?= $board_id ?>">
                <input type="hidden" name="clientnumber" value="<?= $clientnumber ?>">
                <input type="hidden" name="locnumber" value="<?= $locnumber ?>">

                <?php foreach ($spurs as $key => $spur): ?>
                <!-- Spur Card -->
                <div class="card mb-3">
                    <div class="card-header d-flex justify-content-between align-items-center p-0 ps-2">
                        <strong>Circuit <?= $next_circuit_no . $spur ?></strong>
                        <button type="button" class="btn btn-link p-0 text-light" onclick="toggleCard('spur<?= $key ?>')">
                            <span>&#9660;</span> <!-- Down arrow -->
                        </button>
                    </div>
                    <div class="card-body <?= ($spur != 'L1') ? 'd-none' : '' ?>" id="spur<?= $key ?>">
                        <input type="hidden" name="circuit_no[]" value="<?= $next_circuit_no . $spur ?>">

                        <!-- Circuit Description -->
                        <div class="mb-3">
                            <label for="circuit_description_<?= $spur ?>" class="form-label">Circuit Description</label>
                            <input type="text" class="form-control" id="circuit_description_<?= $spur ?>" name="circuit_description[]" placeholder="Required" required>
                        </div>

                        <!-- Conductor Details -->
                        <h6 class="text-primary">Conductor Details</h6>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="cable_type_<?= $spur ?>" class="form-label">Cable Type</label>
                                <input type="text" class="form-control" id="cable_type_<?= $spur ?>" name="cable_type[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="reference_method_<?= $spur ?>" class="form-label">Reference Method</label>
                                <input type="text" class="form-control" id="reference_method_<?= $spur ?>" name="reference_method[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="number_size_live_<?= $spur ?>" class="form-label">Live (mm²)</label>
                                <input type="text" class="form-control" id="number_size_live_<?= $spur ?>" name="number_size_live[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="number_size_cpc_<?= $spur ?>" class="form-label">CPC (mm²)</label>
                                <input type="text" class="form-control" id="number_size_cpc_<?= $spur ?>" name="number_size_cpc[]" placeholder="-">
                            </div>
                        </div>

                        <!-- Overcurrent / RCD Details -->
                        <h6 class="text-primary">Overcurrent / RCD Device Details</h6>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="bs_type_<?= $spur ?>" class="form-label">BS(EN) Type</label>
                                <input type="text" class="form-control" id="bs_type_<?= $spur ?>" name="bs_type[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="rating_<?= $spur ?>" class="form-label">Rating (A)</label>
                                <input type="number" class="form-control" id="rating_<?= $spur ?>" name="rating[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="breaking_capacity_<?= $spur ?>" class="form-label">Breaking Capacity (kA)</label>
                                <input type="number" step="0.01" class="form-control" id="breaking_capacity_<?= $spur ?>" name="breaking_capacity[]" placeholder="-">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="rcd_tripping_current_<?= $spur ?>" class="form-label">RCD Tripping Current (mA)</label>
                                <input type="number" class="form-control" id="rcd_tripping_current_<?= $spur ?>" name="rcd_tripping_current[]" placeholder="-">
                            </div>
                            <!-- Add RCD Type -->
                            <div class="col-md-3 mb-3">
                                <label for="rcd_type_<?= $spur ?>" class="form-label">RCD Type</label>
                                <input type="text" class="form-control" id="rcd_type_<?= $spur ?>" name="rcd_type[]" placeholder="-">
                            </div>

                            <!-- Add Max Allowed ZS -->
                            <div class="col-md-3 mb-3">
                                <label for="max_allowed_zs_<?= $spur ?>" class="form-label">Max Allowed ZS (Ω)</label>
                                <input type="number" step="0.01" class="form-control" id="max_allowed_zs_<?= $spur ?>" name="max_allowed_zs[]" placeholder="-">
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>

                <!-- Submit -->
                <button id="btn_create" type="button" class="btn btn-info mt-4 hidden" onclick="submitCircuitForm()">Save Circuit</button>
            </form>
        </div>

        <!-- Vital Statistics Column -->
        <div class="col-md-3 order-1 order-md-2 mb-4">

            <div class="card">
                <div class="card-header">
                    Board Information
                </div>
                <div class="card-body">
                    <p><strong>Board Name:</strong> <?= htmlspecialchars($board_details['board_name']) ?></p>
                    <p><strong>Location:</strong> <?= htmlspecialchars($board_details['location_name']) ?></p>
                    <p><strong>Existing Circuits:</strong> <?= $board_details['existing_circuits'] ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle Card Collapse
function toggleCard(id) {
    const cardBody = document.getElementById(id);
    cardBody.classList.toggle('d-none');
}

// Submit Circuit Form
function submitCircuitForm() {
    const form = document.getElementById('newCircuitForm');
    const descriptions = document.querySelectorAll('[name="circuit_description[]"]');
    let isValid = true;

    // Check if all circuit descriptions are filled
    descriptions.forEach((input) => {
        if (!input.value.trim()) {
            input.classList.add('is-invalid'); // Highlight invalid fields
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });

    if (!isValid) {
        showResponse("warning", "Please fill out all required Circuit Descriptions.");
        return; // Stop the submission
    }

    // Proceed with form submission
    const formData = new FormData(form);

    fetch(ROOT_URL + '/includes/elec/elec_add_circuit.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showResponse('success', 'Circuit added successfully!');
                window.location.href = 'index.php?t=includes/master&p=elec.php&view=elec_list_circuit&data=<?=$_REQUEST['data']?>';
            } else {
                showResponse('danger', data.message);
            }
        })
        .catch(error => {
            console.error('Fetch Error:', error);
            showResponse('danger', 'An unexpected error occurred. Please try again.');
        });
}


document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=client.php&view=list">Clients</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&clientnumber=<?= $d['1']?>&view=elec_client"><?= $cd['clientname']?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&view=elec_list_circuit&data=<?=$_REQUEST['data']?>">Board: <?= htmlspecialchars($board_details['board_name']) ?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item active">New Circuit</li>'

    document.getElementById('footerControls').innerHTML = '<button class="btn btn-secondary" onclick="triggerAction(\'btn_create\')">Create Circuit</button>';

});
</script>