<?php

if (!isset($d['0'])) {
    die("Error: Board ID is missing.");
}
$board_id = intval($d[0]); 

function get_board_details($board_id) {
    global $con;
    $query = "
       SELECT 
            b.board_name, 
            CONCAT(l.locname, ' [ ', l.postcode, ' ]') AS location_name,
            (
                SELECT COUNT(DISTINCT LEFT(circuit_no, LENGTH(circuit_no) - 2)) 
                FROM elec_circuit 
                WHERE board_id = ?
            ) AS existing_circuits 
        FROM elec_board b
        LEFT JOIN locations l ON b.locnumber = l.locnumber
        WHERE b.board_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("ii", $board_id, $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    return $row ?: ['board_name' => 'Unknown', 'location_name' => 'Unknown', 'existing_circuits' => 0];
}

$board_details = get_board_details($board_id);
?>
<div class="row">
    <div class="col-12">
        <button class="btn btn-secondary btn-sm float-end" onclick="newCircuit()">
            <i class="fad fa-plus"></i> New Circuit
        </button>
    </div>
</div>
<div class="container-fluid mt-3">
    <h5>Circuits for Board: <?= $board_details['board_name'] ?></h5>
    <table id="circuitsTable" class="table table-striped table-bordered table-sm" style="width:100%">
        <thead>
            <tr>
                <th width="10%">Circuit No</th>
                <th>Circuit Descriptions</th>
                <th width="25%">Actions</th>
            </tr>
        </thead>
    </table>

    <!-- Circuit Relationship Visualization -->
    <h5 class="mt-5 text-center">Circuit Relationship</h5>
    <div id="circuitVisualizationContainer" class="d-flex justify-content-center">
        <div id="circuitVisualization"></div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const table = $('#circuitsTable').DataTable({
        ajax: {
            url: `${ROOT_URL}/includes/elec/fetch_board_circuits.php`,
            type: 'POST',
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            processData: true,
            data: {
                board_id: '<?= $board_id ?>',
                tenant: TENANT_URL
            },
            dataSrc: function(json) {
                if (json.success) {
                    // Call visualization creation after data is loaded
                    createSVGVisualization(json.circuits, 'Board');
                    return json.circuits;
                } else {
                    console.error(json.message);
                    showResponse('danger', 'Failed to load circuits.');
                    return [];
                }
            }
        },
        columns: [{
                data: 'circuit_number',
                title: 'Circuit No'
            },
            {
                data: 'circuit_description',
                title: 'Circuit Description'
            },
            {
                data: 'circuit_id',
                title: 'Actions',
                render: function(data, type, row) {
                    return `
                        <button class="btn btn-sm btn-danger float-end" onclick="confirmRemove(${data})"><i class="fad fa-trash"></i> Delete</button>
                        <button class="btn btn-sm btn-secondary float-end me-4" onclick="editCircuit(${data})"><i class="fad fa-pencil"></i> Edit</button>
                    `;
                }
            }
        ],
        responsive: true,
        order: [
            [0, 'asc']
        ]
    });
});

// Edit Circuit
function editCircuit(circuitId) {
    window.location.href = `index.php?t=includes/master&p=elec.php&view=elec_edit_circuit&circuit_id=${circuitId}&data=<?=$_REQUEST['data']?>`;
}

// Add New Circuit
function newCircuit() {
    window.location.href = `index.php?t=includes/master&p=elec.php&view=elec_new_circuit&data=<?=$_REQUEST['data']?>`;
}

// Confirm Remove Circuit
function confirmRemove(circuitId) {
    const dest = '<p>Are you sure you wish to remove this circuit?</p>';
    loadModalContent(dest, "popupBox", "modal-md", 1060, "true", "Remove Circuit", "cancelConfirm", () => deleteCircuit(circuitId));
}

// Delete Circuit
function deleteCircuit(circuitId) {
    fetch(ROOT_URL + '/includes/elec/elec_delete_circuit.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `circuit_id=${circuitId}&tenant=${TENANT_URL}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showResponse('success', 'Circuit deleted successfully.');
                $('#circuitsTable').DataTable().ajax.reload();
                killModal('popupBox');
            } else {
                showResponse('danger', data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showResponse('danger', 'An unexpected error occurred.');
        });
}

// Create SVG Visualization
function createSVGVisualization(circuits, boardName) {
    const svgContainer = document.getElementById('circuitVisualization');
    svgContainer.innerHTML = ''; // Clear existing SVG content

    const width = 800;
    const height = 400;
    const svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg.setAttribute('width', width);
    svg.setAttribute('height', height);

    const centerX = width / 2;
    const boardY = 50;

    // Add Board Node
    const boardNode = createSVGNode(centerX, boardY, 'green', boardName, 'Board');
    svg.appendChild(boardNode);

    const circuitSpacing = 200; // Space between circuits
    const spurSpacing = 50; // Space between spurs
    const circuitY = boardY + 100;
    const spurY = circuitY + 80;
    const startX = centerX - (circuitSpacing * (circuits.length - 1)) / 2;

    circuits.forEach((circuit, circuitIndex) => {
        const circuitX = startX + circuitIndex * circuitSpacing;

        // Add Circuit Node
        const circuitNode = createSVGNode(circuitX, circuitY, 'blue', circuit.circuit_number, 'Circuit');
        svg.appendChild(circuitNode);

        // Add Line from Board to Circuit
        const line = createSVGLine(centerX, boardY + 20, circuitX, circuitY - 20);
        svg.appendChild(line);

        ['L1', 'L2', 'L3'].forEach((spur, spurIndex) => {
            const spurX = circuitX - spurSpacing + spurIndex * spurSpacing;

            // Add Spur Node
            const spurNode = createSVGNode(spurX, spurY, ['brown', 'black', 'gray'][spurIndex], spur, circuit[spur]);
            svg.appendChild(spurNode);

            // Add Line from Circuit to Spur
            const spurLine = createSVGLine(circuitX, circuitY + 20, spurX, spurY - 20);
            svg.appendChild(spurLine);
        });
    });

    svgContainer.appendChild(svg);
}

function createSVGNode(x, y, color, label, title) {
    const group = document.createElementNS('http://www.w3.org/2000/svg', 'g');

    const circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
    circle.setAttribute('cx', x);
    circle.setAttribute('cy', y);
    circle.setAttribute('r', 20);
    circle.setAttribute('fill', color);
    group.appendChild(circle);

    const text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    text.setAttribute('x', x);
    text.setAttribute('y', y + 5);
    text.setAttribute('text-anchor', 'middle');
    text.setAttribute('font-size', '12');
    text.setAttribute('fill', '#fff');
    text.textContent = label;
    group.appendChild(text);

    if (title) {
        const titleElement = document.createElementNS('http://www.w3.org/2000/svg', 'title');
        titleElement.textContent = title;
        group.appendChild(titleElement);
    }

    return group;
}

function createSVGLine(x1, y1, x2, y2) {
    const line = document.createElementNS('http://www.w3.org/2000/svg', 'line');
    line.setAttribute('x1', x1);
    line.setAttribute('y1', y1);
    line.setAttribute('x2', x2);
    line.setAttribute('y2', y2);
    line.setAttribute('stroke', '#ccc');
    line.setAttribute('stroke-width', 2);
    return line;
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=client.php&view=list">Clients</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=elec.php&clientnumber=<?= $d['1']?>&view=elec_client"><?= $cd['clientname']?></a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li>' +
        '<li class="breadcrumb-item active">Board: <?= htmlspecialchars($board_details['board_name']) ?></li>'


});
</script>