<?php
if (file_exists('../../../' . $_POST['tenant'] . '/config.php')) {
    require_once('../../../' . $_POST['tenant'] . '/config.php');
} elseif (file_exists('/config.php')) {
    require_once('/config.php');
} else {
    die(json_encode(['success' => false, 'message' => 'Configuration file not found.']));
}

// Ensure the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die(json_encode(['success' => false, 'message' => 'Invalid request method.']));
}

// Sanitize and validate input
$requiredFields = ['tenant', 'board_id', 'clientnumber', 'locnumber', 'circuit_no', 'circuit_description'];

foreach ($requiredFields as $field) {
    if (!isset($_POST[$field]) || empty($_POST[$field])) {
        die(json_encode(['success' => false, 'message' => "Missing required field: $field"]));
    }
}

// Validate that circuit data comes as arrays
if (
    !is_array($_POST['circuit_no']) ||
    !is_array($_POST['circuit_description']) ||
    !is_array($_POST['cable_type']) ||
    !is_array($_POST['reference_method']) ||
    !is_array($_POST['number_size_live']) ||
    !is_array($_POST['number_size_cpc']) ||
    !is_array($_POST['bs_type']) ||
    !is_array($_POST['rating']) ||
    !is_array($_POST['breaking_capacity']) ||
    !is_array($_POST['rcd_tripping_current']) ||
    !is_array($_POST['rcd_type']) ||
    !is_array($_POST['max_allowed_zs'])
) {
    die(json_encode(['success' => false, 'message' => 'Invalid input format for circuit data.']));
}

// Map core POST data
$tenant = $_POST['tenant'];
$board_id = intval($_POST['board_id']);
$clientnumber = intval($_POST['clientnumber']);
$locnumber = intval($_POST['locnumber']);

// Prepare the SQL query for inserting circuits
$query = "INSERT INTO elec_circuit (
    board_id, clientnumber, locnumber, circuit_no, circuit_description,
    cable_type, reference_method, number_size_live, number_size_cpc,
    bs_type, rating, breaking_capacity, rcd_tripping_current,
    rcd_type, max_allowed_zs
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $con->prepare($query);
if (!$stmt) {
    die(json_encode(['success' => false, 'message' => 'Database prepare error: ' . $con->error]));
}

// Loop through each set of circuit data and bind/execute the query
$circuitCount = count($_POST['circuit_no']);
$errors = [];
for ($i = 0; $i < $circuitCount; $i++) {
    // Set values for each spur iteration
    $circuit_no = $_POST['circuit_no'][$i];
    $circuit_description = $_POST['circuit_description'][$i];
    $cable_type = $_POST['cable_type'][$i] ?? '-';
    $reference_method = $_POST['reference_method'][$i] ?? '-';
    $number_size_live = floatval($_POST['number_size_live'][$i] ?? 0);
    $number_size_cpc = floatval($_POST['number_size_cpc'][$i] ?? 0);
    $bs_type = $_POST['bs_type'][$i] ?? '-';
    $rating = intval($_POST['rating'][$i] ?? 0);
    $breaking_capacity = floatval($_POST['breaking_capacity'][$i] ?? 0);
    $rcd_tripping_current = intval($_POST['rcd_tripping_current'][$i] ?? 0);
    $rcd_type = $_POST['rcd_type'][$i] ?? '-';
    $max_allowed_zs = floatval($_POST['max_allowed_zs'][$i] ?? 0);

    // Bind the values
    $stmt->bind_param(
        "iiissssdssidsds",
        $board_id, $clientnumber, $locnumber, $circuit_no, $circuit_description,
        $cable_type, $reference_method, $number_size_live, $number_size_cpc,
        $bs_type, $rating, $breaking_capacity, $rcd_tripping_current,
        $rcd_type, $max_allowed_zs
    );

    // Execute and track errors
    if (!$stmt->execute()) {
        $errors[] = "Circuit {$circuit_no} failed: " . $stmt->error;
    }
}

// Close statement
$stmt->close();

// Return response
if (empty($errors)) {
    echo json_encode(['success' => true, 'message' => 'Circuits added successfully.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Some circuits failed to add.', 'errors' => $errors]);
}
?>