<?php
if(file_exists('../../../'.$_REQUEST['tenant'].'/config.php')){require_once('../../../'.$_REQUEST['tenant'].'/config.php');}
if(file_exists('/config.php')){require_once('/config.php'); }
?>
<div class="card" id="newBox">
    <div class="card-header">
        Register New Vehicle
        <a class="float-end btn btn-secondary btn-sm" href="javascript:void(0)" onClick="cancelNew()">
            <i class="fad fa-times"></i> cancel
        </a>

    </div>

    <div class="card-body">
        <form name="vehicleForm" id="vehicleForm" class="form-horizontal">
            <div class="row">
                <!-- Left Column -->
                <div class="col-md-6">
                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="reg">Registration Plate</label></div>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="reg" id="reg" style="text-transform:uppercase" />
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="desc">Description</label></div>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="desc" placeholder="E.g. Blue ford van" />
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="engine">Engine Size</label></div>
                        <div class="col-md-9">
                            <select name="engine" class="form-select" id="engine" data-mdb-placeholder="Select">
                                <option value="">Select</option>
                                <option value="petrol_u1400">Petrol/Hybrid 1400cc or less</option>
                                <option value="petrol_u2000">Petrol/Hybrid 1401cc to 2000cc</option>
                                <option value="petrol_02000">Petrol/Hybrid Over 2000cc</option>
                                <option value="diesel_u1600">Diesel Under 1600cc</option>
                                <option value="diesel_u2000">Diesel 1600cc to 2000cc</option>
                                <option value="diesel_o2000">Diesel Over 2000cc</option>
                                <option value="lpg_u1400">LPG 1400cc or less</option>
                                <option value="lpg_u2000">LPG 1401cc to 2000cc</option>
                                <option value="lpg_02000">LPG Over 2000cc</option>
                                <option value="electric">Fully Electric</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="miles">Initial Mileage</label></div>
                        <div class="col-md-9">
                            <input type="number" class="form-control" name="miles" id="miles" value="0" />
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="fuel">Fuel Type</label></div>
                        <div class="col-md-9">
                            <select name="fuel" class="form-select" id="fuel" data-mdb-placeholder="Select">
                                <option value="">Select</option>
                                <option value="Petrol/Hybrid">Petrol/Hybrid</option>
                                <option value="Diesel">Diesel</option>
                                <option value="LPG">LPG</option>
                                <option value="Electric">Electric</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="tDate">Tax Due Date</label></div>
                        <div class="col-md-9 datepicker" data-mdb-datepicker-init data-mdb-input-init data-mdb-confirmDateOnSelect>
                            <input type="text" data-mdb-toggle-button="false" data-mdb-toggle="datepicker" class="form-control" id="tdate" name="tdate" />
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="iDate">Insurance Due Date</label></div>
                        <div class="col-md-9 datepicker" data-mdb-datepicker-init data-mdb-input-init data-mdb-confirmDateOnSelect>
                            <input class="form-control" data-mdb-toggle="datepicker" type="text" name="idate" id="iDate" />
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <div class="col-md-3"><label for="mot">MOT Due Date</label></div>
                        <div class="col-md-9 datepicker" data-mdb-datepicker-init data-mdb-input-init data-mdb-confirmDateOnSelect>
                            <input class="form-control" data-mdb-toggle="datepicker" type="text" name="mot" id="mot" />
                        </div>
                    </div>


                </div>
            </div>
            <div class="col-md-12 text-center">
                <button type="submit" id="btnConfirm" class="btn btn-info">Register Vehicle</button>
            </div>

            <input type="hidden" name="FUNCTION" value="createVehicle">
            <input type="hidden" name="tenant" value="<?=TENANT_URL?>">
        </form>


    </div>
</div>

<script>
document.querySelectorAll('.datepicker').forEach((elem) => {
    new mdb.Datepicker(elem, {
        format: 'dd-mm-yyyy',
        disableFuture: false,
        toggleButton: false,
        confirmDateOnSelect: true
    });
});

document.getElementById('vehicleForm').addEventListener('submit', function(event) {
    event.preventDefault(); // Prevent the form from submitting traditionally

    const reg = document.getElementById('reg').value;
    const engine = document.getElementById('engine').value;
    const fuel = document.getElementById('fuel').value;

    // Validation
    if (reg === "" || engine === "" || fuel === "") {
        showResponse('danger', 'YOU MUST ENTER A VALID VEHICLE REGISTRATION, ENGINE SIZE, AND FUEL TYPE');
    } else {
        // Prepare form data
        const formData = new FormData(this);

        // Send data using Fetch API
        fetch(ROOT_URL + '/includes/finance/finance_functions.php', {
                method: 'POST',
                body: formData // Use FormData directly for file and input data
            })
            .then(response => response.text())
            .then(result => {
                //debug(result); // Check the result from the server
                if (result.trim() === "success") {
                    showResponse('success', 'Your vehicle has been saved successfully');
                    const option = document.createElement('option');
                    option.value = reg;
                    option.text = reg;
                    option.selected = true;
                    document.getElementById('vReg').appendChild(option);
                    getVehicles(); // Refresh vehicle list after successful save
                }
            })
            .catch(error => {
                console.error('Error:', error); // Handle any errors
            });
    }
});
</script>