<?php ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Retrieve ticket ID from GET parameter
$ticket_id = isset($_GET['ticket_id']) ? (int)$_GET['ticket_id'] : 0;

// Fetch ticket details
$ticket_query = mysqli_query($admin_con, "
    SELECT t.*, c.company_name 
    FROM support_tickets t 
    JOIN client_subscriptions c ON t.client_id = c.client_id 
    WHERE t.id = $ticket_id AND t.status = 'completed'");
$ticket = mysqli_fetch_assoc($ticket_query);

if (!$ticket) {
    echo "<p>Ticket not found or access denied.</p>";
    exit;
}

// Fetch replies for the ticket
$replies_query = mysqli_query($admin_con, "
    SELECT * FROM support_ticket_replies 
    WHERE ticket_id = $ticket_id 
    ORDER BY date_sent DESC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="resources/mdb/css/mdb.min.css">
    <link rel="stylesheet" href="resources/mdb/plugins/css/all.min.css">
    <title>Archived Ticket #<?= htmlspecialchars(str_pad($ticket['id'], 6, '0', STR_PAD_LEFT)); ?></title>
</head>

<body>
    <div class="container">
        <h4 class="mb-4"><a class="me-2 btn btn-info btn-sm p-0" href="index.php?t=includes/support&p=support_tickets.php"><i class="fad fa-chevron-left"></i> Back</a> Ticket #<?= str_pad($ticket['id'], 6, '0', STR_PAD_LEFT); ?> -
            <?= htmlspecialchars($ticket['title']); ?></h4>

        <!-- Ticket Details -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <span class="mb-0">Ticket Details </span><span class="float-end"><strong>Status:</strong> <span
                          class="badge <?= $ticket['status'] === 'In Progress' ? 'bg-warning' : ($ticket['status'] === 'Completed' ? 'bg-danger' : 'bg-info') ?>"><?= ucfirst($ticket['status']); ?></span></span>
            </div>
            <div class="card-body">

                <p><strong>Priority:</strong> <?= ucfirst($ticket['priority']); ?></p>
                <p><strong>Created on:</strong> <?= date("d/m/Y H:i", strtotime($ticket['date_created'])); ?></p>
                <p><strong>Last updated:</strong> <?= date("d/m/Y H:i", strtotime($ticket['last_updated'])); ?></p>
                <hr>
                <p><?= nl2br(htmlspecialchars($ticket['description'])); ?></p>
            </div>
        </div>


        <!-- Replies Section -->
        <h5 class="text-primary">Replies</h5>
        <?php while ($reply = mysqli_fetch_assoc($replies_query)): ?>
        <div class="card mb-3 shadow-2-strong ">
            <div class="p-2 <?= $reply['sender_type'] === 'Admin' ? 'bg-dark text-white' : 'bg-secondary text-white' ?>">
                <strong><?= ucfirst($reply['sender_type']); ?>:</strong><small class="float-end"><?= date("d/m/Y H:i", strtotime($reply['date_sent'])); ?></small>
            </div>
            <div class="card-body">
                <p><strong><?= ucfirst($reply['sender_type']); ?>:</strong></p>
                <p><?= nl2br(htmlspecialchars($reply['message'])); ?></p>

                <?php if ($reply['attachment']): 
                
                $urlPath = ADMIN_URL . "/ticket_files/" . htmlspecialchars($reply['attachment']);
                $fileExtension = pathinfo($reply['attachment'], PATHINFO_EXTENSION);
                $isImage = in_array(strtolower($fileExtension), ['jpg', 'jpeg', 'png', 'gif']);
            ?>
                <p><strong>Attachment:</strong></p>

                <?php if ($isImage): ?>
                <!-- Image thumbnail with download on click -->
                <a href="<?= $urlPath ?>" target="_blank">
                    <img src="<?= $urlPath ?>" alt="attachment" style="width: 100px; height: auto; border-radius: 4px; margin-bottom: 10px;">
                </a>
                <?php else: ?>
                <!-- File icon with filename and download on click -->
                <a href="<?= $urlPath ?>" target="_blank" class="d-flex align-items-center">
                    <i class="fad fa-file-alt fa-2x me-2"></i> <?= basename($reply['attachment']); ?>
                </a>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endwhile; ?>
    </div>


    <script src="resources/mdb/js/mdb.umd.min.js"></script>
    <script>
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/support&p=support_tickets.php">Support</a> <i class="fad fa-angle-double-right mx-2 mt-1"  aria-hidden="true"></i></li> <li class="breadcrumb-item active">Archive ticket #<?= str_pad($ticket['id'], 6, '0', STR_PAD_LEFT); ?></li>';
    </script>
</body>

</html>