<div class="row mb-5">
    <div class="note note-secondary">
        You can define default text for all reporting forms. All new reports of that type will start with the text saved here. - <small>This can be updated at any time but will only affect new reports.</small>
    </div>
</div>

<div class="row">
    <div class="col-12 col-md-9">
        <div class="tab-content">

            <div class="tab-pane rounded" id="t1" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='500'")or die(mysqli_error($GLOBALS['con']));
                $r500=mysqli_fetch_assoc($sql);
                $d500=json_decode($r500['data'],$associative = true);
                ?>
                <form id="F500">
                    <div class="row bg-info text-light p-2">
                        <div>Record of Thorough Examination </div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect">A Defect</label>
                            <input type="text" class="form-control" id="adefect" name="adefect" value="<?= $d500['adefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">B Defect</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d500['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d500['obs']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F500')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t2" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='502'")or die(mysqli_error($GLOBALS['con']));
                $r502=mysqli_fetch_assoc($sql);
                $d502=json_decode($r502['data'],$associative = true);
                ?>
                <form id="F502">
                    <div class="row bg-info text-light p-2">
                        <div>Record of Partial Examination</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partialReason">Reason for being Partial</label>
                            <input type="text" class="form-control" id="partialReason" name="partialReason" value="<?= $d502['partialReason']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect">A Defect</label>
                            <input type="text" class="form-control" id="adefect" name="adefect" value="<?= $d502['adefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">B Defect</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d502['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d502['obs']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F502')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t3" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='503'")or die(mysqli_error($GLOBALS['con']));
                $r503=mysqli_fetch_assoc($sql);
                $d503=json_decode($r503['data'],$associative = true);
                ?>
                <form id="F503">
                    <div class="row bg-info text-light p-2">
                        <div>Plant not available</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="pnareason">Reason(s) for being reported as "not available"</label>
                            <input type="text" class="form-control" id="pnareason" name="pnareason" value="<?= $d503['pnareason']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F503')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t4" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='504'")or die(mysqli_error($GLOBALS['con']));
                $r504=mysqli_fetch_assoc($sql);
                $d504=json_decode($r504['data'],$associative = true);
                ?>
                <form id="F504">
                    <div class="row bg-info text-light p-2">
                        <div>Free Format (Report of Examination)</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect">A Defect</label>
                            <input type="text" class="form-control" id="adefect" name="adefect" value="<?= $d504['adefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">B Defect</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d504['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d504['obs']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F504')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t5" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='601'")or die(mysqli_error($GLOBALS['con']));
                $r601=mysqli_fetch_assoc($sql);
                $d601=json_decode($r601['data'],$associative = true);
                ?>
                <form id="F601">
                    <div class="row bg-info text-light p-2">
                        <div>Report of Pressure System or Part</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="resultOfExam">Result of Examination</label>
                            <input type="text" class="form-control" id="resultOfExam" name="resultOfExam" value="<?= $d601['resultOfExam']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="history">Relevant History including tests and dates</label>
                            <input type="text" class="form-control" id="history" name="history" value="<?= $d601['history']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="examType">Type of examination and test(s) undertaken</label>
                            <textarea class="form-control" id="examType" name="examType"><?= $d601['examType']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsCovered"><?= $d504['obs']?></label>
                            <input type="text" class="form-control" id="partsCovered" name="partsCovered" value="<?= $d601['partsCovered']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsInaccessible">Parts inaccessable</label>
                            <textarea class="form-control" id="partsInaccessible" name="partsInaccessible"><?= $d601['partsInaccessible']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionInternal">Condition of internal parts</label>
                            <input type="text" class="form-control" id="conditionInternal" name="conditionInternal" value="<?= $d601['conditionInternal']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionExternal">Condition of external parts</label>
                            <input type="text" class="form-control" id="conditionExternal" name="conditionExternal" value="<?= $d601['conditionExternal']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionFittings">Condition of fittings</label>
                            <input type="text" class="form-control" id="conditionFittings" name="conditionFittings" value="<?= $d601['conditionFittings']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="repair_details">Repairs or modifications</label>
                            <input type="text" class="form-control" id="repair_details" name="repair_details" value="<?= $d601['repair_details']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Other Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d601['obs']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F601')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t6" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='602'")or die(mysqli_error($GLOBALS['con']));
                $r602=mysqli_fetch_assoc($sql);
                $d602=json_decode($r602['data'],$associative = true);
                ?>
                <form id="F602">
                    <div class="row bg-info text-light p-2">
                        <div>Pressure Plant Report</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="resultOfExam">Result of Examination</label>
                            <input type="text" class="form-control" id="resultOfExam" name="resultOfExam" value="<?= $d602['resultOfExam']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="history">Relevant History including tests and dates</label>
                            <input type="text" class="form-control" id="history" name="history" value="<?= $d602['history']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="examType">Type of examination and test(s) undertaken</label>
                            <textarea class="form-control" id="examType" name="examType"><?= $d602['examType']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsCovered"><?= $d601['resultOfExam']?></label>
                            <input type="text" class="form-control" id="partsCovered" name="partsCovered" value="<?= $d602['partsCovered']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsInaccessible">Parts inaccessable</label>
                            <textarea class="form-control" id="partsInaccessible" name="partsInaccessible"><?= $d602['partsInaccessible']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionInternal">Condition of internal parts</label>
                            <input type="text" class="form-control" id="conditionInternal" name="conditionInternal" value="<?= $d602['conditionInternal']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionExternal">Condition of external parts</label>
                            <input type="text" class="form-control" id="conditionExternal" name="conditionExternal" value="<?= $d602['conditionExternal']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="conditionFittings">Condition of fittings</label>
                            <input type="text" class="form-control" id="conditionFittings" name="conditionFittings" value="<?= $d602['conditionFittings']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="repair_details">Repairs or modifications</label>
                            <input type="text" class="form-control" id="repair_details" name="repair_details" value="<?= $d602['repair_details']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Other Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d602['obs']?>r">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F602')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t7" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='701'")or die(mysqli_error($GLOBALS['con']));
                $r701=mysqli_fetch_assoc($sql);
                $d701=json_decode($r701['data'],$associative = true);
                ?>
                <form id="F701">
                    <div class="row bg-info text-light p-2">
                        <div>LEV Report Initial Thorough Examination</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="test_procedure">Test procedure employed</label>
                            <input type="text" class="form-control" id="test_procedure" name="test_procedure" value="<?= $d701['test_procedure']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="process_conditions">Process conditions at time of test</label>
                            <input type="text" class="form-control" id="process_conditions" name="process_conditions" value="<?= $d701['process_conditions']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="effective">Does the system provide an effective contribution to overall control</label>
                            <input type="text" class="form-control" id="effective" name="effective" value="<?= $d701['effective']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="particulars">Particulars of any defect affecting operating performance and repairs required</label>
                            <input type="text" class="form-control" id="particulars" name="particulars" value="<?= $d701['particulars']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="other_comments">Other comments and observations</label>
                            <textarea class="form-control" id="other_comments" name="other_comments" rows="5"><?= $d701['other_comments']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="usage_comments">Comments on operators usage</label>
                            <textarea class="form-control" id="usage_comments" name="usage_comments" rows="5"><?= $d701['usage_comments']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="intended_performance">Intended operating performance</label>
                            <input type="text" class="form-control" id="intended_performance" name="intended_performance" value="<?= $d701['intended_performance']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="achieving_perfomance">Is the system achieving intended operational performance?</label>
                            <input type="text" class="form-control" id="achieving_perfomance" name="achieving_perfomance" value="<?= $d701['achieving_perfomance']?>">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F701')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t8" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='700'")or die(mysqli_error($GLOBALS['con']));
                $r700=mysqli_fetch_assoc($sql);
                $d700=json_decode($r700['data'],$associative = true);
                ?>
                <form id="F700">
                    <div class="row bg-info text-light p-2">
                        <div>LEV Report Periodical Thorough Examination</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="test_procedure">Test procedure employed</label>
                            <input type="text" class="form-control" id="test_procedure" name="test_procedure" value="<?= $d700['test_procedure']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="process_conditions">Process conditions at time of test</label>
                            <input type="text" class="form-control" id="process_conditions" name="process_conditions" value="<?= $d700['process_conditions']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="effective">Does the system provide an effective contribution to overall control</label>
                            <input type="text" class="form-control" id="effective" name="effective" value="<?= $d700['effective']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="particulars">Particulars of any defect affecting operating performance and repairs required</label>
                            <input type="text" class="form-control" id="particulars" name="particulars" value="<?= $d700['particulars']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="other_comments">Other comments and observations</label>
                            <textarea class="form-control" id="other_comments" name="other_comments" rows="5"><?= $d700['other_comments']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="usage_comments">Comments on operators usage</label>
                            <textarea class="form-control" id="usage_comments" name="usage_comments" rows="5"><?= $d700['usage_comments']?></textarea>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="intended_performance">Intended operating performance</label>
                            <input type="text" class="form-control" id="intended_performance" name="intended_performance" value="<?= $d700['intended_performance']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="achieving_perfomance">Is the system achieving intended operational performance?</label>
                            <input type="text" class="form-control" id="achieving_perfomance" name="achieving_perfomance" value="<?= $d700['achieving_perfomance']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F700')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t9" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='800'")or die(mysqli_error($GLOBALS['con']));
                $r800=mysqli_fetch_assoc($sql);
                $d800=json_decode($r800['data'],$associative = true);
                ?>
                <form id="F800">
                    <div class="row bg-info text-light p-2">
                        <div>Power Press, Guard(s) or Safety Device(s) Report Pt IV</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="clutch">Description of clutch mechanism</label>
                            <input type="text" class="form-control" id="clutch" name="clutch" value="<?= $d800['clutch']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety">safety devices</label>
                            <input type="text" class="form-control" id="safety" name="safety" value="<?= $d800['safety']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="parts_1">Parts inaccessable</label>
                            <input type="text" class="form-control" id="parts_1" name="parts_1" value="<?= $d800['parts_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_1">Identification of any part found to have a defect which is or could become a danger to persons (category "A" defect)</label>
                            <input type="text" class="form-control" id="adefect_1" name="adefect_1" value="<?= $d800['adefect_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_2">Date of notification of Category "A" defects to occupier</label>
                            <input type="text" class="form-control" id="adefect_2" name="adefect_2" value="<?= $d800['adefect_2']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_3">Category "A" defects rectified at time of examination</label>
                            <input type="text" class="form-control" id="adefect_3" name="adefect_3" value="<?= $d800['adefect_3']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">Other Defects</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d800['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d800['obs']?>">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F800')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t10" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='801'")or die(mysqli_error($GLOBALS['con']));
                $r801=mysqli_fetch_assoc($sql);
                $d801=json_decode($r801['data'],$associative = true);
                ?>
                <form id="F801">
                    <div class="row bg-info text-light p-2">
                        <div>Power Press, Guard(s) or Safety Device(s) Report Reg 11.1</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="clutch">Description of clutch mechanism</label>
                            <input type="text" class="form-control" id="clutch" name="clutch" value="<?= $d801['clutch']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety">safety devices</label>
                            <input type="text" class="form-control" id="safety" name="safety" value="<?= $d801['safety']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="parts_1">Parts inaccessable</label>
                            <input type="text" class="form-control" id="parts_1" name="parts_1" value="<?= $d801['parts_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_1">Identification of any part found to have a defect which is or could become a danger to persons (category "A" defect)</label>
                            <input type="text" class="form-control" id="adefect_1" name="adefect_1" value="<?= $d801['adefect_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_2">Date of notification of Category "A" defects to occupier</label>
                            <input type="text" class="form-control" id="adefect_2" name="adefect_2" value="<?= $d801['adefect_2']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect_3">Category "A" defects rectified at time of examination</label>
                            <input type="text" class="form-control" id="adefect_3" name="adefect_3" value="<?= $d801['adefect_3']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">Other Defects</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d801['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d801['obs']?>">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F801')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t11" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='802'")or die(mysqli_error($GLOBALS['con']));
                $r802=mysqli_fetch_assoc($sql);
                $d802=json_decode($r802['data'],$associative = true);
                ?>
                <form id="F802">
                    <div class="row bg-info text-light p-2">
                        <div>Injection Moulding Machine, Guard(s) or Safety Device(s) Report</div>
                    </div>

                    <div class="row p-2 border">
                        <div class="col-12 p-2">
                            <div>Guards</div>
                            <hr>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_1">Front</label>
                            <input type="text" class="form-control" id="safety_1" name="safety_1" value="<?= $d802['safety_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_2">Rear</label>
                            <input type="text" class="form-control" id="safety_2" name="safety_2" value="<?= $d802['safety_2']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_3">Tunnel</label>
                            <input type="text" class="form-control" id="safety_3" name="safety_3" value="<?= $d802['safety_3']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_4">Toggle</label>
                            <input type="text" class="form-control" id="safety_4" name="safety_4" value="<?= $d802['safety_4']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_5">Well Discharge</label>
                            <input type="text" class="form-control" id="safety_5" name="safety_5" value="<?= $d802['safety_5']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_6">Nozzle / Purge</label>
                            <input type="text" class="form-control" id="safety_6" name="safety_6" value="<?= $d802['safety_6']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_7">Hopper Throat</label>
                            <input type="text" class="form-control" id="safety_7" name="safety_7" value="<?= $d802['safety_7']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_8">Top</label>
                            <input type="text" class="form-control" id="safety_8" name="safety_8" value="<?= $d802['safety_8']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_9">Barrel</label>
                            <input type="text" class="form-control" id="safety_9" name="safety_9" value="<?= $d802['safety_9']?>">
                        </div>
                        <div class="col-12 p-2">
                            <div>Safety</div>
                            <hr>
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_10">Emergency Stops</label>
                            <input type="text" class="form-control" id="safety_10" name="safety_10" value="<?= $d802['safety_10']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_11">Interlocks</label>
                            <input type="text" class="form-control" id="safety_11" name="safety_11" value="<?= $d802['safety_11']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_12">Mechanical Scotch</label>
                            <input type="text" class="form-control" id="safety_12" name="safety_12" value="<?= $d802['safety_12']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_13">Safety Mat(s)</label>
                            <input type="text" class="form-control" id="safety_13" name="safety_13" value="<?= $d802['safety_13']?>">
                        </div>

                        <div class="col-12 p-2">
                            <hr>
                        </div>

                        <div class="col-12 col-md-6 mb-4">
                            <label for="repair_1">Repairs, renewals or alterations to the injection moulder's guards and protection devices that are or may become a cause of danger to employed persons Immediately</label>
                            <input type="text" class="form-control" id="repair_1" name="repair_1" value="<?= $d802['repair_1']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="repair_2">Repairs, renewals or alterations to the injection moulder's guards and protection devices that are or may become a cause of danger to employed persons within a specified time</label>
                            <input type="text" class="form-control" id="repair_2" name="repair_2" value="<?= $d802['repair_2']?>">
                        </div>

                        <div class="col-12 p-2">
                            <hr>
                        </div>

                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsInaccessible">Parts inaccessible</label>
                            <input type="text" class="form-control" id="partsInaccessible" name="partsInaccessible" value="<?= $d802['partsInaccessible']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety_13">Recommendations</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d802['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d802['obs']?>">
                        </div>

                    </div>


                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F802')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t12" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='900'")or die(mysqli_error($GLOBALS['con']));
                $r900=mysqli_fetch_assoc($sql);
                $d900=json_decode($r900['data'],$associative = true);
                ?>
                <form id="F900">
                    <div class="row bg-info text-light p-2">
                        <div>Portable Appliance Test Record</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="class">Class</label>
                            <input type="text" class="form-control" id="class" name="class" value="<?= $d900['class']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="volts">Voltage</label>
                            <input type="text" class="form-control" id="volts" name="volts" value="<?= $d900['volts']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="ebond">Earth Bond</label>
                            <input type="text" class="form-control" id="ebond" name="ebond" value="<?= $d900['ebond']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="ires">Insulation Resistance: (M ohms)</label>
                            <input type="text" class="form-control" id="ires" name="ires" value="<?= $d900['ires']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d900['obs']?>">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F900')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t13" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='506'")or die(mysqli_error($GLOBALS['con']));
                $r506=mysqli_fetch_assoc($sql);
                $d506=json_decode($r506['data'],$associative = true);
                ?>
                <form id="F506">
                    <div class="row bg-info text-light p-2">
                        <div>Record of Examination (none stat)</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect">A Defect</label>
                            <input type="text" class="form-control" id="adefect" name="adefect" value="<?= $d506['adefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">B Defect</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d506['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Observations</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d506['obs']?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F506')">Save</a></div>
                    </div>
                </form>
            </div>

            <div class="tab-pane rounded" id="t14" role="tabpanel">
                <?php 
                $sql=mysqli_query($GLOBALS['con'],"SELECT * FROM `default_text` WHERE `formNumber`='507'")or die(mysqli_error($GLOBALS['con']));
                $r507=mysqli_fetch_assoc($sql);
                $d507=json_decode($r507['data'],$associative = true);
                ?>
                <form id="F507">
                    <div class="row bg-info text-light p-2">
                        <div>Pallet Racking Report</div>
                    </div>
                    <div class="row p-2 border">
                        <div class="col-12 col-md-6 mb-4">
                            <label for="partsInaccessible">Parts Inaccessible</label>
                            <input type="text" class="form-control" id="partsInaccessible" name="partsInaccessible" value="<?= $d507['partsInaccessible']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="frequency">Frequency</label>
                            <input type="text" class="form-control" id="frequency" name="frequency" value="<?= $d507['frequency']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="handling">Handling</label>
                            <input type="text" class="form-control" id="handling" name="handling" value="<?= $d507['handling']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="stability">Stability</label>
                            <input type="text" class="form-control" id="stability" name="stability" value="<?= $d507['stability']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="safety">Safety</label>
                            <input type="text" class="form-control" id="safety" name="safety" value="<?= $d507['safety']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="adefect">Category A</label>
                            <input type="text" class="form-control" id="adefect" name="adefect" value="<?= $d507['adefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="bdefect">Category B</label>
                            <input type="text" class="form-control" id="bdefect" name="bdefect" value="<?= $d507['bdefect']?>">
                        </div>
                        <div class="col-12 col-md-6 mb-4">
                            <label for="obs">Category C</label>
                            <input type="text" class="form-control" id="obs" name="obs" value="<?= $d507['obs']?>">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 text-center"><a class="btn btn-info" href="javascript:void(0)" onclick="save('F507')">Save</a></div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <p class="bg-info text-light py-2 text-center">Select Form type</p>
        <div class="input-group mb-2">
            <input type="text" id="formSearch" class="form-control" placeholder="Search forms...">
            <button class="btn btn-outline-secondary" type="button" id="clearSearch">Clear</button>
        </div>

        <div style="max-height:400px; overflow-y:auto">
            <div class="list-group list-group" id="formList" role="tablist">
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t1" role="tab">Record of Thorough Examination <span class="badge badge-primary badge-pill">500</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t2" role="tab">Record of Partial Examination <span class="badge badge-primary badge-pill">502</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t3" role="tab">Plant Not Available <span class="badge badge-primary badge-pill">503</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t4" role="tab">Report of Examination <span class="badge badge-primary badge-pill">504</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t5" role="tab">Report of Pressure System or Part <span class="badge badge-primary badge-pill">601</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t6" role="tab">Pressure Plant Report <span class="badge badge-primary badge-pill">602</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t7" role="tab">LEV Report Initial Thorough Examination <span class="badge badge-primary badge-pill">701</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t8" role="tab">LEV Report Periodical Thorough Examination <span class="badge badge-primary badge-pill">700</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t9" role="tab">Power Press, Guard(s) or Safety Device(s) Report Pt IV <span class="badge badge-primary badge-pill">800</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t10" role="tab">Power Press, Guard(s) or Safety Device(s) Report Reg 11.1 <span class="badge badge-primary badge-pill">801</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t11" role="tab">Injection Moulding Machine, Guard(s) or Safety Device(s) Report <span class="badge badge-primary badge-pill">802</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t12" role="tab">Portable Appliance Test Record <span class="badge badge-primary badge-pill">900</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t13" role="tab">Record of Examination (none stat) <span class="badge badge-primary badge-pill">506</span></a>
                <a class="btn flex-fill list-group-item" data-mdb-tab-init href="#t14" role="tab">Pallet Racking Report <span class="badge badge-primary badge-pill">507</span></a>
            </div>
        </div>
    </div>

</div>


<script>
document.getElementById('formSearch').addEventListener('input', function() {
    var searchTerm = this.value.toLowerCase(); // Convert search term to lowercase
    var listItems = document.querySelectorAll('#formList .list-group-item'); // Get all list items

    listItems.forEach(function(item) {
        var itemText = item.textContent.toLowerCase(); // Convert the item text to lowercase
        if (itemText.includes(searchTerm)) {
            item.style.display = ''; // Show item if it matches the search term
        } else {
            item.style.display = 'none'; // Hide item if it doesn't match
        }
    });
});

document.getElementById('clearSearch').addEventListener('click', function() {
    var formSearch = document.getElementById('formSearch');
    formSearch.value = ''; // Clear the search input

    // Reset the list to show all items
    var listItems = document.querySelectorAll('#formList .list-group-item');
    listItems.forEach(function(item) {
        item.style.display = ''; // Show all items
    });
});

function save(formId) {
    var form = document.getElementById(formId);
    var formData = new FormData(form);

    // Add formNumber to the form data
    formData.append('formNumber', formId);
    formData.append('tenant', TENANT_URL);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', ROOT_URL + '/includes/master/text_functions.php', true);

    xhr.onreadystatechange = function() {
        if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
            var result = xhr.responseText;

            if (result.trim() === "success") {
                showResponse('success', 'Your changes have been saved successfully');
            } else {
                showResponse('danger', 'There was a problem, please check your details and try again<br><br>' + result);
            }

        }
    };

    xhr.send(formData); // Send the form data
}


document.getElementById('navBox').innerHTML = '<li class="breadcrumb-item">Tools <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item active">Default Text</li>';
</script>