<?php
if (file_exists('../../../' . $_REQUEST['tenant'] . '/config.php')) {
    require_once('../../../' . $_REQUEST['tenant'] . '/config.php');
}
if (file_exists('/config.php')) {
    require_once('/config.php');
}
require_once(ROOT_URL . '/includes/asset/asset_functions.php'); ?>
<div class="row">
    <div class="col-12">
        <div class="note note-secondary mb-4"><strong>Inspection Reports:</strong> By setting a date range, you can
            eaily see which clients have had inspections, and by loading the data, you can see a list of all assets for
            that client that
            were inspected within your date range.</div>
    </div>
</div>
<div id="initialScreen">
    <div class="row">
        <div class="col-12">
            <!-- Badge -->
            <span class="badge rounded-pill bg-primary me-2">1</span> SELECT DATE RANGE
            <hr>
            <div class="row">
                <!-- Start Date -->
                <div class="col-6 col-md-3 date-picker" data-date-type="open" data-mdb-toggle-button="false">
                    <label class="control-label" for="date_start">Start Date</label>
                    <input class="form-control" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker" type="text"
                        name="date_start" id="date_start" placeholder="START DATE" />
                </div>

                <!-- End Date -->
                <div class="col-6 col-md-3 date-picker" data-date-type="open" data-mdb-toggle-button="false">
                    <label class="control-label" for="date_end">End Date</label>
                    <input class="form-control" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker" type="text"
                        name="date_end" id="date_end" placeholder="END DATE" value="<?= date('d-m-Y') ?>" />
                </div>

                <!-- Load Clients Button -->
                <div class="col-12 col-md-2">
                    <a class="btn btn-info btn-sm mt-4" href="javascript:void(0)" onClick="loadData()">Load Clients</a>
                </div>
            </div>
        </div>
        <hr>
    </div>
</div>



<div id="loadingObject" style="display:none">
    <h1 class=" text-center"><i class="fad fa-flux-capacitor fa-spin fa-3x fa-fw"
            style="--fa-primary-color: #0055A6; --fa-secondary-color: gray;"></i><br>Loading Data <br><small>Please
            wait</small>
    </h1>
</div>

<div id="data"></div>


<script>
// Function to load data based on date range
function loadData() {
    // showLoadingIndicator("Loading data", "fa-radar fa-spin-reverse", modalId = null)
    var s = document.getElementById('date_start').value; // Get start date
    var e = document.getElementById('date_end').value; // Get end date

    // Create form data to send in the POST request
    var params = new URLSearchParams();
    params.append('FCN', 'clients');
    params.append('start', s);
    params.append('end', e);
    params.append('tenant', TENANT_URL);

    fetch(ROOT_URL + '/includes/master/inspection_reports_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: params.toString()
        })
        .then(response => response.text()) // Get the response as text
        .then(data => {
            document.getElementById('data').innerHTML = data;


            // $('#datatable').dataTable();
        })
        .catch(error => {
            console.error('Error:', error); // Handle errors
            document.getElementById('printingObject').style.display = 'none';
            document.getElementById('pageBackdrop').style.display = 'none';
        });
}

// Function to load client-specific data
function loadClient(i) {
    const s = document.getElementById('date_start').value;
    const e = document.getElementById('date_end').value;

    // Tear down any existing table to avoid double-init
    const el = document.getElementById('datatable');
    if (el) {
        if (window.jQuery && $.fn.DataTable && $.fn.DataTable.isDataTable(el)) {
            $(el).DataTable().destroy();
        } else if (window.mdb && mdb.Datatable) {
            const prev = mdb.Datatable.getInstance(el);
            if (prev) prev.dispose();
        }
    }

    const url =
        `${ROOT_URL}/includes/master/inspection_reports_data.php` +
        `?FCN=items&clientnumber=${encodeURIComponent(i)}` +
        `&start=${encodeURIComponent(s)}&end=${encodeURIComponent(e)}` +
        `&tenant=${encodeURIComponent(TENANT_URL)}`;

    //showLoadingIndicator("Loading data", "fa-radar fa-spin-reverse", null);

    // This executes embedded scripts from the response
    loadContentAndExecuteScripts(url, 'data', function() {
        document.getElementById('printingObject').style.display = 'none';
        document.getElementById('pageBackdrop').style.display = 'none';
    });
}





document.getElementById('navBox').innerHTML =
    '<li class="breadcrumb-item">Tools <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item active">Inspection Reports</li>';
</script>