<?php 
// elec.php - Main control file for Electrical Inspection views
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Define the root path for the elec view files
$elec_path = ROOT_URL . '/includes/elec/';

// Check the 'view' parameter to determine which file to load
$view = isset($_REQUEST['view']) ? $_REQUEST['view'] : 'elec_client';

$_REQUEST['data']= isset($_REQUEST['data']) ? $_REQUEST['data'] : '';
$d=explode("|",$_REQUEST['data']);
$stmt = $GLOBALS['con']->prepare("SELECT `clientname` FROM `clientdetails` WHERE `clientnumber`=? ")or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i',$d[1]);$stmt->execute();$cr=$stmt->get_result();$stmt->close();
$cd=mysqli_fetch_array($cr);

switch ($view) {
    case 'elec_list':
        require($elec_path . 'elec_list.php');
        break;
    
    case 'elec_distro':
        require($elec_path . 'elec_distro.php');
        break;
    
    case 'elec_report':
        require($elec_path . 'elec_report.php');
        break;
    case 'elec_distro_edit':
        require($elec_path . 'elec_distro_edit.php');
        break;
        
    case 'elec_client':
        require($elec_path . 'elec_client.php');
        break;

    case 'elec_new_circuit':
        require($elec_path . 'elec_new_circuit.php');
    break;
    case 'elec_list_circuit':
        require($elec_path . 'elec_list_circuits.php');
    break;

    case "elec_edit_circuit":
        require($elec_path . 'elec_edit_circuit.php');
    break;
    
    case "elec_list_reports":
        require($elec_path . 'elec_list_reports.php');
    break;

    case "elec_new_report":
        require($elec_path . 'elec_new_report.php');
    break;

    case "elec_test_report":
        require($elec_path . 'elec_report_output.php');
    break;

    case "elec_edit_report":
        require($elec_path . 'elec_edit_report.php');
    break;

    default:
        echo "Invalid view specified.";
        break;
}
?>