<script src="<?= ROOT_URL ?>/src/main.min.js"></script>
<link rel="stylesheet" href="<?= ROOT_URL ?>/src/style.css?v=5.0.3">
<?php $stmt = $GLOBALS['con']->prepare("SELECT * FROM `company`") or die(mysqli_error($GLOBALS['con']));
$stmt->execute();
$a = $stmt->get_result();
$stmt->close();
$d = mysqli_fetch_array($a);


$twofaEnabled = 0;
if (isset($admin_con) && $admin_con instanceof mysqli) {
    $q2 = $admin_con->prepare("SELECT admin_2fa_enabled FROM client_subscriptions WHERE subdomain_prefix=? LIMIT 1");
    $q2->bind_param('s', $dbTenant);
    $q2->execute();
    $r2  = $q2->get_result();
    $row = $r2 ? $r2->fetch_assoc() : null;
    $twofaEnabled = (int)($row['admin_2fa_enabled'] ?? 0);
    $q2->close();
}
?>

<div class="note note-secondary mb-5">
    <strong>Company Setup:</strong> The primary function of this section is to manage your company data within
    <strong>EnRep</strong>, these details will form your identity and information will be used on the output reports,
    finance
    reports, and all
    emails delivered via <strong>EnRep</strong>
</div>

<div class="row mt-n5 mt-md-0 mb-4">
    <div class="btn-group" role="group">
        <a class="btn btn-secondary" href="#details">Details</a>
        <a class="btn btn-secondary" href="#contact">Contact</a>
        <a class="btn btn-secondary" href="#bank">Bank</a>
        <a class="btn btn-secondary" href="#finance">Finance</a>
        <a class="btn btn-secondary" href="#paypal">PayPal</a>
        <a class="btn btn-secondary" href="#options">Options</a>
    </div>
    <div class="spacer"></div>
</div>
<form id="companyForm" class="form-horizontal">

    <div id="company" class="row">

        <div class="col-12">
            <div class="card">
                <div class="card-header">Company Details</div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12 col-md-6">

                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="company">Company Name</label>
                                <div class="col-12 col-md-9"><input id="company" name="company" type="text"
                                        placeholder="" class="form-control " value="<?= $d['company'] ?>" required>
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="company_short">Short Name</label>
                                <div class="col-12 col-md-9"><input id="company_short" name="company_short" type="text"
                                        placeholder="" class="form-control " value="<?= $d['company_short'] ?>"
                                        required></div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="address1">Address 1</label>
                                <div class="col-12 col-md-6"><input id="address1" name="address1" type="text"
                                        placeholder="" class="form-control " value="<?= $d['address1'] ?>" required>
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="address2">Address 2</label>
                                <div class="col-12 col-md-6"><input id="address2" name="address2" type="text"
                                        placeholder="" class="form-control " value="<?= $d['address2'] ?>"></div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="town">Town</label>
                                <div class="col-12 col-md-6"><input id="town" name="town" type="text" placeholder=""
                                        class="form-control " value="<?= $d['town'] ?>"></div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="county">County</label>
                                <div class="col-12 col-md-6"><input id="county" name="county" type="text" placeholder=""
                                        class="form-control " value="<?= $d['county'] ?>"></div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-12 col-md-2 control-label" for="post">Post Code</label>
                                <div class="col-12 col-md-6"><input id="post" name="post" type="text" placeholder=""
                                        class="form-control " value="<?= $d['post'] ?>"></div>
                            </div>

                        </div>


                        <div class="col-12 col-md-6">

                            <div class="form-group row mb-3">
                                <label class="col-md-2 control-label" for="co_tel">Tel</label>
                                <div class="col-md-4"><input id="tel" name="tel" type="text" placeholder=""
                                        class="form-control " value="<?= $d['tel'] ?>" required></div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-md-2 control-label" for="fax">Fax</label>
                                <div class="col-md-4"><input id="fax" name="fax" type="text" placeholder=""
                                        class="form-control " value="<?= $d['fax'] ?>"></div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-md-2 control-label" for="main_email">Email</label>
                                <div class="col-md-9"><input id="main_email" name="main_email" type="text"
                                        placeholder="" class="form-control " value="<?= $d['main_email'] ?>" required>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-md-2 control-label" for="finance_email">Finance Email<br><small>(If
                                        different)</small></label>
                                <div class="col-md-9"><input id="finance_email" name="finance_email" type="text"
                                        placeholder="" class="form-control " value="<?= $d['finance_email'] ?>"></div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-md-2 control-label" for="web">Web</label>
                                <div class="col-md-9"><input id="web" name="web" type="text" placeholder=""
                                        class="form-control " value="<?= $d['web'] ?>"></div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>

    <div class="spacer"></div>

    <div class="row" id="finance">
        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Finance Details</div>
                <div class="card-body">
                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="vatno">VAT No</label>
                        <div class="col-md-4"><input id="vatno" name="vatno" type="text" placeholder=""
                                class="form-control " value="<?= $d['vatno'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="compno">Company No</label>
                        <div class="col-md-4"><input id="compno" name="compno" type="text" placeholder=""
                                class="form-control " value="<?= $d['compno'] ?>"></div>
                    </div>

                    <?php $date = strtotime(date('05-04-Y'));
                    $end = strtotime('+12 months', $date);
                    if ($d['tax_YB'] == "") {
                        $tax_YB = date('06-04-Y');
                    } else {
                        $tax_YB = date('d-m-Y', $d['tax_YB']);
                    }
                    if ($d['tax_YE'] == "") {
                        $tax_YE = date('d-m-Y', $end);
                    } else {
                        $tax_YE = date('d-m-Y', $d['tax_YE']);
                    }
                    ?>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="tax_YB">Tax year start <small
                                class="text-danger">Initial setup only</small></label>
                        <div class="col-md-4 input-group"><input class="form-control datepicker" type="text"
                                name="tax_YB" id="tax_YB" value="<?= $tax_YB ?>" /></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="tax_YE">Tax year end <small
                                class="text-danger">Initial setup only</small></label>
                        <div class="col-md-4 input-group"><input class="form-control datepicker" type="text"
                                name="tax_YE" id="tax_YE" value="<?= $tax_YE ?>" /></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="tax_CS">VAT Start month <small
                                class="text-danger">Initial setup only</small></label>
                        <div class="col-md-2">
                            <select id="tax_CS" name="tax_CS" type="text" placeholder=""
                                class="form-control autocomplete">

                                <option value="12" <?php if ($d['tax_CS'] == 12) {
                                                        echo "selected";
                                                    } ?>>December</option>

                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label" for="tax_CY">VAT Cycle</label>
                        <div class="col-md-2">
                            <select id="tax_CY" name="tax_CY" type="text" placeholder=""
                                class="form-control autocomplete">
                                <option value="4" <?php if ($d['tax_CY'] == 4) {
                                                        echo "selected";
                                                    } ?>>Quarterly</option>
                                <option value="1" <?php if ($d['tax_CY'] == 1) {
                                                        echo "selected";
                                                    } ?>>Monthly</option>
                                <option value="12" <?php if ($d['tax_CY'] == 12) {
                                                        echo "selected";
                                                    } ?>>Annually</option>
                            </select>
                        </div>
                    </div>


                </div>
            </div>
        </div>


        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">HMRC MTD</div>
                <div class="card-body">
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="hmrcVRN">VRN</label>
                        <div class="col-md-4"><input id="hmrcVRN" name="hmrcVRN" type="text" placeholder=""
                                class="form-control " value="<?= $d['hmrcVRN'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="hmrcServerToken">Server Token</label>
                        <div class="col-md-8"><input id="hmrcServerToken" name="hmrcServerToken" type="text"
                                placeholder="" class="form-control " value="<?= $d['hmrcServerToken'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="clientId">Client ID</label>
                        <div class="col-md-8"><input id="hmrcClientId" name="hmrcClientId" type="text" placeholder=""
                                class="form-control " value="<?= $d['hmrcClientId'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="clientSecret">Client Secret</label>
                        <div class="col-md-8"><input id="hmrcClientSecret" name="hmrcClientSecret" type="password"
                                placeholder="" class="form-control " value="<?= $d['hmrcClientSecret'] ?>"></div>
                    </div>

                </div>
            </div>
        </div>



    </div>

    <div class="spacer"></div>

    <div id="contact" class="row">
        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Primary Contact</div>
                <div class="card-body">

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_name">Contact Name</label>
                        <div class="col-md-5"><input id="pri_name" name="pri_name" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_name'] ?>" required></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_add1">Address 1</label>
                        <div class="col-md-5"><input id="pri_add1" name="pri_add1" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_add1'] ?>" required></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_add2">Address 2</label>
                        <div class="col-md-5"><input id="pri_add2" name="pri_add2" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_add2'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_twn">Town</label>
                        <div class="col-md-5"><input id="pri_twn" name="pri_twn" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_twn'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_cou">County</label>
                        <div class="col-md-5"><input id="pri_cou" name="pri_cou" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_cou'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_post">Post Code</label>
                        <div class="col-md-2"><input id="pri_post" name="pri_post" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_post'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_tel">Tel</label>
                        <div class="col-md-2"><input id="pri_tel" name="pri_tel" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_tel'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="pri_eml">Email</label>
                        <div class="col-md-8"><input id="pri_eml" name="pri_eml" type="text" placeholder=""
                                class="form-control " value="<?= $d['pri_eml'] ?>"></div>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Secondary Contact</div>
                <div class="card-body">

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_name">Contact Name</label>
                        <div class="col-md-5"><input id="sec_name" name="sec_name" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_name'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_add1">Address 1</label>
                        <div class="col-md-5"><input id="sec_add1" name="sec_add1" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_add1'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_add2">Address 2</label>
                        <div class="col-md-5"><input id="sec_add2" name="sec_add2" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_add2'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_twn">Town</label>
                        <div class="col-md-5"><input id="sec_twn" name="sec_twn" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_twn'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_cou">County</label>
                        <div class="col-md-5"><input id="sec_cou" name="sec_cou" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_cou'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_post">Post Code</label>
                        <div class="col-md-2"><input id="sec_post" name="sec_post" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_post'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_tel">Tel</label>
                        <div class="col-md-2"><input id="sec_tel" name="sec_tel" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_tel'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sec_eml">Email</label>
                        <div class="col-md-8"><input id="sec_eml" name="sec_eml" type="text" placeholder=""
                                class="form-control " value="<?= $d['sec_eml'] ?>"></div>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <div class="spacer"></div>

    <div id="bank" class="row">
        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Bank Details</div>
                <div class="card-body">
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="bankName">Bank Name</label>
                        <div class="col-md-3"><input id="bankName" name="bankName" type="text" placeholder=""
                                class="form-control " value="<?= $d['bankName'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="accountNo">Account number</label>
                        <div class="col-md-3"><input id="accountNo" name="accountNo" type="text" placeholder=""
                                class="form-control " value="<?= $d['accountNo'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="sortCode">Sort Code</label>
                        <div class="col-md-2"><input id="sortCode" name="sortCode" type="text" placeholder=""
                                class="form-control " value="<?= $d['sortCode'] ?>"></div>
                    </div>

                </div>
            </div>
        </div>

        <div id="paypal" class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Paypal Details</div>
                <div class="card-body">
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="ppStatus">Enable Paypal</label>
                        <div class="col-md-3">
                            <input class="js-switch" type="checkbox" id="ppStatus" name="ppStatus" value="1" <?php if ($d['ppStatus'] == 1) {
                                                                                                                    echo "checked";
                                                                                                                } ?>>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="ppEmail">Paypal Email</label>
                        <div class="col-md-5"><input id="ppEmail" name="ppEmail" type="text" placeholder=""
                                class="form-control " value="<?= $d['ppEmail'] ?>"></div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="ppAuth">AuthCode</label>
                        <div class="col-md-5"><input id="ppAuth" name="ppAuth" type="text" placeholder=""
                                class="form-control " value="<?= $d['ppAuth'] ?>"></div>
                    </div>

                </div>
            </div>
        </div>

    </div>

    <div class="spacer"></div>

    <div id="options" class="row">
        <div class="col-12 col-md-6">
            <div class="card">
                <div class="card-header">Additional Options</div>
                <div class="card-body">

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="vatno">Default Rate Per Hour</label>
                        <div class="col-md-6"><input id="rph" name="rph" type="text" placeholder=""
                                class="form-control " value="<?= $d['rph'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="vatrate">Current Vat Rate</label>
                        <div class="col-md-2"><input id="vatrate" name="vatrate" type="text" placeholder=""
                                class="form-control " value="<?= $d['vatrate'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="vatrate">Rapid Report offset (days)</label>
                        <div class="col-md-2"><input id="rapid" name="rapid" type="text" placeholder=""
                                class="form-control " value="<?= $d['rapid'] ?>"></div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label">Report mode</label>
                        <div class="col-md-10 d-flex align-items-center">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="repMode" id="repModeSingle" value="1"
                                    <?= ($d['repMode'] == 1 ? 'checked' : '') ?>>
                                <label class="form-check-label" for="repModeSingle">Single header</label>
                            </div>
                            <div class="form-check form-check-inline ms-3">
                                <input class="form-check-input" type="radio" name="repMode" id="repModeRepeat" value="0"
                                    <?= ($d['repMode'] == 0 ? 'checked' : '') ?>>
                                <label class="form-check-label" for="repModeRepeat">Repeated header</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-2 control-label" for="admin_2fa_enabled">Admin 2FA</label>
                        <div class="col-md-10 d-flex align-items-center">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="admin_2fa_enabled"
                                    name="admin_2fa_enabled" value="1" <?= $twofaEnabled ? 'checked' : '' ?>
                                    data-mdb-tooltip-init data-mdb-placement="top" data-mdb-trigger="hover"
                                    title="Require email code on new devices for Admin logins">
                                <label class="form-check-label ms-2" for="admin_2fa_enabled">Enable 2FA for admin
                                    logins</label>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" name="clientnumber" value="<?= $_REQUEST['clientnumber'] ?>">
                    <input type="hidden" name="FUNCTION" value="update">
                    <input type="hidden" name="tenant" value="<?= TENANT_URL ?>">
                    <input id="btn_update" type="submit" name="submit" value="Update" style="display:none">
</form>

</div>
</div>
</div>

<div class="col-md-6">
    <?php require_once(ROOT_URL . '/forms/elements/company_logo.frm') ?>
</div>

</div>

<div class="spacer"></div>

<div id="options" class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Affiliate Logos</div>
            <div class="card-body">
                <div class="row">
                    <?php foreach (range(1, 6) as $file) { ?>
                        <div class="col-md-2" style="position:relative">
                            <div class="col-12 text-center">
                                <div class="card">
                                    <div class="card-header">Affiliate Logo #<?= $file ?></div>
                                    <div id="crop<?= $file ?>" class="card-body">

                                        <div class="slim" data-ratio="1:1" data-did-remove="imageRemoved"
                                            data-force-type="jpg" data-label="Select Image"
                                            data-service="images/afl_save.php" data-filter-sharpen="20" data-push="true"
                                            data-meta-userid="1234" data-meta-imageid="afl_<?= $file ?>"
                                            data-size="440,440">
                                            <?php if (file_exists('images/company/afl_' . $file . '.jpg')) { ?>
                                                <img src="images/company/afl_<?= $file ?>.jpg?<?= rand() ?>"
                                                    alt="Affiliate logo #<?= $file ?>">
                                            <?php } ?>
                                            <input type="file" name="file" />
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function killcrop() {


    }

    function imageRemoved(data) {
        console.log(data);
        var name = data.input.name
        $.post('images/afl_remove.php', {
            image: name
        }, function(data2) {})
    }
</script>


<script>
    document.getElementById('companyForm').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(this); // Use FormData to serialize form
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?= ROOT_URL ?>/includes/company/company_functions.php', true);

        xhr.onreadystatechange = function() {
            if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                //debug(xhr.responseText);
                if (xhr.responseText.trim() === "success") {
                    showResponse('success', 'Your changes have been saved successfully');
                } else {
                    showResponse('danger', 'There was a problem, please check your details and try again');
                }
            }
        };

        // Send the FormData object directly
        xhr.send(formData);
    });


    // Handling footer controls once DOM is ready
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('footerControls').innerHTML =
            '<button class="btn btn-secondary" onclick="triggerAction(\'btn_update\')">UPDATE</button>';
    });

    // Handle image removal
    var removeButtons = document.querySelectorAll('.btnRemove');
    removeButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            var image = this.getAttribute('data-target');
            var src = this.getAttribute('data-src');

            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'images/afl_remove.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            xhr.onreadystatechange = function() {
                if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                    if (xhr.responseText.trim() === "done") {
                        document.querySelector('#' + src + '-view img').setAttribute('src',
                            'images/company/noimage.png');
                        button.style.display = 'none'; // Hide the remove button
                        showResponse('success', 'Image removed successfully');
                    } else {
                        showResponse('danger', 'There was a problem, please try again');
                    }
                }
            };

            xhr.send('afl=' + encodeURIComponent(image));
        });
    });


document.getElementById('navBox').innerHTML = '<li class="breadcrumb-item">Tools <i class="fad fa-angle-double-right mx-2 mt-1" aria-hidden="true"></i></li><li class="breadcrumb-item active">Company Setup</li>';
</script>