<?php
if (file_exists('../../../' . $_REQUEST['tenant'] . '/config.php')) {
    require_once('../../../' . $_REQUEST['tenant'] . '/config.php');
}
if (file_exists('/config.php')) {
    require_once('/config.php');
}

// Load parent item
$stmt = $GLOBALS['con']->prepare("SELECT * FROM `itemdetails` WHERE `itemnumber`=?") or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i', $_REQUEST['parent']);
$stmt->execute();
$cc = $stmt->get_result();
$stmt->close();
$d = mysqli_fetch_array($cc);

// Ensure arrays exist
$do = [];

// Process clones
$rowCount = (int)($_REQUEST['rowCount'] ?? 0);
foreach (range(1, $rowCount) as $i) {
    $plant = $_REQUEST['plantnumber' . $i] ?? '';
    $serial = $_REQUEST['serialnumber' . $i] ?? '';
    if ($plant === '' && $serial === '') {
        continue;
    }

    // Base values
    $d['plantnumber']  = $plant;
    $d['serialnumber'] = $serial;

    // Copy-or-override fields
    $do['manf']        = ($_REQUEST['manf' . $i]        ?? '') !== '' ? $_REQUEST['manf' . $i]        : ($d['manf']        ?? '');
    $do['dateofmanf']  = ($_REQUEST['dateofmanf' . $i]  ?? '') !== '' ? $_REQUEST['dateofmanf' . $i]  : ($d['dateofmanf']  ?? '');
    $do['model']       = ($_REQUEST['model' . $i]       ?? '') !== '' ? $_REQUEST['model' . $i]       : ($d['model']       ?? '');
    $do['swl']         = ($_REQUEST['swl' . $i]         ?? '') !== '' ? $_REQUEST['swl' . $i]         : ($d['swl']         ?? '');

    // NEW: subloc override (blank = keep parent's subloc)
    $sublocParam = ($_REQUEST['subloc' . $i] ?? '') !== '' ? $_REQUEST['subloc' . $i] : ($d['subloc'] ?? null);

    // NEW: duedate override from hidden UNIX field; '' => NULL
    $dueIn = $_REQUEST['duedate' . $i] ?? '';
    $duedateParam = ($dueIn === '' || $dueIn === null) ? null : (int)$dueIn;

    // INSERT (unchanged structure, but pass $sublocParam and $duedateParam)
    $stmt = $GLOBALS['con']->prepare("
        INSERT INTO `itemdetails`
        VALUES(?,NULL,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'',?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'',?,?,NULL)
    ") or die(mysqli_error($GLOBALS['con']));

    // NOTE: Keep original types. Only swapped values for subloc and duedate.
    $stmt->bind_param(
        'iissssssssssssssssssssssssssssssssssssssssssiiisii',
        $d['locnumber'],
        $d['clientnumber'],
        $d['code'],
        $d['desc'],
        $do['swl'],
        $d['plantnumber'],
        $d['serialnumber'],
        $d['ancillarynumber'],
        $do['model'],
        $do['dateofmanf'],
        $do['manf'],
        $sublocParam,                // <- was $d['subloc']
        $d['detailedloc'],
        $d['currdate'],
        $duedateParam,               // <- was $d['duedate']
        $d['statuslive'],
        $d['itemnotes'],
        $d['scheme_number'],
        $d['scheme_number_alt'],
        $d['system_type'],
        $d['lease_or_hire'],
        $d['history'],
        $d['multi_flag'],
        $d['cont_freq'],
        $d['report_position'],
        $d['process'],
        $d['substance'],
        $d['limits'],
        $d['number_of_points'],
        $d['number_in_use'],
        $d['returned_to'],
        $d['pri_filter'],
        $d['sec_filter'],
        $d['regulations'],
        $fanData,                    // keep as in your original environment
        $d['motor_details'],
        $d['primary_filter'],
        $d['secondary_filter'],
        $d['valve'],
        $d['gauge'],
        $d['burst'],
        $d['thorough'],
        $d['intermediate'],
        $d['select_for_scheme'],
        $d['surveyor'],
        $d['agent'],
        $d['broker'],
        $d['reptype'],
        $d['contractor'],
        strtotime('now')
    );

    $stmt->execute();
    $stmt->close();
}

echo "success";
