<?php
if(file_exists('../../../'.$_REQUEST['tenant'].'/config.php')){require_once('../../../'.$_REQUEST['tenant'].'/config.php'); }
if(file_exists('/config.php')){require_once('/config.php');}

$stmt = $GLOBALS['con']->prepare("SELECT * FROM  `dd_hse` ORDER BY `location` ASC");
$stmt->execute();$rx=$stmt->get_result();$stmt->close();
?>
<table id="listTable" class="table table-striped table-sm table-bordered table-hover table-responsive" width="100%">
    <thead>
        <tr>
            <th>Location / Name</th>
            <th>Email</th>
            <th>Telephone</th>
            <th width="250px"></th>
        </tr>
    </thead>
    <tbody>
        <?php while($h=mysqli_fetch_array($rx)){
            $email_values = [
                0 => 0, //client
                1 => $h['contact'], //type
                2 => $h['email'], //recipient
                3 => '', //subject
                4 => '', //message
                5 => '', //attachment
                6 => '' //source
            ];
            $email64_values = base64_encode(json_encode($email_values));
            ?>
        <tr>
            <td><?= $h['location']?></td>
            <td><?= $h['email']?> </td>
            <td><a href="tel:<?= $h['phone']?>"><?= $h['phone']?></a></td>
            <td><a class="emailButton btn btn-secondary me-2" href="javascript:void(0)" data-values='<?= $email64_values ?>'
                   data-href="<?=ROOT_URL?>/includes/master/mailer.php"><i class="fad fa-envelope"></i></a>
                <a class="btn btn-secondary me-2" href="javascript:void(0)" onClick="loadEdit('<?= $h['id']?>')"><i class="fad fa-pen-to-square"></i></a>
                <a class="btn btn-danger text-light" href="javascript:void(0)" onClick="remove('<?= $h['id']?>')"><i class="fad fa-trash"></i></a>
            </td>
        </tr>
        <?php }?>
    </tbody>
</table>
<link rel="stylesheet" type="text/css" href="<?=ROOT_URL?>/packages/dfinal/datatables.min.css" />
<script type="text/javascript" src="<?=ROOT_URL?>/packages/dfinal/datatables.min.js"></script>
<script>
document.body.addEventListener('click', function(event) { // Event delegation on body
    if (event.target.classList.contains('emailButton')) {
        const target = event.target.dataset.href;
        const string = event.target.dataset.values;

        var dest = encodeURI(target + "?string=" + string + "&mode=popup&tenant=" + TENANT_URL);
        loadModalContent(dest, "popupBox", "modal-xl", 1060, "true", "HSE Mailer");

    }
});

function remove(id) {
    var dest = '<p class="text-center">Are you sure you wish to remove this HSE entry?</p>'
    loadModalContent(dest, "removeBox", "modal-xl", 1060, "true", "HSE Removal", "cancelConfirm", () => removeConfirm(id));
}

function removeConfirm(id) {
    var xhr = new XMLHttpRequest();
    var url = ROOT_URL + '/includes/hse/hse_functions.php?FUNCTION=remove&id=' + encodeURIComponent(id) + '&tenant=' + encodeURIComponent(TENANT_URL);

    xhr.open('POST', url, true);

    xhr.onreadystatechange = function() {
        if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
            var result = xhr.responseText.trim();
            showResponse('success', 'The entry has been removed successfully');
            loadData();
            killModal('removeBox')
        }
    };

    xhr.send(); // No need to send form data, so just send the request
}
</script>