<?php require('includes/master/jump_functions.php') ?>
<script>
$('#navBox').html(
    '<li class="breadcrumb-item">Tools <i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadcrumb-item active">Jump List Management</li>'
    );
</script>

<div class="blockquote mt-0 mt-md-n5">
    <p>Modify the content of the lists available throughout your system. Items added to the groups here will be
        available to you in addition to the preset options</p>
</div>



<ul id="jump-nav" class="nav nav-tabs" role="tablist">
    <li id="p1" class="nav-item"><a class="nav-link active" href="#receiptsList" role="tab" id="receipts-tab"
            data-toggle="tab" aria-controls="receipts" onClick="loadItems('payee','list','pl','receipts')">Receipts
            Payee</a></li>
    <lii id="p2" class="nav-item"><a class="nav-link active" href="#outgoingsList" role="tab" id="outgoings-tab"
            data-toggle="tab" aria-controls="outgoings" onClick="loadItems('payee','list','p2','outgoings')">Outgoing
            Payee</a></lii>
    <lii id="p3" class="nav-item"><a class="nav-link" href="#expenseList" role="tab" id="expense-tab" data-toggle="tab"
            aria-controls="expense" onClick="loadItems('expenses','list','p3','expenses')">Expense Type</a></lii>
</ul>


<div id="jump-nav-content" class="tab-content">


    <div role="tabpanel" class="tab-pane fade active show" id="receiptsList" aria-labelledby="receipts-tab">
        <div class="col-md-12 text-right">
            <a data-placement="bottom" data-toggle="tooltip" data-original-title="New entry" id="en"
                class="btn btn-sm btn-outline-success" href="javascript:void(0)"
                onClick="newItem('receipts','pl','list','payee')"><i class="fad fa-plus" aria-hidden="true"></i> New
                Entry</a>
        </div>
        <div id="receipts"></div>
    </div>

    <div role="tabpanel" class="tab-pane fade" id="outgoingsList" aria-labelledby="outgoings-tab">
        <div class="col-md-12 text-right">
            <a data-placement="bottom" data-toggle="tooltip" data-original-title="New entry" id="en"
                class="btn btn-sm btn-outline-success" href="javascript:void(0)"
                onClick="newItem('outgoings','p2','list','payee')"><i class="fad fa-plus" aria-hidden="true"></i> New
                Entry</a>
        </div>
        <div id="outgoings"></div>
    </div>

    <div role="tabpanel" class="tab-pane fade" id="expenseList" aria-labelledby="expense-tab">
        <div class="col-md-12 text-right">
            <a data-placement="bottom" data-toggle="tooltip" data-original-title="New entry" id="ftn"
                class="btn btn-sm btn-outline-success" href="javascript:void(0)"
                onClick="newItem('expense','list','p3','expense')"><i class="fad fa-plus" aria-hidden="true"></i> New
                Entry</a>
        </div>
        <div id="expenses"></div>
    </div>

</div>

<div id="loadingObject" style="position: fixed; top:50%; width:100%">
    <h1 class="text-center"><i class="fad fa-flux-capacitor fa-spin fa-3x fa-fw"
            style="--fa-primary-color: #0055A6; --fa-secondary-color: gray;"></i><br>Loading Data <br><small>Please
            wait</small></h1>
</div>


<script>
function loadItems(t, m, l, i) {
    $('#loadingObject').css('display', 'block');
    $.post('includes/finance/jump_functions.php', {
        LOADER: "load",
        type: t,
        format: m,
        sub: i
    }, function(data) {
        $('#' + i).html(data);
        $('.nav-link').removeClass("active");
        $('#' + l + ' a').addClass("active");
        $('#loadingObject').css('display', 'none');
    })
}

function newItem(t, m, l, i) {
    var data = '';
    data += '<form id="newForm" class="form-horizontal">';
    data += '<div class="card p-0 mr-3" >';
    data += '<div class="card-body px-lg-5 pt-0">';
    data += '<div class="row">';
    if (t == "receipts") {
        data +=
            '<div class="form-group col-7 md-form"><input id="name" name="name" type="text" class="form-control form-control-sm" aria-label="name" value="" /><label for="name">name</label></div>';

        data += '<input type="hidden" name="type" value="in">';
        data += '<input type="hidden" name="mode" value="payee">';
        data += '<input type="hidden" name="FUNCTION" value="save">';
    }

    if (t == "outgoings") {
        data +=
            '<div class="form-group col-7 md-form"><input id="name" name="name" type="text" class="form-control form-control-sm" aria-label="name" value="" /><label for="name">name</label></div>';
        data += '<input type="hidden" name="type" value="out">';
        data += '<input type="hidden" name="mode" value="payee">';
        data += '<input type="hidden" name="FUNCTION" value="save">';
    }

    if (t == "expense") {
        data +=
            '<div class="form-group col-3 md-form"><input id="code" name="code" type="text" class="form-control form-control-sm " aria-label="Code"><label for="code">Code</label></div>';
        data +=
            '<div class="form-group col-12 md-form"><input id="desc" name="desc" type="text" class="form-control" aria-label="desc"><label for="desc">Desc</label></div>';
        data += '<input type="hidden" name="mode" value="expenses">';
        data += '<input type="hidden" name="FUNCTION" value="save">';
    }
    data += '</div>';
    data += '</div>';
    data += '<div class="card-footer">';
    data += '<button class="btn btn-outline-success mr-3" type="button" onclick="saveItem(\'' + i + '\',\'' + m +
        '\',\'' + l + '\',\'' + t + '\')"><i class="fad fa-save" aria-hidden="true"></i> Save Entry</button>';
    data +=
        '<button class="btn btn-outline-danger float-right" type="button" onclick="closePop()"><i class="fad fa-times" aria-hidden="true"></i> Cancel</button>';
    data += '</div>';
    data += '</div>';
    data += '</div>';
    data += '</form>';

    showPop('New ' + t, data, '', '')
}


function saveItem(t, m, l, i) {
    event.preventDefault();
    $.ajax({
        url: 'includes/finance/jump_functions.php',
        type: 'POST',
        data: $('#newForm').serialize(),
        success: function(result) {
            if ($.trim(result) == "s") {
                response('success', 'Your entry has been saved successfully');
                loadItems(t, m, l, i)
                closePop()
            } else {
                response('danger', 'The code is already in the system')
            }
        }


    });
}

function remove(t, i, b, m) {
    confirmBox('Remove ' + t + ' Entry', 'Sure you wish to remove this entry?', 'delItem(\'' + t + '\',\'' + i +
        '\',\'' + b + '\',\'' + m + '\')')
}

function delItem(t, i, b, m) {
    $.post('includes/finance/jump_functions.php', {
        FUNCTION: 'remove',
        table: t,
        id: i
    }, function(result) {
        if ($.trim(result) == "s") {
            response('success', 'Your entry has been removed successfully');
            loadItems(t, 'list', b, m)
            $('#confirmBox').modal('hide')
            closePop()
        }
    })
}

function edit(id, type, b, t) {
    $('#popupBox .modal-body').html('');
    var target = 'includes/finance/jump_edit-' + type + '.php'
    var dest = encodeURI(target + "?id=" + id)
    $('#popupBox').modal('show');
    $('#popupBox .modal-body').load(dest);

}

loadItems('payee', 'list', 'p1', 'receipts')
</script>