<?php require('includes/finance/finance_functions.php');?>
<p class="blockquote mt-n5">
    <span class="float-right"><a class="btn btn-secondary" href="index.php?t=includes/finance&p=reports.php"><i class="fad fa-file-invoice"></i> View Reports </a></span>Select the date range and report category you wish to
    load.<br><small>You will get additional filtering options depending on the category you choose.</small>

</p>
<div class="row">
    <div class="col-12 col-md-3">
        <div class="input-group row">
            <div class="col-12 col-md-5"><label class="lead control-label" for="date">Start date</label></div>
            <div class="col-12 col-md-7 input-group"><input class="form-control form-control-sm renewDatepicker" type="text" name="sdate" id="sdate" value="<?php echo $date?>" placeholder="DD-MM-YYYY" /></div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="input-group row">
            <div class="col-12 col-md-5"><label class="lead control-label" for="date">End date</label></div>
            <div class="col-12 col-md-7 input-group"><input class="form-control form-control-sm renewDatepicker" type="text" name="edate" id="edate" value="<?php echo $date?>" placeholder="DD-MM-YYYY" /></div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="row">
            <div class="col-12 col-md-6"><label class="lead control-label" for="reptype">Report Category</label></div>
            <div class="col-12 col-md-6">
                <select id="type" name="reptype" class="col-md-12 form-control form-control-sm autocomplete" data-placeholder="Select Report Type">
                    <option value="">Select Report Type</option>
                    <option value="Invoice Paid">Invoice Paid</option>
                    <option value="Invoice Outstanding">Invoice Outstanding</option>
                    <option value="Invoice All">Invoice All</option>
                    <option value="Outgoings">Outgoings</option>
                    <option value="Outgoings by Category">Outgoings by Category</option>
                    <option value="Receipts">Receipts</option>
                    <option value="Receipts by Category">Receipts by Category</option>
                    <option value="VAT In">VAT In</option>
                    <option value="VAT Out">VAT Out</option>
                </select>
            </div>
        </div>
    </div>

    <div class="col-12 col-lg-3 text-center">
        <button id="reportLoader" class="btn btn-info btn-sm">Load</button>
    </div>

</div>

<div class="clearfix"></div>

<div id="OptionRow" class="col-md-12" style="display: none">
    <div class="row">
        <div class="col-md-12 text-center lead">Filter Results</div>
    </div>
    <div class="row">
        <div class="col-md-2 offset-md-1"><span class="lead"><small>By Client</small></span><br><?php echo listClient(0,'clientSelect','select')?></div>
        <div class="col-md-2 offset-md-2"><span class="lead"><small>By Broker</small></span><br><?php echo listBrokers(0,'brokerSelect','select')?></div>
        <div class="col-md-2 offset-md-2"><span class="lead"><small>By Agent</small></span><br><?php echo listAgent(0,'agentSelect','select')?></div>
    </div>
</div>
<div class="clearfix"></div>
<div class="col-md-12">
    <hr />
</div>

<div id="reportData" class="col-md-12"></div>
<div class="clearfix"></div>

<div id="loadingObject" style="position: fixed; top:50%; width:100%; display:none">
    <h1 class="text-center"><i class="fad fa-file-chart-line fa-spin fa-3x fa-fw" style="--fa-primary-color: #0055A6; --fa-secondary-color: gray;"></i><br>Generating Report <br><small>Please wait</small><span
              class="sr-only">generating...</span></h1>
</div>
<script>
$('#reportLoader').click(function() {
    $('#loadingObject').css('display', 'block');
    var s = $('#sdate').val()
    var e = $('#edate').val()
    var t = $('#type').val()
    if (s == "" || e == "" || t == "") {
        response("danger", "You must set a START and END date with a category to report on")
    } else {
        $.post('includes/finance/reports_data.php', {
            type: t,
            start: s,
            end: e
        }, function(r) {
            if ($.trim(r) !== "error") {
                $('#reportData').html(r)
            }
            if (t != "Outgoings by Category") {
                $('#OptionRow').css('display', 'block');
            }
            $('#loadingObject').css('display', 'none');
        })

    }
})

$('#clientSelect').change(function() {
    var s = $('#sdate').val()
    var e = $('#edate').val()
    var t = $('#type').val()
    var c = $('#clientSelect').val()
    if (s == "" || e == "" || t == "") {
        response("danger", "You must set a START and END date with a category to report on");
        $('#agentSelect').val("").trigger("change.select2");
        $('#brokerSelect').val("").trigger("change.select2");
        $('#clientSelect').val("").trigger("change.select2");
    } else {
        $.post('includes/finance/reports_data.php', {
            type: t,
            start: s,
            end: e,
            client: c
        }, function(r) {
            if ($.trim(r) !== "error") {
                $('#reportData').html(r)
            }
            $('#clientSelect').val("").trigger("change.select2");
        })

    }
})

$('#agentSelect').change(function() {
    var s = $('#sdate').val()
    var e = $('#edate').val()
    var t = $('#type').val()
    var c = $('#agentSelect').val()
    if (s == "" || e == "" || t == "") {
        response("danger", "You must set a START and END date with a category to report on");
        $('#agentSelect').val("").trigger("change.select2");
        $('#brokerSelect').val("").trigger("change.select2");
        $('#clientSelect').val("").trigger("change.select2");
    } else {
        $.post('includes/finance/reports_data.php', {
            type: t,
            start: s,
            end: e,
            agent: c
        }, function(r) {
            if ($.trim(r) !== "error") {
                $('#reportData').html(r)
            }
            $('#agentSelect').val("").trigger("change.select2");
        })

    }
})

$('#brokerSelect').change(function() {
    var s = $('#sdate').val()
    var e = $('#edate').val()
    var t = $('#type').val()
    var c = $('#brokerSelect').val()
    if (s == "" || e == "" || t == "") {
        response("danger", "You must set a START and END date with a category to report on");
        $('#brokerSelect').val("").trigger("change.select2");
        $('#clientSelect').val("").trigger("change.select2");
        $('#agentSelect').val("").trigger("change.select2");
    } else {
        $.post('includes/finance/reports_data.php', {
            type: t,
            start: s,
            end: e,
            broker: c
        }, function(r) {
            if ($.trim(r) !== "error") {
                $('#reportData').html(r)
            }
            $('#brokerSelect').val("").trigger("change.select2");
        })

    }
})


$('#navBox').html(
    '<li class="breadrumb-item"><a href="index.php?t=includes/finance&p=finance_invoices.php">Finance - Invoices</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadrumb-item active">Reports</li>'
)
</script>