<?php require('includes/finance/finance_functions.php');
//////////////////////////
/// PAYMENT STATUS     ///
/// 1 - Unpaid         ///
/// 2 - Reminder       ///
/// 3 - Paid           ///
/// 4 - Refund         ///
/// 5 - Archive        ///
//////////////////////////



$stmt = $GLOBALS['con']->prepare("SELECT * FROM `invoices` WHERE `status`='5' ORDER BY abs(invno) ASC")or die(mysqli_error($GLOBALS['con']));
$stmt->execute();$i=$stmt->get_result();$stmt->close();
while($id=mysqli_fetch_array($i)){$data[]=$id;}
?>

<script>
$('#navBox').html('<li class="breadrumb-item"><a href="index.php?t=includes/finance&p=finance_invoices.php">Finance - Invoices</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadrumb-item active">Voided</li>')
</script>
<div id="invoiceData" class="mt-0 mt-md-n5">

<p class="blockquote reportHeader"><span class="float-right remove"><a class="btn btn-secondary" href="index.php?t=includes/finance&p=invoiceArchive_reports.php"><i class="fal fa-file-invoice"></i> View Reports </a></span>All voided invoices listed by invoice number<br><small class="remove">To filter the results, use the search function</small></p>

<table id="expenseTable" class="table table-striped table-sm responsive" width="100%">
<thead>
<tr><th>Invoice Number</th><th>Client</th><th>Broker/Agent</th><th>Contract Number</th><th>Amount</th><th>Date of Invoice</th><th class="noExport noprint"></th></tr>
</thead>
<tbody>
<?php foreach($data as $id){
$address = unserialize($id['address']);
$items = unserialize($id['items']);
$totals=explode('|',$id['totals']);

$sub=str_replace(',','',$totals[0]);
$vat=str_replace(',','',$totals[1]);
$gtotal=$sub+$vat;
$invno="";
$invno=sprintf("%06d", $id['invNo']);
if(empty($name)){$name= $address['billing_name'];} else{$name= getClientName($id['client']);}
?>
<tr id="R<?php echo $invno?>">
<td><?php echo $invno?></td>
<td><?=$name?></td>
<td><?php echo $address['agent_name']?></td>
<td><?php echo getClientName($id['client'])?></td>
<td>£<?php echo number_format($gtotal,2)?></td>
<td><?php echo date('d-m-Y',$id['date'])?></td>
<td align="right" class="noExport">
<a href="index.php?t=includes/finance&p=finance_preview.php&invNo=<?php echo $id['invNo']?>&type=archive" class="btn btn-secondary" data-toggle="tooltip" data-placement="top" data-original-title="View Invoice"><i class="fal fa-eye"></i></a>

<button type="button" class="btn btn-secondary emailButton functionButtons" data-values="<?php echo $address['client_name']?>|<?php echo $address['billing_name']?>|<?php echo $address['email']?>|<?php echo getCompanyDetails('name_short')?> Invoice |Your invoice reminder for invoice <?php echo $invno?>|invoices/<?php echo $id['invNo']?>_copy.pdf" data-href="includes/master/mailer.php" data-toggle="tooltip" data-placement="top" data-original-title="Email Client Copy"><i class="fal fa-envelope"></i></button>
</td>
</tr>

<?php 
$mTotal=$mTotal+$gtotal;
}?>
</tbody>

</table>
</div>

<div id="exportDiv" style="display: none">
<div id="exportTitle">Voided Invoices - <small>Generated <?php echo date('d-m-Y')?></small></div>
<table id="exportTable" class="table table-striped table-sm responsive" width="100%">
<thead>
<tr><th>Invoice Number</th><th>Client</th><th>Broker/Agent</th><th>Contract Number</th><th>Amount</th><th>Date of Invoice</th></tr>
</thead>
<tbody>
<?php foreach($data as $id){
$address = unserialize($id['address']);
$items = unserialize($id['items']);
$totals=explode('|',$id['totals']);

$sub=str_replace(',','',$totals[0]);
$vat=str_replace(',','',$totals[1]);
$gtotal=$sub+$vat;
$invno="";
$invno=sprintf("%06d", $id['invNo']);
?>
<tr id="R<?php echo $invno?>">
<td><?php echo $invno?></td>
<td><?php echo getClientName($address['client_name'])?></td>
<td><?php echo $address['agent_name']?></td>
<td><?php echo $address['contract_number']?></td>
<td>£<?php echo number_format($gtotal,2)?></td>
<td><?php echo date('d-m-Y',$id['date'])?></td>

</tr>

<?php }?>
</tbody>

</table>

</div>



<div id="genRow" class="col-md-12 text-center remove">
<button id="expenseReport" type="button" class="btn btn-secondary"><i class="fal fa-file-chart-line"></i> GENERATE REPORT</button>
</div>

<?php
$table="expenseTable";
require('includes/single_table.engine');
?>
<div class="spacer"></div>
<div class="alert alert-info float-right">Total Voided:<span class="float-right">£<?php echo number_format($mTotal,2)?></span></div>
<div id="loading"></div>
<script>
function loadInvoice(type,inv){
window.open('invoices/'+inv+'_'+type+'.pdf');
}

$('#expenseTable').on('click', '.emailButton', function(){
$('#popupBox .modal-body').html(''); 
var target = $(this).data('href');
var string = $(this).data('values');
var dest=encodeURI(target+"?mode=popup&data="+string)
$('#popupBox').modal('show');
$('#popupBox .modal-body').load(dest);
})



$('#expenseTable').on('click', '.paidButton', function(){
var str = $(this).data('values');
var d = str.split("|");
confirmBox('Confirm Payment','Are you sure this invoice for <b>'+d[1]+'</b> has been paid?','setPaid(\''+d[0]+'\')')
})



$('#expenseTable').on('click', '.removeButton', function(){
var str = $(this).data('values');
var d = str.split("|");
confirmBox('Archive Invoice','Are you sure this invoice is to be voided?','setArchive(\''+d[0]+'\')')
})

function setPaid(i){
$.post('includes/finance/finance_functions.php',{FUNCTION:'setPaid',inv:i},function(data){
if($.trim(data)=="success"){
var inv=pad(i, 6);
$('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
response('success','The invoice has been set to Paid')
$('#confirmBox').modal('hide')
setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
}
})
}

function setArchive(i){
$.post('includes/finance/finance_functions.php',{FUNCTION:'setArchive',inv:i},function(data){
if($.trim(data)=="success"){
var inv=pad(i, 6);
$('#R'+inv).css({'background-color':'#82e7d2','border':'1px solid #169f85'});
response('success','The invoice has been voided')
$('#confirmBox').modal('hide')
setTimeout(function(){$('#R'+inv).fadeOut();}, 3000);
}
})
}

$('#expenseReport').click(function(){
var start=$('#sdate').val()
var end=$('#edate').val()
data=$('#exportDiv').html()
$.post('includes/engines/report.php',{'clientnumber':'000',type:'invoicesArchived_generated_<?php echo date('d-m-Y')?>',content:data, format:'A4-L'},function(ret){//debug(ret)
$('#genRow').html('<a href="output/reps/000_invoicesArchived_generated_<?php echo date('d-m-Y')?>.pdf" target="blank" class="btn btn-info"><i class="fal fa-file-pdf"></i> VIEW REPORT</a>')
})

})
</script>


