<?php
// Display a header note
echo '<div class="note note-secondary mb-3"><strong>Installation Details</strong></div>';

// Retrieve existing report data if available
$reportData = null;
if (!empty($incomplete_report['master_report_id'])) {
    $query = "SELECT installation_details FROM elec_report WHERE master_report_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("s", $incomplete_report['master_report_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $reportData = $result->fetch_assoc();
    $stmt->close();
}

// Decode JSON stored data
$installation_data = !empty($reportData['installation_details']) ? json_decode($reportData['installation_details'], true) : [];

// Start the form
echo '<form id="installationDetailsForm">';

// Hidden Fields
echo '<input id="board_id" type="hidden" name="board_id" value="' . htmlspecialchars($board_id, ENT_QUOTES, 'UTF-8') . '">';
echo '<input id="report_id" type="hidden" name="report_id" value="' . htmlspecialchars($incomplete_report['report_id'] ?? '', ENT_QUOTES, 'UTF-8') . '">';
echo '<input type="hidden" id="locnumber" name="locnumber" value="' . htmlspecialchars($locnumber, ENT_QUOTES, 'UTF-8') . '">';
?>

<div class="row mb-4 card">
    <div class="card-body">
        <div class="row mb-4">

            <!-- B. REASON FOR PRODUCING THIS REPORT -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">Reason for producing this report</label>
                <input type="text" class="form-control" name="installation_details[reason]" value="<?php echo htmlspecialchars($installation_data['reason'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>

            <div class="form-group col-12 col-md-4">
                <label class="mr-2">Date(s) on which inspection and testing was carried out:</label>
                <input type="text" class="form-control" name="installation_details[inspectionDates]" value="<?php echo htmlspecialchars($installation_data['inspectionDates'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>
        </div>
        <div class="row mb-4">
            <!-- Occupier -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">Occupier</label>
                <select name="installation_details[occupier]" class="form-control" required>
                    <option value="">Select Occupier</option>
                    <option value="Multi Tenanted" <?php echo (isset($installation_data['occupier']) && $installation_data['occupier'] === 'Multi Tenanted') ? 'selected' : ''; ?>>Multi Tenanted</option>
                    <option value="Single Tenant" <?php echo (isset($installation_data['occupier']) && $installation_data['occupier'] === 'Single Tenant') ? 'selected' : ''; ?>>Single Tenant</option>
                    <option value="Sub Let" <?php echo (isset($installation_data['occupier']) && $installation_data['occupier'] === 'Sub Let') ? 'selected' : ''; ?>>Sub Let</option>
                </select>
            </div>

            <!-- Occupier -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">Description of Premises</label>
                <select name="installation_details[premises]" class="form-control" required>
                    <option value="">Select Yype</option>
                    <option value="Residential" <?php echo (isset($installation_data['premises']) && $installation_data['premises'] === 'Residential') ? 'selected' : ''; ?>>Residential</option>
                    <option value="Commercial" <?php echo (isset($installation_data['premises']) && $installation_data['premises'] === 'Commercial') ? 'selected' : ''; ?>>Commercial</option>
                    <option value="Industrial" <?php echo (isset($installation_data['premises']) && $installation_data['premises'] === 'Industrial') ? 'selected' : ''; ?>>Industrial</option>
                </select>
            </div>
        </div>
        <div class="row mb-4">

            <!-- Evidence of Alterations or Additions as Yes/No radios -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">Evidence of Alterations or Additions</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="installation_details[alterations]" id="alterationsYes" value="yes"
                           <?php echo (!empty($installation_data['alterations']) && $installation_data['alterations'] === 'yes') ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="alterationsYes">Yes</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="installation_details[alterations]" id="alterationsNo" value="no"
                           <?php echo (isset($installation_data['alterations']) && $installation_data['alterations'] === 'no') ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="alterationsNo">No</label>
                </div>
            </div>

            <!-- If 'Yes', estimate age (years) -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">If ‘Yes’, estimate age (years)</label>
                <input type="text" class="form-control" name="installation_details[alterations_age]" value="<?php echo htmlspecialchars($installation_data['alterations_age'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>

            <!-- Installation Records -->
            <div class="form-group col-12 col-md-3">
                <label class="mr-2">Installation records available</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="installation_details[records]" id="recordsYes" value="yes"
                           <?php echo (!empty($installation_data['records']) && $installation_data['records'] === 'yes') ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="recordsYes">Yes</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="installation_details[records]" id="recordsNo" value="no"
                           <?php echo (isset($installation_data['records']) && $installation_data['records'] === 'no') ? 'checked' : ''; ?>>
                    <label class="form-check-label" for="recordsNo">No</label>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- Estimated age of the wiring system -->
            <div class="form-group col-12 col-md-4 mb-4">
                <label class="mr-2">Estimated age of the wiring system</label>
                <input type="text" class="form-control" name="installation_details[age]" value="<?php echo htmlspecialchars($installation_data['age'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>

            <!-- District Network Operator (DNO) -->
            <div class="form-group col-12 col-md-4 mb-4">
                <label class="mr-2">District Network Operator (DNO)</label>
                <input type="text" class="form-control" name="installation_details[network]" value="<?php echo htmlspecialchars($installation_data['network'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>

            <!-- Sub-Station Number -->
            <div class="form-group col-12 col-md-4 mb-4">
                <label class="mr-2">Sub-Station Number</label>
                <input type="text" class="form-control" name="installation_details[subStation]" value="<?php echo htmlspecialchars($installation_data['subStation'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
            </div>


        </div>
    </div>
</div>
<div class="row mb-4 card">
    <div class="card-body">
        <!-- Extent of electrical installation -->
        <div class="form-group col-12 col-md-4">
            <label class="mr-2">Extent of electrical installation</label>
            <input type="text" class="form-control" name="installation_details[extent]" value="<?php echo htmlspecialchars($installation_data['extent'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </div>
    </div>
</div>
<div class="row mt-4">
    <div class="d-flex justify-content-between align-items-center mt-4">
        <button type="button" class="btn btn-success" onclick="alertMessage('Confirm Save', 'Are you sure you want to save this stage?', () => saveReportStage(1))">Save Progress</button>
        <button id="markCompleteBtn" type="button" class="btn btn-info mx-auto" onclick="alertMessage('Confirm Completion', 'Are you sure you want to mark this stage as complete?', () => markStageComplete(1))">Mark Complete</button>
        <button id="clearStageBtn" type="button" class="btn btn-danger" onclick="alertMessage('Confirm Clear', 'This will reset all data for this stage. Are you sure?', () => clearStage(1))">Clear all</button>
    </div>
</div>

<?php 
echo '</form>';