<?php
// elec_list.php - Lists all distribution boards for a client

// Include necessary functions for elec_list
require_once(ROOT_URL . '/includes/elec/elec_list_functions.php');

// Assume `clientnumber` is passed in the URL, verify it
$clientnumber = isset($_REQUEST['clientnumber']) ? $_REQUEST['clientnumber'] : 1201;

if ($clientnumber) {
    // Fetch and display all distribution boards for the specified client
    $distros = get_all_distros($clientnumber);

    echo "<div class='container'>";
    echo "<h2 class='text-primary my-4'>Distribution Boards for Client #{$clientnumber}</h2>";
    echo "<button class='btn btn-info mb-4' onclick=\"location.href='index.php?t=includes/master&p=elec.php&view=elec_distro&clientnumber={$clientnumber}'\">Add New Distribution Board</button>";

    echo "<div class='row'>";
    foreach ($distros as $distro) {
        echo "<div class='col-md-4 mb-3'>";
        echo "<div class='card'>";
        echo "<div class='card-body'>";
        echo "<h5 class='card-title'>{$distro['board_name']}</h5>";
        echo "<p class='card-text'>Board ID: {$distro['id']}</p>";
        
        // Pass both distro_id and clientnumber in URLs
        echo "<a href='index.php?t=includes/master&p=elec.php&view=elec_distro&distro_id={$distro['board_id']}&clientnumber={$clientnumber}' class='btn btn-secondary'>Manage Parts</a> ";
        echo "<a href='index.php?t=includes/master&p=elec.php&view=elec_report&distro_id={$distro['board_id']}&clientnumber={$clientnumber}' class='btn btn-success'>Create Report</a>";
        
        echo "</div>";
        echo "</div>";
        echo "</div>";
    }
    echo "</div>"; // Close row
    echo "</div>"; // Close container
} else {
    echo "<div class='alert alert-danger'>Client number is required to view distribution boards.</div>";
}
?>