<?php
// elec_distro_functions.php - Functions for managing parts within a distribution board
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Function to fetch all parts for a specific distribution board
function get_all_parts($distro_id) {
    global $con;

    $query = "SELECT * FROM elec_part WHERE board_id = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("i", $distro_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $parts = [];
    while ($row = $result->fetch_assoc()) {
        $parts[] = $row;
    }
    $stmt->close();
    
    return $parts;
}

function add_new_distro(
    $clientnumber,
    $locnumber,
    $board_name,
    $reference,
    $supply_from,
    $polarity_confirmed,
    $phase_sequence_confirmed,
    $manufacturer,
    $board_type,
    $installation_date,
    $surge_protection_type,
    $surge_protection_part_no,
    $surge_protection_functional,
    $surge_protection_imax,
    $bs_type,
    $rating,
    $poles,
    $associated_rcd,
    $trip_current,
    $trip_time_1x,
    $mccb_type,
    $zdb,
    $pfc_pscc,
    $voltage,
    $circuit_mode
) {
    global $con;

    // Debugging log
    //file_put_contents('debug_add_new_distro.log', "Inputs: " . print_r(func_get_args(), true), FILE_APPEND);

    $query = "INSERT INTO `elec_board`(
    `board_id`,                -- Auto-increment, not part of the query
    `clientnumber`,            -- Placeholder 1
    `locnumber`,               -- Placeholder 2
    `board_name`,              -- Placeholder 3
    `reference`,               -- Placeholder 4
    `supply_from`,             -- Placeholder 5
    `polarity_confirmed`,      -- Placeholder 6
    `phase_sequence_confirmed`,-- Placeholder 7
    `manufacturer`,            -- Placeholder 8
    `board_type`,              -- Placeholder 9
    `surge_protection_type`,   -- Placeholder 10
    `surge_protection_part_no`,-- Placeholder 11
    `surge_protection_functional`, -- Placeholder 12
    `surge_protection_imax`,   -- Placeholder 13
    `bs_type`,                 -- Placeholder 14
    `rating`,                  -- Placeholder 15
    `poles`,                   -- Placeholder 16
    `associated_rcd`,          -- Placeholder 17
    `trip_current`,            -- Placeholder 18
    `trip_time_1x`,            -- Placeholder 19
    `mccb_type`,               -- Placeholder 20
    `zdb`,                     -- Placeholder 21
    `pfc_pscc`,                -- Placeholder 22
    `voltage`,                 -- Placeholder 23
    `installation_date`,       -- Placeholder 24
    `circuit_mode`             -- Placeholder 25
)
VALUES (NULL,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $con->prepare($query);

    if (!$stmt) {
        file_put_contents('debug_add_new_distro.log', "Prepare failed: " . $con->error . PHP_EOL, FILE_APPEND);
        return false;
    }

    $stmt->bind_param(
        "iisssiississdsississddiss", // 25 placeholders
        $clientnumber,               // i
        $locnumber,                  // i
        $board_name,                 // s
        $reference,                  // s
        $supply_from,                // s
        $polarity_confirmed,         // i
        $phase_sequence_confirmed,   // i
        $manufacturer,               // s
        $board_type,                 // s
        $surge_protection_type,      // i
        $surge_protection_part_no,   // s
        $surge_protection_functional,// i
        $surge_protection_imax,      // d
        $bs_type,                    // s
        $rating,                     // i
        $poles,                      // i
        $associated_rcd,             // s
        $trip_current,               // i
        $trip_time_1x,               // d
        $mccb_type,                  // s
        $zdb,                        // d
        $pfc_pscc,                   // d
        $voltage,                    // i
        $installation_date,          // s
        $circuit_mode                // s
    );

    if (!$stmt->execute()) {
        file_put_contents('debug_add_new_distro.log', "Execute failed: " . $stmt->error . PHP_EOL, FILE_APPEND);
        return false;
    }

    $new_board_id = $stmt->insert_id;
    $stmt->close();

    return $new_board_id;
}







function add_new_part($board_id, $part_name, $breaker_type, $cable_size, $rating) {
    global $con;

    $query = "INSERT INTO elec_part (board_id, part_name, breaker_type, cable_size, rating) VALUES (?, ?, ?, ?, ?)";
    $stmt = $con->prepare($query);
    $stmt->bind_param("issss", $board_id, $part_name, $breaker_type, $cable_size, $rating);

    if ($stmt->execute()) {
        $stmt->close();
        return true;
    } else {
        $stmt->close();
        return false;
    }
}

function get_distro_details($board_id) {
    global $con;

    $query = "SELECT * FROM elec_board WHERE board_id = ?";
    $stmt = $con->prepare($query);
    if (!$stmt) {
        error_log("get_distro_details prepare failed: " . $con->error);
        return false;
    }
    $stmt->bind_param("i", $board_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $details = $result->fetch_assoc();
    $stmt->close();
    
    return $details;
}

// Update an existing distribution board with new values
function update_distro(
    $board_id,
    $clientnumber,
    $locnumber,
    $board_name,
    $reference,
    $supply_from,
    $polarity_confirmed,
    $phase_sequence_confirmed,
    $manufacturer,
    $board_type,
    $surge_protection_type,
    $surge_protection_part_no,
    $surge_protection_functional,
    $surge_protection_imax,
    $bs_type,
    $rating,
    $poles,
    $associated_rcd,
    $trip_current,
    $trip_time_1x,
    $mccb_type,
    $zdb,
    $pfc_pscc,
    $voltage,
    $installation_date,
    $circuit_mode
) {
    global $con;

    $query = "UPDATE elec_board SET
        clientnumber = ?,
        locnumber = ?,
        board_name = ?,
        reference = ?,
        supply_from = ?,
        polarity_confirmed = ?,
        phase_sequence_confirmed = ?,
        manufacturer = ?,
        board_type = ?,
        surge_protection_type = ?,
        surge_protection_part_no = ?,
        surge_protection_functional = ?,
        surge_protection_imax = ?,
        bs_type = ?,
        rating = ?,
        poles = ?,
        associated_rcd = ?,
        trip_current = ?,
        trip_time_1x = ?,
        mccb_type = ?,
        zdb = ?,
        pfc_pscc = ?,
        voltage = ?,
        installation_date = ?,
        circuit_mode = ?
        WHERE board_id = ?";

    $stmt = $con->prepare($query);
    if (!$stmt) {
        file_put_contents('debug_update_distro.log', "Prepare failed: " . $con->error . PHP_EOL, FILE_APPEND);
        return false;
    }

    // Bind parameters – note that we have 25 fields plus the board_id (total 26)
    $stmt->bind_param(
        "iisssiississdsississddissi",
        $clientnumber,
        $locnumber,
        $board_name,
        $reference,
        $supply_from,
        $polarity_confirmed,
        $phase_sequence_confirmed,
        $manufacturer,
        $board_type,
        $surge_protection_type,
        $surge_protection_part_no,
        $surge_protection_functional,
        $surge_protection_imax,
        $bs_type,
        $rating,
        $poles,
        $associated_rcd,
        $trip_current,
        $trip_time_1x,
        $mccb_type,
        $zdb,
        $pfc_pscc,
        $voltage,
        $installation_date,
        $circuit_mode,
        $board_id
    );

    if (!$stmt->execute()) {
        file_put_contents('debug_update_distro.log', "Execute failed: " . $stmt->error . PHP_EOL, FILE_APPEND);
        return false;
    }
    $stmt->close();
    return true;
}
?>