<?php
ob_start();
require_once(ROOT_URL . '/includes/elec/elec_distro_functions.php');



// Prepare friendly names (for example, for surge protection type)
$surgeProtectionTypes = [ 1 => "Type 1", 2 => "Type 2", 3 => "Type 3" ];
$surgeType = isset($surgeProtectionTypes[$board['surge_protection_type']]) ? $surgeProtectionTypes[$board['surge_protection_type']] : "N/A";
?>
<!-- Ensure MDBootstrap CSS & JS are loaded in your layout, for example:
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/6.2.0/mdb.min.css" />
     <script src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/6.2.0/mdb.min.js"></script>
-->

<!-- CSS to center the toggle button and position the details container -->
<style>
/* Centered fixed button at the top */
#toggleBoardDetails {
    position: fixed;
    top: 10px;
    left: 50%;
    transform: translateX(-50%);
    z-index: 1050;
}

/* Fixed collapsible container positioned below the button */
#boardDetailsContainer {
    position: fixed;
    top: 60px;
    /* Adjust if needed */
    left: 50%;
    transform: translateX(-50%);
    width: 90%;
    max-width: 800px;
    z-index: 1040;
}
</style>

<!-- Toggle Button using MDBootstrap's data attributes -->
<button id="toggleBoardDetails" class="btn btn-primary" type="button" data-mdb-toggle="collapse" data-mdb-target="#boardDetailsContainer" aria-expanded="false" aria-controls="boardDetailsContainer">
    Board Details
</button>

<!-- Collapsible Container -->
<div class="collapse" id="boardDetailsContainer">
    <div class="card">
        <div class="card-body">
            <h4 class="mb-3">Distribution Board Details</h4>
            <ul class="list-group">
                <li class="list-group-item"><strong>Board Name:</strong> <?= htmlspecialchars($board['board_name']); ?></li>
                <li class="list-group-item"><strong>Reference:</strong> <?= htmlspecialchars($board['reference']); ?></li>
                <li class="list-group-item"><strong>Supply From:</strong> <?= htmlspecialchars($board['supply_from']); ?></li>
                <li class="list-group-item"><strong>Manufacturer:</strong> <?= htmlspecialchars($board['manufacturer']); ?></li>
                <li class="list-group-item"><strong>Board Type:</strong> <?= htmlspecialchars($board['board_type']); ?></li>
                <li class="list-group-item"><strong>Installation Date:</strong> <?= htmlspecialchars($board['installation_date']); ?></li>
                <li class="list-group-item"><strong>Surge Protection Type:</strong> <?= htmlspecialchars($surgeType); ?></li>
                <!-- Add more fields as needed -->
            </ul>
        </div>
    </div>
</div>

<?php
ob_end_flush();
?>