<?php $stmt = $GLOBALS['con']->prepare("SELECT * FROM `brokers` WHERE `broker_number`=?")or die(mysqli_error($GLOBALS['con']));
$stmt->bind_param('i',$_REQUEST['broker_number']);$stmt->execute();$r=$stmt->get_result();$stmt->close();
$cd=mysqli_fetch_array($r);

$email_values = [
    0 => '0', //client
    1 => $cd['broker_name'], //type
    2 => $cd['email'], //recipient
    3 => '', //subject
    4 => '', //message
    5 => '', //attachment
    6 => '' //source
];
$email64_values = base64_encode(json_encode($email_values));
?>

<div class="row mb-4">
    <div class="col-12 col-md-12">
        <div class="float-end">
            <a id="phone" href="tel:<?= $cd['phone1']?>" class="btn btn-secondary noprint me-2"><i class="fad fa-phone"></i></a>
            <?php if(!filter_var($cd['email'], FILTER_VALIDATE_EMAIL) === false) {?>
            <a href="javascript:void(0)" class="btn btn-secondary emailButton me-2"
               data-values="<?= $email64_values?>" data-href="<?=ROOT_URL?>/includes/master/mailer.php"><i class="fad fa-envelope"></i></a>
            <?php }if($cd['statuslive']==1){?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Archive <?= $cd['agent_name']?>" href="javascript:void(0)"
               onClick="archiveBroker('<?= $cd['broker_number']?>')"
               class="btn btn-secondary me-2"><i class="fad fa-archive"></i></a>
            <?php } else {?>
            <a data-mdb-tooltip-init data-mdb-placement="bottom" data-mdb-trigger="hover" data-mdb-trigger="hover" title="Archive <?= $cd['agent_name']?>" href="javascript:void(0)"
               onClick="reinstateBroker('<?= $cd['broker_number']?>')"
               class="btn btn-secondary"><i class="fad fa-upload"></i></a>
            <?php }?>
        </div>
    </div>
</div>
<form id="brokerForm" class="form-horizontal">
    <fieldset>
        <?php require_once(ROOT_URL.'/forms/elements/broker_details.frm');?>


        <div class="row">
            <div class="col-12 col-md-4 text-center">
                <div class="card">
                    <div class="card-header">Active</div>
                    <div class="card-body">
                        <div class="form-group row">
                            <?php if($cd['statuslive']=="1" || $_REQUEST['view']=="new"){$checked="checked";}if($cd['statuslive']=="0"){$checked="";}?>
                            <label class="col-12 col-md-3 control-label" for="statuslive">Live broker</label>
                            <div class="col-12 col-md-9">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="statuslive" id="statuslive" <?= $checked?>>
                                    <label class="form-check-label" for="statuslive"></label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-12 col-md-12 text-center">
                <div class="form-group text-center">
                    <input type="hidden" name="broker_number" value="<?= $_REQUEST['broker_number']?>">
                    <input type="hidden" name="FUNCTION" value="update">
                    <input type="hidden" name="tenant" value="<?=TENANT_URL?>">
                    <input id="btn_update" type="submit" name="submit" value="Update" style="display:none" />
                </div>
            </div>
    </fieldset>
</form>

<div class="spacer"></div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    document.getElementById('footerControls').innerHTML = '<button class="btn btn-secondary" onclick="triggerAction(\'btn_update\')">UPDATE</button>';
    document.getElementById('navBox').innerHTML =
        '<li class="breadcrumb-item"><a href="index.php?t=includes/master&p=broker.php&view=list">Brokers</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><li class="breadcrumb-item active"><a href="javascript:void(0)">Edit Broker</a><i class="fad fa-angle-double-right mx-2 mt-1"" aria-hidden="true"></i></li><a href="javascript:void(0)"><?= $cd['broker_name']?></a></li>'

})

function archiveBroker(i) {
    var dest = '<p>Do you wish to archive this broker?</p>';
    loadModalContent(dest, "archiveBox", "modal-lg", 1060, "true", "Convert to Agent", "cancelConfirm", () => archiveBrokerAction(i));
}

function archiveBrokerAction(id) {
    fetch(ROOT_URL + '/includes/broker/broker_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "archive",
                id: id,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {
            window.location.href = 'index.php?t=includes/master&p=broker.php&view=list';
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function reinstateBroker(i) {
    var dest = '<p>Do you wish to reinstate this broker?</p>';
    loadModalContent(dest, "reinstateBox", "modal-lg", 1060, "true", "Convert to Agent", "cancelConfirm", () => reinstateBrokerAction(i));
}

function reinstateBrokerAction(id) {
    fetch(ROOT_URL + '/includes/broker/broker_functions.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                FUNCTION: "reinstate",
                id: id,
                tenant: TENANT_URL
            })
        })
        .then(response => response.text())
        .then(result => {
            // Handle the result (you can debug if needed)
            window.location.href = 'index.php?t=includes/master&p=broker.php&view=list';
        })
        .catch(error => {
            console.error('Error:', error);
        });
}
</script>